/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X25519SecretBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.bcpg.X448SecretBCPGKey;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class JcaPGPKeyConverter
extends PGPKeyConverter {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private KeyFingerPrintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();

    public JcaPGPKeyConverter setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyConverter setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        BCPGKey bCPGKey = this.getPrivateBCPGKey(pGPPublicKey, privateKey);
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), bCPGKey);
    }

    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        BCPGKey bCPGKey = this.getPublicBCPGKey(n, pGPAlgorithmParameters, publicKey);
        return new PGPPublicKey(new PublicKeyPacket(n, date, bCPGKey), this.fingerPrintCalculator);
    }

    public PGPPublicKey getPGPPublicKey(int n, PublicKey publicKey, Date date) throws PGPException {
        return this.getPGPPublicKey(n, null, publicKey, date);
    }

    public PrivateKey getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (pGPPrivateKey instanceof JcaPGPPrivateKey) {
            return ((JcaPGPPrivateKey)pGPPrivateKey).getPrivateKey();
        }
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSASecretBCPGKey.getX(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    return this.implGeneratePrivate("DSA", dSAPrivateKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    if (CryptlibObjectIdentifiers.curvey25519.equals(eCDHPublicBCPGKey.getCurveOID())) {
                        return this.implGeneratePrivate("XDH", () -> this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(((ECSecretBCPGKey)bCPGKey).getX()))));
                    }
                    return this.implGetPrivateKeyEC("ECDH", eCDHPublicBCPGKey, eCSecretBCPGKey);
                }
                case 25: {
                    return this.implGeneratePrivate("XDH", () -> this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, 32, Arrays.reverseInPlace(bCPGKey.getEncoded())));
                }
                case 26: {
                    return this.implGeneratePrivate("XDH", () -> this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, 56, Arrays.reverseInPlace(bCPGKey.getEncoded())));
                }
                case 19: {
                    return this.implGetPrivateKeyEC("ECDSA", (ECDSAPublicBCPGKey)publicKeyPacket.getKey(), (ECSecretBCPGKey)bCPGKey);
                }
                case 22: {
                    return this.implGeneratePrivate("EdDSA", () -> this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, BigIntegers.asUnsignedByteArray(32, ((EdSecretBCPGKey)bCPGKey).getX())));
                }
                case 27: {
                    return this.implGeneratePrivate("EdDSA", () -> this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, 32, bCPGKey.getEncoded()));
                }
                case 28: {
                    return this.implGeneratePrivate("EdDSA", () -> this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, 57, bCPGKey.getEncoded()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(elGamalSecretBCPGKey.getX(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    return this.implGeneratePrivate("ElGamal", dHPrivateKeySpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                    return this.implGeneratePrivate("RSA", rSAPrivateCrtKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKeyPacket.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public PublicKey getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    return this.implGeneratePublic("DSA", dSAPublicKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                        return this.get25519PublicKey(eCDHPublicBCPGKey.getEncodedPoint(), EdECObjectIdentifiers.id_X25519, "XDH", "Curve");
                    }
                    return this.implGetPublicKeyEC("ECDH", eCDHPublicBCPGKey);
                }
                case 25: {
                    return this.implGetPublicKeyX509(publicKeyPacket.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_X25519, "XDH");
                }
                case 26: {
                    return this.implGetPublicKeyX509(publicKeyPacket.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_X448, "XDH");
                }
                case 19: {
                    return this.implGetPublicKeyEC("ECDSA", (ECDSAPublicBCPGKey)publicKeyPacket.getKey());
                }
                case 22: {
                    return this.get25519PublicKey(((EdDSAPublicBCPGKey)publicKeyPacket.getKey()).getEncodedPoint(), EdECObjectIdentifiers.id_Ed25519, "EdDSA", "Ed");
                }
                case 27: {
                    BCPGKey bCPGKey = publicKeyPacket.getKey();
                    if (bCPGKey instanceof Ed25519PublicBCPGKey) {
                        return this.implGetPublicKeyX509(BigIntegers.asUnsignedByteArray(new BigInteger(1, publicKeyPacket.getKey().getEncoded())), 0, EdECObjectIdentifiers.id_Ed25519, "EdDSA");
                    }
                    return this.implGetPublicKeyX509(BigIntegers.asUnsignedByteArray(((EdDSAPublicBCPGKey)publicKeyPacket.getKey()).getEncodedPoint()), 0, EdECObjectIdentifiers.id_Ed25519, "EdDSA");
                }
                case 28: {
                    return this.implGetPublicKeyX509(BigIntegers.asUnsignedByteArray(new BigInteger(1, publicKeyPacket.getKey().getEncoded())), 0, EdECObjectIdentifiers.id_Ed448, "EdDSA");
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(elGamalPublicBCPGKey.getY(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    return this.implGeneratePublic("ElGamal", dHPublicKeySpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    return this.implGeneratePublic("RSA", rSAPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKeyPacket.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParameters x9ECParameters) throws InvalidParameterSpecException, NoSuchProviderException, NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
        algorithmParameters.init(new ECGenParameterSpec(ECNamedCurveTable.getName(aSN1ObjectIdentifier)));
        return algorithmParameters.getParameterSpec(ECParameterSpec.class);
    }

    private BCPGKey getPrivateBCPGKey(PrivateKey privateKey, BCPGKeyOperation bCPGKeyOperation) throws PGPException {
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(privateKey.getEncoded());
        try {
            return bCPGKeyOperation.getBCPGKey(ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets());
        }
        catch (IOException iOException) {
            throw new PGPException(iOException.getMessage(), iOException);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        switch (pGPPublicKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
                return new DSASecretBCPGKey(dSAPrivateKey.getX());
            }
            case 18: {
                if (privateKey instanceof ECPrivateKey) {
                    ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                    return new ECSecretBCPGKey(eCPrivateKey.getS());
                }
                return this.getPrivateBCPGKey(privateKey, (byte[] byArray) -> new ECSecretBCPGKey(new BigInteger(1, Arrays.reverse(byArray))));
            }
            case 25: {
                return this.getPrivateBCPGKey(privateKey, (byte[] byArray) -> new X25519SecretBCPGKey(Arrays.reverse(byArray)));
            }
            case 26: {
                return this.getPrivateBCPGKey(privateKey, (byte[] byArray) -> new X448SecretBCPGKey(Arrays.reverse(byArray)));
            }
            case 19: {
                return new ECSecretBCPGKey(((ECPrivateKey)privateKey).getS());
            }
            case 22: {
                return this.getPrivateBCPGKey(privateKey, (byte[] byArray) -> new EdSecretBCPGKey(new BigInteger(1, byArray)));
            }
            case 27: {
                return this.getPrivateBCPGKey(privateKey, Ed25519SecretBCPGKey::new);
            }
            case 28: {
                return this.getPrivateBCPGKey(privateKey, Ed448SecretBCPGKey::new);
            }
            case 16: 
            case 20: {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
                return new ElGamalSecretBCPGKey(dHPrivateKey.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                return new RSASecretBCPGKey(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ());
            }
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey) throws PGPException {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            return new RSAPublicBCPGKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            return new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), dSAPublicKey.getY());
        }
        if (publicKey instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            return new ElGamalPublicBCPGKey(dHParameterSpec.getP(), dHParameterSpec.getG(), dHPublicKey.getY());
        }
        if (publicKey instanceof ECPublicKey) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            X9ECParametersHolder x9ECParametersHolder = ECNamedCurveTable.getByOIDLazy(aSN1ObjectIdentifier);
            DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            X9ECPoint x9ECPoint = new X9ECPoint(x9ECParametersHolder.getCurve(), dEROctetString);
            if (n == 18) {
                PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(aSN1ObjectIdentifier, pGPAlgorithmParameters);
                return new ECDHPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            }
            if (n == 19) {
                return new ECDSAPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint());
            }
            throw new PGPException("unknown EC algorithm");
        }
        if (n == 27) {
            return this.getPublicBCPGKey(publicKey, 32, Ed25519PublicBCPGKey::new);
        }
        if (publicKey.getAlgorithm().regionMatches(true, 0, "ED2", 0, 3)) {
            return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, this.getPointEncUncompressed(publicKey, 32)));
        }
        if (n == 25) {
            return this.getPublicBCPGKey(publicKey, 32, X25519PublicBCPGKey::new);
        }
        if (publicKey.getAlgorithm().regionMatches(true, 0, "X2", 0, 2)) {
            PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, pGPAlgorithmParameters);
            return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, this.getPointEncUncompressed(publicKey, 32)), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
        }
        if (n == 28) {
            return this.getPublicBCPGKey(publicKey, 57, Ed448PublicBCPGKey::new);
        }
        if (n == 26) {
            return this.getPublicBCPGKey(publicKey, 56, X448PublicBCPGKey::new);
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(PublicKey publicKey, int n, BCPGKeyOperation bCPGKeyOperation) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        byte[] byArray = new byte[n];
        System.arraycopy(subjectPublicKeyInfo.getPublicKeyData().getBytes(), 0, byArray, 0, byArray.length);
        return bCPGKeyOperation.getBCPGKey(byArray);
    }

    private byte[] getPointEncUncompressed(PublicKey publicKey, int n) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        byte[] byArray = new byte[1 + n];
        byArray[0] = 64;
        System.arraycopy(subjectPublicKeyInfo.getPublicKeyData().getBytes(), 0, byArray, 1, byArray.length - 1);
        return byArray;
    }

    private PrivateKey implGeneratePrivate(String string, Operation operation) throws GeneralSecurityException, PGPException, IOException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(operation.getPrivateKeyInfo().getEncoded());
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    private PrivateKey implGeneratePrivate(String string, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey implGeneratePublic(String string, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePublic(keySpec);
    }

    private PublicKey implGetPublicKeyX509(byte[] byArray, int n, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) throws IOException, PGPException, GeneralSecurityException {
        return this.implGeneratePublic(string, new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange(byArray, n, byArray.length)).getEncoded()));
    }

    private PrivateKey implGetPrivateKeyEC(String string, ECPublicBCPGKey eCPublicBCPGKey, ECSecretBCPGKey eCSecretBCPGKey) throws GeneralSecurityException, PGPException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCSecretBCPGKey.getX(), this.getECParameterSpec(aSN1ObjectIdentifier, JcaJcePGPUtil.getX9Parameters(aSN1ObjectIdentifier)));
        return this.implGeneratePrivate(string, eCPrivateKeySpec);
    }

    private PublicKey implGetPublicKeyEC(String string, ECPublicBCPGKey eCPublicBCPGKey) throws GeneralSecurityException, IOException, PGPException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        X9ECParameters x9ECParameters = JcaJcePGPUtil.getX9Parameters(aSN1ObjectIdentifier);
        org.bouncycastle.math.ec.ECPoint eCPoint = JcaJcePGPUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(aSN1ObjectIdentifier, x9ECParameters));
        return this.implGeneratePublic(string, eCPublicKeySpec);
    }

    private PublicKey get25519PublicKey(BigInteger bigInteger, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, String string2) throws PGPException, GeneralSecurityException, IOException {
        byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
        if (byArray.length < 1 || 64 != byArray[0]) {
            throw new IllegalArgumentException("Invalid " + string2 + "25519 public key");
        }
        return this.implGetPublicKeyX509(byArray, 1, aSN1ObjectIdentifier, string);
    }

    @FunctionalInterface
    private static interface BCPGKeyOperation {
        public BCPGKey getBCPGKey(byte[] var1);
    }

    @FunctionalInterface
    private static interface Operation {
        public PrivateKeyInfo getPrivateKeyInfo() throws IOException;
    }
}

