/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ejbcontainer.mdb.MDBMessageEndpointFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.DispatchableMessage;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.pacing.AsynchDispatchScheduler;
import com.ibm.wsspi.sib.pacing.MessagePacingControl;
import com.ibm.wsspi.sib.pacing.MessagePacingControlFactory;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class SibRaDispatcher {
    private volatile boolean _cancelled = false;
    protected final SICoreConnection _connection;
    protected final SibRaMessagingEngineConnection _meConnection;
    protected final AbstractConsumerSession _session;
    protected final MessageEndpointFactory _endpointFactory;
    protected final SibRaEndpointInvoker _invoker;
    protected final SibRaEndpointConfiguration _endpointConfiguration;
    protected boolean _deleteUnrecoverableMessages;
    protected Reliability _unrecoverableReliability;
    protected HashMap _reliabilityPreInvoke = new HashMap();
    private static String _debugMEName = null;
    private int _maxFailedDeliveries;
    private int _sequentialFailureMessageCount = 0;
    private int _sequentialFailureThreshold;
    private static TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaDispatcher.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaDispatcher.class.getName();
    private Class _mepClass;
    private Method _mepGetJ2EEMethod;
    private String _mepJ2EEName;

    static void resetMEName() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Resetting MEName");
        }
        _debugMEName = null;
    }

    SibRaDispatcher(SibRaMessagingEngineConnection connection, AbstractConsumerSession session, SibRaEndpointActivation endpointActivation, Reliability unrecoveredReliability, int maxFailedDeliveries, int sequentialFailureThreshold) throws ResourceException {
        String methodName = "SibRaDispatcher";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaDispatcher", (Object)new Object[]{connection, session, endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold});
        }
        this._deleteUnrecoverableMessages = false;
        this._meConnection = connection;
        this._connection = connection.getConnection();
        this._session = session;
        this._endpointConfiguration = endpointActivation.getEndpointConfiguration();
        this._invoker = endpointActivation.getEndpointInvoker();
        this._endpointFactory = endpointActivation.getMessageEndpointFactory();
        this._unrecoverableReliability = unrecoveredReliability;
        this._sequentialFailureThreshold = sequentialFailureThreshold;
        this._maxFailedDeliveries = maxFailedDeliveries;
        if (_debugMEName == null) {
            _debugMEName = "";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("MEName set to " + _debugMEName));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaDispatcher");
        }
    }

    private boolean isCancelled() {
        return this._cancelled || this._meConnection.isClosed();
    }

    /*
     * Exception decompiling
     */
    synchronized void dispatch(SIMessageHandle messageHandle, SIBusMessage message, Map handlerContext) throws ResourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 15[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void dispatch(List messages, AsynchDispatchScheduler scheduler, SibRaListener listener) throws ResourceException {
        String methodName = "dispatch";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"dispatch", (Object)new Object[]{messages, scheduler, listener});
        }
        if (this._session == null) {
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!TRACE.isEntryEnabled()) return;
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"dispatch");
            return;
        }
        ArrayList undeliveredDispatchableMessages = new ArrayList(messages);
        MessageEndpoint endpoint = null;
        try {
            endpoint = this.createEndpoint();
            SIDestinationAddress destination = this._session.getDestinationAddress();
            String busName = destination.getBusName();
            String meName = this._connection.getMeName();
            String destinationName = destination.getDestinationName();
            String messageSelector = this._endpointConfiguration.getMessageSelector();
            ActivationSpec activationSpec = this._endpointConfiguration.getActivationSpec();
            Iterator iterator = messages.iterator();
            while (iterator.hasNext() && !this.isCancelled()) {
                boolean bl;
                DispatchableMessage dispatchableMessage = (DispatchableMessage)iterator.next();
                SIBusMessage message = dispatchableMessage.getMessage();
                boolean success = false;
                try {
                    this.beforeDelivery(message, endpoint);
                    undeliveredDispatchableMessages.remove(dispatchableMessage);
                    try {
                        MessagePacingControl mpc = MessagePacingControlFactory.getInstance();
                        if (mpc != null && mpc.isActive()) {
                            mpc.preMdbInvoke((Object)this, scheduler);
                        }
                        this._reliabilityPreInvoke.put(message.getMessageHandle(), message.getReliability());
                        success = this._invoker.invokeEndpoint(endpoint, message, this._session, this.getTransaction(), _debugMEName);
                        if (mpc != null && mpc.isActive()) {
                            mpc.postMdbInvoke((Object)this, scheduler);
                        }
                    }
                    finally {
                        this.afterDelivery(message, endpoint, success);
                    }
                    boolean tranRolledBack = this.isTransactionRolledBack();
                    bl = success && !tranRolledBack;
                }
                catch (Throwable throwable) {
                    boolean tranRolledBack = this.isTransactionRolledBack();
                    boolean bl2 = success = success && !tranRolledBack;
                    if (success) {
                        this.clearSequentialFailureMessageCount();
                        throw throwable;
                    }
                    if (message != null && ((JsMessage)message).getRedeliveredCount() != null) {
                        if (((JsMessage)message).getRedeliveredCount() + 1 != this._maxFailedDeliveries - 1) throw throwable;
                        this.addToSequentialFailureMessageCount();
                        throw throwable;
                    }
                    if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                    if (!TRACE.isDebugEnabled()) throw throwable;
                    if (null == message) {
                        SibTr.debug((TraceComponent)TRACE, (String)"The message was null");
                        throw throwable;
                    }
                    SibTr.debug((TraceComponent)TRACE, (String)("Unable to obtain the redelivered count from message " + message));
                    throw throwable;
                }
                success = bl;
                if (success) {
                    this.clearSequentialFailureMessageCount();
                    continue;
                }
                if (message != null && ((JsMessage)message).getRedeliveredCount() != null) {
                    if (((JsMessage)message).getRedeliveredCount() + 1 != this._maxFailedDeliveries - 1) continue;
                    this.addToSequentialFailureMessageCount();
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
                if (null == message) {
                    SibTr.debug((TraceComponent)TRACE, (String)"The message was null");
                    continue;
                }
                SibTr.debug((TraceComponent)TRACE, (String)("Unable to obtain the redelivered count from message " + message));
            }
        }
        finally {
            block37: {
                this.cleanup();
                try {
                    if (undeliveredDispatchableMessages.size() <= 0) break block37;
                    try {
                        if (this._deleteUnrecoverableMessages) {
                            Iterator iterator = undeliveredDispatchableMessages.iterator();
                            while (iterator.hasNext()) {
                                DispatchableMessage dispatchableMsg = (DispatchableMessage)iterator.next();
                                SIBusMessage msg = dispatchableMsg.getMessage();
                                if (this._unrecoverableReliability.compareTo((Object)msg.getReliability()) < 0) continue;
                                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Removing the following message as it has already been deleted: ", (Object)msg);
                                }
                                iterator.remove();
                            }
                        }
                        if (undeliveredDispatchableMessages.size() > 0) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Unlocking undelivered messages:", undeliveredDispatchableMessages);
                            }
                            this.unlockMessages(undeliveredDispatchableMessages, false);
                        }
                    }
                    catch (ResourceException exception) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                        }
                    }
                }
                finally {
                    if (endpoint != null) {
                        endpoint.release();
                    }
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!TRACE.isEntryEnabled()) return;
        SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"dispatch");
    }

    void close() {
        String methodName = "close";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
        }
        this._cancelled = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    void cancel() {
        String methodName = "cancel";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cancel");
        }
        this._cancelled = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cancel");
        }
    }

    protected final void unlockMessages(List messageList, boolean incrementDeliveryCount) throws ResourceException {
        String methodName = "unlockMessages";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"unlockMessages", (Object)messageList);
        }
        if (messageList.size() > 0) {
            ArrayList<SIBusMessage> listOfSIBusMessages = new ArrayList<SIBusMessage>();
            try {
                for (int i = 0; i < messageList.size(); ++i) {
                    listOfSIBusMessages.add(((DispatchableMessage)messageList.get(i)).getMessage());
                }
                this._session.unlockSet(SibRaDispatcher.getMessageHandles(listOfSIBusMessages), incrementDeliveryCount);
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "unlockMessages"), (String)"1:1200:1.73", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNLOCK_EXCEPTION_CWSIV0601", new Object[]{exception, listOfSIBusMessages}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "unlockMessages"), (String)"1:1212:1.73", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNLOCK_EXCEPTION_CWSIV0601", new Object[]{exception, listOfSIBusMessages}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"unlockMessages");
        }
    }

    protected final SIBusMessage readAndDeleteMessage(SIMessageHandle handle, SITransaction transaction) throws ResourceException, SIMessageNotLockedException {
        String methodName = "deleteMessage";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deleteMessage", (Object)new Object[]{handle, transaction});
        }
        SIBusMessage message = null;
        if (this._session instanceof BifurcatedConsumerSession) {
            try {
                SIBusMessage[] messageList;
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"We have a bifucated consumer session so attempting to perform readAndDelete");
                }
                if ((messageList = ((BifurcatedConsumerSession)this._session).readAndDeleteSet(new SIMessageHandle[]{handle}, transaction)).length != 1) {
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("MESSAGE_LIST_INCORRECT_CWSIV0607", new Object[]{"" + messageList.length, messageList, handle, transaction}, null));
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Getting the message from the message list");
                }
                message = messageList[0];
            }
            catch (SIMessageNotLockedException exception) {
                throw exception;
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "deleteMessage"), (String)"1:1292:1.73", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_EXCEPTION_CWSIV0608", new Object[]{exception, handle, transaction}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "deleteMessage"), (String)"1:1303:1.73", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_EXCEPTION_CWSIV0608", new Object[]{exception, handle, transaction}, null), (Throwable)exception);
            }
        } else {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("INVALID_SESSION_CWSIV0606", new Object[]{this._session, handle, transaction, BifurcatedConsumerSession.class.getName()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deleteMessage", (Object)message);
        }
        return message;
    }

    protected final void deleteMessage(SIBusMessage message, SITransaction transaction) throws ResourceException {
        String methodName = "deleteMessage";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deleteMessage", (Object)new Object[]{message, transaction});
        }
        this.deleteMessages(new SIMessageHandle[]{message.getMessageHandle()}, transaction);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deleteMessage");
        }
    }

    protected final void deleteMessages(SIMessageHandle[] handles, SITransaction transaction) throws ResourceException {
        String methodName = "deleteMessages";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deleteMessages", (Object)new Object[]{handles, transaction});
        }
        try {
            this._session.deleteSet(handles, transaction);
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "deleteMessages"), (String)"1:1372:1.73", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_SET_EXCEPTION_CWSIV0603", new Object[]{exception, handles, transaction}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "deleteMessages"), (String)"1:1385:1.73", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_SET_EXCEPTION_CWSIV0603", new Object[]{exception, handles, transaction}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deleteMessages");
        }
    }

    protected static final SIMessageHandle[] getMessageHandles(List messageList) {
        String methodName = "getMessageIds";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getMessageIds", (Object)messageList);
        }
        SIMessageHandle[] msgHandles = new SIMessageHandle[messageList.size()];
        for (int i = 0; i < messageList.size(); ++i) {
            SIBusMessage message = (SIBusMessage)messageList.get(i);
            msgHandles[i] = message.getMessageHandle();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getMessageIds", (Object)msgHandles);
        }
        return msgHandles;
    }

    protected abstract SITransaction getTransaction() throws ResourceException;

    protected abstract MessageEndpoint createEndpoint() throws ResourceException;

    protected abstract void beforeDelivery(SIBusMessage var1, MessageEndpoint var2) throws ResourceException;

    abstract SIBusMessage readMessage(SIMessageHandle var1) throws ResourceException, SIMessageNotLockedException;

    protected abstract void beforeDelivery(MessageEndpoint var1) throws ResourceException;

    protected abstract void afterDelivery(SIBusMessage var1, MessageEndpoint var2, boolean var3) throws ResourceException;

    protected abstract void cleanup();

    public final String toString() {
        return this.getStringGenerator().getStringRepresentation();
    }

    protected boolean isTransactionRolledBack() {
        return false;
    }

    protected void increaseRetryCount(SIMessageHandle msgHandle) {
        block4: {
            String methodName = "increaseRetryCount";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"increaseRetryCount");
            }
            try {
                SIUncoordinatedTransaction localTran = this._connection.createUncoordinatedTransaction();
                this.deleteMessages(new SIMessageHandle[]{msgHandle}, (SITransaction)localTran);
                localTran.rollback();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "increaseRetryCount"), (String)"1:1547:1.73", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) break block4;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"increaseRetryCount");
        }
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addField("cancelled", this._cancelled);
        generator.addField("connection", this._connection);
        generator.addField("session", this._session);
        generator.addField("endpointFactory", this._endpointFactory);
        generator.addField("invoker", this._invoker);
        generator.addField("endpointConfiguration", this._endpointConfiguration);
        generator.addField("requestMetries", null);
        return generator;
    }

    private void addToSequentialFailureMessageCount() {
        String methodName = "addToSequentialFailureMessageCount";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addToSequentialFailureMessageCount");
        }
        ++this._sequentialFailureMessageCount;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("_sequentialFailureMessageCount is: " + this._sequentialFailureMessageCount));
        }
        if (this._sequentialFailureMessageCount == this._sequentialFailureThreshold) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Reached threshold of : " + this._sequentialFailureThreshold + " warning user"));
            }
            this.warnUserOfSequentialMessageFailure();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addToSequentialFailureMessageCount");
        }
    }

    private void warnUserOfSequentialMessageFailure() {
        block5: {
            String methodName = "warnUserOfSequentialMessageFailure";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"warnUserOfSequentialMessageFailure");
            }
            try {
                this._mepJ2EEName = ((MDBMessageEndpointFactory)this._endpointFactory).getMDBKey().toString();
                if (null != this._mepJ2EEName) {
                    SibTr.warning((TraceComponent)TRACE, (String)NLS.getFormattedMessage("MESSAGE_ENDPOINT_SHOULD_BE_DEACTIVATED_CWSIV0605", new Object[]{this._mepJ2EEName, this._session.getDestinationAddress()}, null));
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + "." + "warnUserOfSequentialMessageFailure"), (String)"1:1650:1.73", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) break block5;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)ex);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"warnUserOfSequentialMessageFailure");
        }
    }

    private void clearSequentialFailureMessageCount() {
        String methodName = "clearSequentialFailureMessageCount";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"clearSequentialFailureMessageCount");
        }
        this._sequentialFailureMessageCount = 0;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"clearSequentialFailureMessageCount");
        }
    }
}

