/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.authorization.jacc.internal.proxy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.authorization.jacc.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.common.PolicyContextUtil;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.security.authorization.jacc.ProviderService;
import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PolicyFactoryImpl
extends PolicyFactory {
    private static final ComponentMetaDataAccessorImpl cmdAccessor;
    private final PolicyFactory wrapped;
    private final Map<String, Policy> policyMap;
    private final WsLocationAdmin locationAdmin;
    private final PolicyConfigurationManager pcm;
    final ProviderService providerService;
    static final long serialVersionUID = -5233442902928226480L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    PolicyFactoryImpl(WsLocationAdmin locationAdmin, ProviderService providerService, PolicyConfigurationManager pcm) {
        this.wrapped = null;
        this.locationAdmin = locationAdmin;
        this.providerService = providerService;
        this.pcm = pcm;
        this.policyMap = new ConcurrentHashMap<String, Policy>();
    }

    PolicyFactoryImpl(PolicyFactory wrapped, WsLocationAdmin locationAdmin, ProviderService providerService, PolicyConfigurationManager pcm) {
        super(wrapped);
        this.wrapped = wrapped;
        this.locationAdmin = locationAdmin;
        this.providerService = providerService;
        this.pcm = pcm;
        this.policyMap = wrapped == null ? new ConcurrentHashMap() : null;
    }

    private String getContextIdFromComponentMetaData(String callingMethod) {
        ComponentMetaData cmd = cmdAccessor.getComponentMetaData();
        String appName = null;
        String moduleName = null;
        if (cmd != null) {
            appName = cmd.getJ2EEName().getApplication();
            ModuleMetaData mmd = cmd.getModuleMetaData();
            if (mmd != null) {
                moduleName = mmd.getName();
            }
        }
        if (appName != null) {
            if (this.pcm.isApplicationRunning(appName)) {
                throw new IllegalStateException(callingMethod + " can only be called during application startup or during permission check");
            }
            if (moduleName != null) {
                return PolicyContextUtil.getContextId((WsLocationAdmin)this.locationAdmin, (String)appName, (String)moduleName);
            }
        }
        return null;
    }

    public Policy getPolicy(String contextId) {
        Policy policy;
        if (contextId == null) {
            contextId = this.getContextIdFromComponentMetaData("PolicyFactory.getPolicy");
        }
        if (contextId == null) {
            policy = null;
        } else if (this.wrapped != null) {
            policy = this.wrapped.getPolicy(contextId);
        } else {
            policy = this.policyMap.get(contextId);
            if (policy == null && !this.policyMap.containsKey(contextId)) {
                policy = this.providerService.getPolicy(contextId);
                this.policyMap.put(contextId, policy);
            }
        }
        return policy;
    }

    public void setPolicy(String contextId, Policy policy) {
        if (contextId == null) {
            contextId = this.getContextIdFromComponentMetaData("PolicyFactory.setPolicy");
        }
        if (contextId != null) {
            if (this.wrapped != null) {
                this.wrapped.setPolicy(contextId, policy);
            } else {
                this.policyMap.put(contextId, policy);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.authorization.jacc.internal.proxy.PolicyFactoryImpl", PolicyFactoryImpl.class, null, null);
        cmdAccessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    }
}

