/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.netty.inbound.NettyTCPConnectionContext;
import com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyTCPReadRequestContext
implements TCPReadRequestContext {
    private static final TraceComponent tc = Tr.register(NettyTCPReadRequestContext.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private final NettyTCPConnectionContext connectionContext;
    private final Channel nettyChannel;
    private WsByteBuffer[] buffers;
    private ByteBuffer[] byteBufferArray = null;
    private ByteBuffer[] byteBufferArrayDirect = null;
    private ByteBuffer[] byteBufferArrayOf1 = null;
    private ByteBuffer[] byteBufferArrayOf2 = null;
    private ByteBuffer[] byteBufferArrayOf3 = null;
    private ByteBuffer[] byteBufferArrayOf4 = null;
    private final WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private final boolean jitAllocateAction = false;
    private int jitAllocateSize = 0;
    private VirtualConnection vc = null;
    static final long serialVersionUID = 6930961717814333117L;

    public NettyTCPReadRequestContext(NettyTCPConnectionContext connectionContext, Channel nettyChannel) {
        this.connectionContext = connectionContext;
        this.nettyChannel = nettyChannel;
    }

    public void clearBuffers() {
        if (this.buffers != null) {
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i].clear();
            }
        }
    }

    public TCPConnectionContext getInterface() {
        return this.connectionContext;
    }

    public Socket getSocket() {
        throw new UnsupportedOperationException("Can not get the socket from a Netty connection!");
    }

    /*
     * WARNING - void declaration
     */
    public long read(long numBytes, int timeout) throws IOException {
        NettyServletUpgradeHandler upgradeHandler;
        if (!this.nettyChannel.isActive()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found closed connection on read for channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            throw new EOFException("Connection closed: Read failed.  Possible end of stream encountered. local=" + this.nettyChannel.localAddress() + " remote=" + this.nettyChannel.remoteAddress());
        }
        if (this.nettyChannel.pipeline().get(NettyServletUpgradeHandler.class) == null) {
            upgradeHandler = new NettyServletUpgradeHandler(this.nettyChannel);
            this.nettyChannel.pipeline().addLast("ServletUpgradeHandler", (ChannelHandler)upgradeHandler);
        }
        upgradeHandler = (NettyServletUpgradeHandler)this.nettyChannel.pipeline().get(NettyServletUpgradeHandler.class);
        upgradeHandler.setTCPReadContext(this);
        upgradeHandler.setTCPReadContext(this);
        upgradeHandler.setVC(this.vc);
        if (upgradeHandler == null) {
            throw new IOException("Upgrade handler not present in pipeline.");
        }
        if (timeout == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Calling immediate timeout on channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            upgradeHandler.immediateTimeout();
            return 0L;
        }
        ExecutorService blockingTaskExecutor = HttpDispatcher.getExecutorService();
        Future<Long> readFuture = blockingTaskExecutor.submit(() -> {
            boolean dataAvailable;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Starting read in synchronous thread for channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            boolean bl = dataAvailable = upgradeHandler.containsQueuedData() || upgradeHandler.awaitReadReady(numBytes, timeout, TimeUnit.MILLISECONDS);
            if (!dataAvailable || !this.nettyChannel.isActive()) {
                throw new SocketTimeoutException("Failed to read data within the specified timeout.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Finished read in synchronous thread for channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            return upgradeHandler.setToBuffer();
        });
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiting on read for channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            if (timeout == -1) {
                return readFuture.get();
            }
            if (timeout == 0) {
                return readFuture.get(60000L, TimeUnit.MILLISECONDS);
            }
            return readFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            void e;
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.netty.inbound.NettyTCPReadRequestContext", (String)"172", (Object)this, (Object[])new Object[]{numBytes, timeout});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Interrupted exception on channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            Thread.currentThread().interrupt();
            throw new IOException("Thread interrupted while reading.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.netty.inbound.NettyTCPReadRequestContext", (String)"178", (Object)this, (Object[])new Object[]{numBytes, timeout});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Exection exception on channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            if ((cause = e.getCause()) instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Error occurred during read operation.", cause);
        }
        catch (TimeoutException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.netty.inbound.NettyTCPReadRequestContext", (String)"187", (Object)this, (Object[])new Object[]{numBytes, timeout});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Timeout exception on channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            throw new SocketTimeoutException("Read operation timed out.");
        }
    }

    @FFDCIgnore(value={EOFException.class})
    public VirtualConnection read(long numBytes, TCPReadCompletedCallback callback, boolean forceQueue, int timeout) {
        if (this.nettyChannel.pipeline().get(NettyServletUpgradeHandler.class) == null) {
            NettyServletUpgradeHandler upgradeHandler = new NettyServletUpgradeHandler(this.nettyChannel);
            this.nettyChannel.pipeline().addLast("ServletUpgradeHandler", (ChannelHandler)upgradeHandler);
        }
        NettyServletUpgradeHandler upgrade = (NettyServletUpgradeHandler)this.nettyChannel.pipeline().get(NettyServletUpgradeHandler.class);
        if (timeout == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Calling immediate timeout on channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            upgrade.immediateTimeout();
            return null;
        }
        if (Objects.nonNull(callback)) {
            upgrade.setReadListener(callback);
        }
        upgrade.setTCPReadContext(this);
        upgrade.setVC(this.vc);
        ExecutorService blockingTaskExecutor = HttpDispatcher.getExecutorService();
        if (upgrade.containsQueuedData() && (long)upgrade.queuedDataSize() >= numBytes) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found queued data on channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            if (!forceQueue) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Not force queue so setting to buffer and returning...", (Object[])new Object[0]);
                }
                upgrade.setToBuffer();
                return this.vc;
            }
            blockingTaskExecutor.submit(() -> {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Running async read callback for channel: " + this.nettyChannel), (Object[])new Object[0]);
                }
                upgrade.setToBuffer();
                callback.complete(this.vc, (TCPReadRequestContext)this);
            });
            return null;
        }
        if (!this.nettyChannel.isActive()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Channel became inactive, not queueing read! " + this.nettyChannel), (Object[])new Object[0]);
            }
            HttpDispatcher.getExecutorService().execute(() -> {
                block3: {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Running async read callback error channel closed for channel: " + this.nettyChannel), (Object[])new Object[0]);
                        }
                        upgrade.getReadListener().error(this.vc, (TCPReadRequestContext)this, (IOException)new EOFException("Connection closed: Read failed.  Possible end of stream encountered. local=" + this.nettyChannel.localAddress() + " remote=" + this.nettyChannel.remoteAddress()));
                    }
                    catch (Exception e2) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Exception calling error on read listener for channel: " + this.nettyChannel + " error: " + e2), (Object[])new Object[0]);
                    }
                }
            });
            return null;
        }
        try {
            upgrade.queueAsyncRead(timeout, numBytes);
        }
        catch (EOFException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("EOF exception caught on channel: " + this.nettyChannel), (Object[])new Object[0]);
            }
            HttpDispatcher.getExecutorService().execute(() -> {
                block2: {
                    try {
                        upgrade.getReadListener().error(this.vc, (TCPReadRequestContext)this, (IOException)e);
                    }
                    catch (Exception e2) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Exception calling EOF error on read listener for channel: " + this.nettyChannel + " error: " + e2), (Object[])new Object[0]);
                    }
                }
            });
        }
        return null;
    }

    public void setJITAllocateSize(int numBytes) {
        this.jitAllocateSize = numBytes;
    }

    public boolean getJITAllocateAction() {
        return this.jitAllocateAction;
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public void setBuffers(WsByteBuffer[] bufs) {
        int i;
        this.buffers = bufs;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        if (bufs != null) {
            int numBufs;
            for (numBufs = 0; numBufs < bufs.length && bufs[numBufs] != null; ++numBufs) {
            }
            if (numBufs == 1) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
            } else if (numBufs == 2) {
                if (this.byteBufferArrayOf2 == null) {
                    this.byteBufferArrayOf2 = new ByteBuffer[2];
                }
                this.byteBufferArray = this.byteBufferArrayOf2;
            } else if (numBufs == 3) {
                if (this.byteBufferArrayOf3 == null) {
                    this.byteBufferArrayOf3 = new ByteBuffer[3];
                }
                this.byteBufferArray = this.byteBufferArrayOf3;
            } else if (numBufs == 4) {
                if (this.byteBufferArrayOf4 == null) {
                    this.byteBufferArrayOf4 = new ByteBuffer[4];
                }
                this.byteBufferArray = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArray = new ByteBuffer[numBufs];
            }
            if (numBufs > 1) {
                for (int i2 = 0; i2 < numBufs; ++i2) {
                    this.byteBufferArray[i2] = bufs[i2].getWrappedByteBufferNonSafe();
                }
            } else if (numBufs == 1) {
                this.byteBufferArray[0] = bufs[0].getWrappedByteBufferNonSafe();
            }
        } else {
            this.byteBufferArray = null;
        }
    }

    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    public void setBuffer(WsByteBuffer buf) {
        int i;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        this.defaultBuffers[0] = null;
        if (buf != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = buf;
            if (this.byteBufferArrayOf1 == null) {
                this.byteBufferArrayOf1 = new ByteBuffer[1];
            }
            this.byteBufferArray = this.byteBufferArrayOf1;
            this.byteBufferArray[0] = buf.getWrappedByteBufferNonSafe();
        } else {
            this.buffers = null;
            this.byteBufferArray = null;
        }
    }

    public void setVC(VirtualConnection vc) {
        this.vc = vc;
    }
}

