/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health30.services.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.microprofile.health.services.impl.AppModuleContextService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health30.services.HealthCheck30CDIBeanInvoker;
import io.openliberty.microprofile.health30.services.HealthCheck30Executor;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(service={HealthCheck30Executor.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthCheck30ExecutorImpl
implements HealthCheck30Executor {
    private AppModuleContextService appModuleContextService;
    private HealthCheck30CDIBeanInvoker healthCheckCDIBeanInvoker;
    private J2EENameFactory j2eeNameFactory;
    private static final Logger logger = Logger.getLogger(HealthCheck30ExecutorImpl.class.getName(), "io.openliberty.microprofile.health.resources.Health");
    private static final String MANAGEDTASK_IDENTITY_NAME = "javax.enterprise.concurrent.IDENTITY_NAME";
    private static final String HC_MANAGEDTASK_IDENTITY_NAME = "mp.healthcheck.proxy";
    private static final String HC_TASK_OWNER = "mp.healthcheck.runtime";
    private static final String ONLY_WAR_EJB_NOT_SUPPORTED = null;
    static final long serialVersionUID = -6249793335476396033L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HealthCheck30ExecutorImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setAppModuleContextService(AppModuleContextService appModuleContextService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "setAppModuleContextService", new Object[]{appModuleContextService});
        }
        this.appModuleContextService = appModuleContextService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "setAppModuleContextService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setHealthCheckApplicationBeanInvoker(HealthCheck30CDIBeanInvoker healthCheckCDIBeanInvoker) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "setHealthCheckApplicationBeanInvoker", new Object[]{healthCheckCDIBeanInvoker});
        }
        this.healthCheckCDIBeanInvoker = healthCheckCDIBeanInvoker;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "setHealthCheckApplicationBeanInvoker");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "setJ2EENameFactory", new Object[]{j2eeNameFactory});
        }
        this.j2eeNameFactory = j2eeNameFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "setJ2EENameFactory");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<HealthCheckResponse> runHealthChecks(String appName, String moduleName, String healthCheckProcedure) throws HealthCheckBeanCallException {
        Set<HealthCheckResponse> retval;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "runHealthChecks", new Object[]{appName, moduleName, healthCheckProcedure});
        }
        J2EEName j2eeName = this.j2eeNameFactory.create(appName, moduleName, ONLY_WAR_EJB_NOT_SUPPORTED);
        HashMap<String, String> execProps = new HashMap<String, String>();
        execProps.put(MANAGEDTASK_IDENTITY_NAME, HC_MANAGEDTASK_IDENTITY_NAME);
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", HC_TASK_OWNER);
        HealthCheck30CDIBeanInvoker proxy = this.appModuleContextService.createContextualProxy(execProps, j2eeName, this.healthCheckCDIBeanInvoker, HealthCheck30CDIBeanInvoker.class);
        try {
            retval = proxy.checkAllBeans(appName, moduleName, healthCheckProcedure);
        }
        catch (HealthCheckBeanCallException healthCheckBeanCallException) {
            void e;
            FFDCFilter.processException((Throwable)healthCheckBeanCallException, (String)"io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", (String)"90", (Object)this, (Object[])new Object[]{appName, moduleName, healthCheckProcedure});
            logger.log(Level.SEVERE, "healthcheck.bean.call.exception.CWMMH0050E", new Object[]{e.getBeanName(), appName, moduleName, e.getCause().toString(), e.getMessage()});
            throw e;
        }
        for (HealthCheckResponse hcr : retval) {
            if (HealthCheckResponse.Status.DOWN != hcr.getStatus()) continue;
            logger.log(Level.WARNING, "healthcheck.application.down.CWMMH0052W", new Object[]{hcr.getClass().toString(), appName, moduleName, hcr.getStatus().toString(), hcr.getName(), hcr.getData() != null ? hcr.getData().toString() : "{NO DATA}"});
        }
        Set<HealthCheckResponse> set = retval;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "runHealthChecks", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeModuleReferences(String appName, String moduleName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "removeModuleReferences", new Object[]{appName, moduleName});
        }
        this.healthCheckCDIBeanInvoker.removeModuleReferences(appName, moduleName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health30.services.impl.HealthCheck30ExecutorImpl", "removeModuleReferences");
        }
    }
}

