/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.filetransfer;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

public interface FileServiceMXBean {
    public static final String OBJECT_NAME = "WebSphere:feature=restConnector,type=FileService,name=FileService";
    public static final String REQUEST_OPTIONS_ALL = "a";
    public static final String REQUEST_OPTIONS_IS_DIRECTORY = "d";
    public static final String REQUEST_OPTIONS_READ_ONLY = "r";
    public static final String REQUEST_OPTIONS_SIZE = "s";
    public static final String REQUEST_OPTIONS_LAST_MODIFIED = "t";
    public static final String ATTRIBUTE_NAME_READ_LIST = "ReadList";
    public static final String ATTRIBUTE_NAME_WRITE_LIST = "WriteList";

    public List<String> getReadList();

    public List<String> getWriteList();

    public MetaData getMetaData(String var1, String var2);

    public MetaData[] getDirectoryEntries(String var1, boolean var2, String var3);

    public boolean createArchive(String var1, String var2);

    public boolean expandArchive(String var1, String var2);

    public static class MetaData {
        private final Boolean directory;
        private final Boolean readOnly;
        private final Date lastModified;
        private final Long size;
        private final String fileName;

        @ConstructorProperties(value={"directory", "lastModified", "size", "readOnly", "fileName"})
        public MetaData(Boolean directory, Date lastModified, Long size, Boolean readOnly, String fileName) {
            this.directory = directory;
            this.lastModified = lastModified == null ? null : (Date)lastModified.clone();
            this.size = size;
            this.readOnly = readOnly;
            this.fileName = fileName;
        }

        public Boolean getDirectory() {
            return this.directory;
        }

        public Date getLastModified() {
            return this.lastModified == null ? null : (Date)this.lastModified.clone();
        }

        public Long getSize() {
            return this.size;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

