/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.CollectionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DerbyPlatform
extends DB2Platform {
    public static final int MAX_CLOB = Integer.MAX_VALUE;
    public static final int MAX_BLOB = Integer.MAX_VALUE;
    protected boolean isSequenceSupported = false;
    boolean isOffsetFetchParameterSupported = false;
    protected boolean isConnectionDataInitialized;

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        super.appendByteArray(bytes, writer);
    }

    @Override
    public Object convertToDatabaseType(Object value) {
        if (value != null && value.getClass() == ClassConstants.UTILDATE) {
            return Helper.sqlDateFromUtilDate((java.util.Date)value);
        }
        return super.convertToDatabaseType(value);
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("VALUES CURRENT_TIMESTAMP");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    @Override
    public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    @Override
    public String getInOutputProcedureToken() {
        return "INOUT";
    }

    @Override
    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    @Override
    public boolean isDerby() {
        return true;
    }

    @Override
    public boolean isDB2() {
        return false;
    }

    @Override
    public String getSelectForUpdateString() {
        return " FOR UPDATE WITH RS";
    }

    @Override
    public boolean shouldIgnoreException(SQLException exception) {
        return false;
    }

    @Override
    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT DELETE ROWS NOT LOGGED";
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        selectQuery.setSQLString("values IDENTITY_VAL_LOCAL()");
        return selectQuery;
    }

    @Override
    protected boolean shouldTempTableSpecifyPrimaryKeys() {
        return false;
    }

    @Override
    protected String getCreateTempTableSqlBodyForTable(DatabaseTable table) {
        return null;
    }

    @Override
    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection pkFields, Collection assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        writer.write(" SET ");
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        boolean isFirst = true;
        Iterator itFields = assignedFields.iterator();
        while (itFields.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(", ");
            }
            DatabaseField field = (DatabaseField)itFields.next();
            String fieldName = field.getNameDelimited(this);
            writer.write(fieldName);
            writer.write(" = (SELECT ");
            writer.write(fieldName);
            writer.write(" FROM ");
            writer.write(tempTableName);
            DerbyPlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
            writer.write(")");
        }
        writer.write(" WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)pkFields.iterator().next()).getNameDelimited(this));
        writer.write(" FROM ");
        writer.write(tempTableName);
        DerbyPlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
        writer.write(")");
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED BY DEFAULT AS IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(LocalDate.class, new FieldTypeDefinition("DATE"));
        fieldTypeMapping.put(LocalDateTime.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(LocalTime.class, new FieldTypeDefinition("TIME"));
        fieldTypeMapping.put(OffsetDateTime.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(OffsetTime.class, new FieldTypeDefinition("TIMESTAMP"));
        return fieldTypeMapping;
    }

    @Override
    protected void setNullFromDatabaseField(DatabaseField databaseField, PreparedStatement statement, int index) throws SQLException {
        int jdbcType = databaseField.getSqlType();
        if (jdbcType == Integer.MIN_VALUE) {
            jdbcType = statement.getParameterMetaData().getParameterType(index);
        }
        statement.setNull(index, jdbcType);
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(42, "DOUBLE"));
        this.addOperator(this.extractOperator());
        this.addOperator(this.avgOperator());
        this.addOperator(this.sumOperator());
        this.addOperator(this.equalOperator());
        this.addOperator(this.notEqualOperator());
        this.addOperator(this.lessThanOperator());
        this.addOperator(this.lessThanEqualOperator());
        this.addOperator(this.greaterThanOperator());
        this.addOperator(this.greaterThanEqualOperator());
        this.addOperator(this.modOperator());
        this.addOperator(this.betweenOperator());
        this.addOperator(this.notBetweenOperator());
        this.addOperator(this.inOperator());
        this.addOperator(this.addOperator());
        this.addOperator(this.subtractOperator());
        this.addOperator(this.multiplyOperator());
        this.addOperator(this.divideOperator());
    }

    protected ExpressionOperator avgOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAllBindingExpression();
        ExpressionOperator.average().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator sumOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAllBindingExpression();
        ExpressionOperator.sum().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator equalOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.equal().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator notEqualOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.notEqual().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator greaterThanOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.greaterThan().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator greaterThanEqualOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.greaterThanEqual().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator lessThanOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.lessThan().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator lessThanEqualOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.lessThanEqual().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator extractOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(138);
        exOperator.setName("EXTRACT");
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("");
        ((Vector)v).add("(");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected ExpressionOperator addOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.add().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator subtractOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.subtract().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator multiplyOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.multiply().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator divideOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.divide().copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator concatOperator() {
        ExpressionOperator operatorS = super.concatOperator();
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        operatorS.copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator trim2() {
        ExpressionOperator operatorS = super.trim2();
        ExpressionOperator operator = ExpressionOperator.trim2();
        operatorS.copyTo(operator);
        return operator;
    }

    protected ExpressionOperator modOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.mod().copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator ltrim2Operator() {
        ExpressionOperator operatorS = super.ltrim2Operator();
        ExpressionOperator operator = ExpressionOperator.leftTrim2();
        operatorS.copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator rtrim2Operator() {
        ExpressionOperator operatorS = super.rtrim2Operator();
        ExpressionOperator operator = ExpressionOperator.rightTrim2();
        operatorS.copyTo(operator);
        return operator;
    }

    protected ExpressionOperator betweenOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.between().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator notBetweenOperator() {
        ExpressionOperator operator = DerbyPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.notBetween().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator inOperator() {
        ExpressionOperator operator = new ExpressionOperator(){

            @Override
            public void printDuo(Expression first, Expression second, ExpressionSQLPrinter printer) {
                Object val;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printDuo(first, second, printer);
                    return;
                }
                if (!first.isValueExpression() || first.isConstantExpression() && !printer.getPlatform().shouldBindLiterals()) {
                    super.printDuo(first, second, printer);
                    return;
                }
                boolean firstBound = true;
                if (second instanceof CollectionExpression && (val = ((CollectionExpression)second).getValue()) instanceof Collection) {
                    firstBound = false;
                    Collection values = (Collection)val;
                    for (Object value : values) {
                        if (value instanceof Expression && !((Expression)value).isValueExpression()) {
                            firstBound = true;
                            break;
                        }
                        if (!(value instanceof Expression) || !((Expression)value).isConstantExpression() || printer.getPlatform().shouldBindLiterals()) continue;
                        firstBound = true;
                        break;
                    }
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(firstBound);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(firstBound);
                }
                super.printDuo(first, second, printer);
            }

            @Override
            public void printJavaDuo(Expression first, Expression second, ExpressionJavaPrinter printer) {
                Object val;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaDuo(first, second, printer);
                    return;
                }
                if (!first.isValueExpression() || first.isConstantExpression() && !printer.getPlatform().shouldBindLiterals()) {
                    super.printJavaDuo(first, second, printer);
                    return;
                }
                boolean firstBound = true;
                if (second instanceof CollectionExpression && (val = ((CollectionExpression)second).getValue()) instanceof Collection) {
                    firstBound = false;
                    Collection values = (Collection)val;
                    for (Object value : values) {
                        if (value instanceof Expression && !((Expression)value).isValueExpression()) {
                            firstBound = true;
                            break;
                        }
                        if (!(value instanceof Expression) || !((Expression)value).isConstantExpression() || printer.getPlatform().shouldBindLiterals()) continue;
                        firstBound = true;
                        break;
                    }
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(firstBound);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(firstBound);
                }
                super.printJavaDuo(first, second, printer);
            }
        };
        ExpressionOperator.in().copyTo(operator);
        return operator;
    }

    @Override
    public boolean isDynamicSQLRequiredForFunctions() {
        if (this.shouldForceBindAllParameters()) {
            return false;
        }
        return !this.isCastRequired();
    }

    @Override
    public int computeMaxRowsForSQL(int firstResultIndex, int maxResults) {
        if (!this.isSequenceSupported) {
            return maxResults;
        }
        return maxResults - (firstResultIndex >= 0 ? firstResultIndex : 0);
    }

    @Override
    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        int max = 0;
        int firstRow = 0;
        if (statement.getQuery() != null) {
            max = statement.getQuery().getMaxRows();
            firstRow = statement.getQuery().getFirstResult();
        }
        if (!this.shouldUseRownumFiltering() || max <= 0 && firstRow <= 0) {
            call.setFields(statement.printSQL(printer));
            statement.appendForUpdateClause(printer);
            return;
        }
        statement.setUseUniqueFieldAliases(true);
        call.setFields(statement.printSQL(printer));
        printer.printString(" OFFSET ");
        if (this.isOffsetFetchParameterSupported) {
            if (max > 0) {
                printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
                printer.printString(" ROWS FETCH NEXT ");
                printer.printParameter(DatabaseCall.MAXROW_FIELD);
                printer.printString(" ROWS ONLY ");
            } else {
                printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
                printer.printString(" ROWS ");
            }
        } else {
            String frStr = Integer.toString(firstRow);
            String maxStr = Integer.toString(max);
            if (max > 0) {
                printer.printString(frStr);
                printer.printString(" ROWS FETCH NEXT ");
                printer.printString(maxStr);
                printer.printString(" ROWS ONLY ");
            } else {
                printer.printString(frStr);
                printer.printString(" ROWS ");
            }
        }
        call.setIgnoreFirstRowSetting(true);
        call.setIgnoreMaxResultsSetting(true);
    }

    @Override
    public boolean supportsSequenceObjects() {
        return this.isSequenceSupported;
    }

    @Override
    public boolean isAlterSequenceObjectSupported() {
        return false;
    }

    @Override
    public Writer buildSequenceObjectDeletionWriter(Writer writer, String fullSeqName) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(fullSeqName);
        writer.write(" RESTRICT");
        return writer;
    }

    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        if (this.isConnectionDataInitialized) {
            return;
        }
        String databaseVersion = connection.getMetaData().getDatabaseProductVersion();
        if (Helper.compareVersions(databaseVersion, "10.6.1") >= 0) {
            this.isSequenceSupported = true;
            this.isOffsetFetchParameterSupported = true;
        }
        this.isConnectionDataInitialized = true;
    }

    @Override
    public void setParameterValueInDatabaseCall(Object parameter, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        if (parameter instanceof LocalTime) {
            statement.setTime(index, Time.valueOf((LocalTime)parameter));
            return;
        }
        super.setParameterValueInDatabaseCall(parameter, statement, index, session);
    }

    @Override
    public void setParameterValueInDatabaseCall(Object parameter, CallableStatement statement, String name, AbstractSession session) throws SQLException {
        if (parameter instanceof LocalTime) {
            statement.setTime(name, Time.valueOf((LocalTime)parameter));
            return;
        }
        super.setParameterValueInDatabaseCall(parameter, statement, name, session);
    }

    @Override
    public int appendParameterInternal(Call call, Writer writer, Object parameter) {
        try {
            int nBoundParameters = 0;
            if (parameter instanceof LocalTime) {
                this.appendTime(Time.valueOf((LocalTime)parameter), writer);
                return nBoundParameters;
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return super.appendParameterInternal(call, writer, parameter);
    }
}

