/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.model.parameters;

import com.ibm.ws.microprofile.openapi.model.utils.OpenAPIUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class ParameterImpl
implements Parameter {
    private String name = null;
    protected Parameter.In in = null;
    private String description = null;
    private Boolean required = null;
    private Boolean deprecated = null;
    private Boolean allowEmptyValue = null;
    private String $ref = null;
    private Parameter.Style style = null;
    private Boolean explode = null;
    private Boolean allowReserved = null;
    private Schema schema = null;
    private Map<String, Example> examples = null;
    private Object example = null;
    private Content content = null;
    private Map<String, Object> extensions = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Parameter name(String name) {
        this.name = name;
        return this;
    }

    public Parameter.In getIn() {
        return this.in;
    }

    public void setIn(Parameter.In in) {
        if (in == Parameter.In.PATH) {
            this.required = true;
        }
        this.in = in;
    }

    public Parameter in(Parameter.In in) {
        this.setIn(in);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Parameter description(String description) {
        this.description = description;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Parameter required(Boolean required) {
        this.required = required;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Parameter deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    public Parameter allowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public Parameter.Style getStyle() {
        return this.style;
    }

    public void setStyle(Parameter.Style style) {
        this.style = style;
    }

    public Parameter style(Parameter.Style style) {
        this.style = style;
        return this;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    public Parameter explode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public void setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
    }

    public Parameter allowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Parameter schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = examples;
    }

    public Parameter examples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public Parameter addExample(String key, Example example) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Example>();
        }
        this.examples.put(key, example);
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public Parameter example(Object example) {
        this.example = example;
        return this;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Parameter content(Content content) {
        this.content = content;
        return this;
    }

    public String getRef() {
        return this.$ref;
    }

    public void setRef(String ref) {
        if (ref != null && ref.indexOf(".") == -1 && ref.indexOf("/") == -1) {
            ref = "#/components/parameters/" + ref;
        }
        this.$ref = ref;
    }

    public Parameter ref(String ref) {
        this.setRef(ref);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterImpl parameter = (ParameterImpl)o;
        return Objects.equals(this.name, parameter.name) && Objects.equals(this.in, parameter.in) && Objects.equals(this.description, parameter.description) && Objects.equals(this.required, parameter.required) && Objects.equals(this.deprecated, parameter.deprecated) && Objects.equals(this.allowEmptyValue, parameter.allowEmptyValue) && Objects.equals(this.style, parameter.style) && Objects.equals(this.explode, parameter.explode) && Objects.equals(this.allowReserved, parameter.allowReserved) && Objects.equals(this.schema, parameter.schema) && Objects.equals(this.examples, parameter.examples) && Objects.equals(this.example, parameter.example) && Objects.equals(this.content, parameter.content) && Objects.equals(this.extensions, parameter.extensions) && Objects.equals(this.$ref, parameter.$ref);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.in, this.description, this.required, this.deprecated, this.allowEmptyValue, this.style, this.explode, this.allowReserved, this.schema, this.examples, this.example, this.content, this.extensions, this.$ref);
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void addExtension(String name, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(name, value);
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Parameter {\n");
        sb = this.name != null ? sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n") : sb.append("");
        sb = this.in != null ? sb.append("    in: ").append(this.toIndentedString(this.in)).append("\n") : sb.append("");
        sb = this.description != null ? sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n") : sb.append("");
        sb = this.required != null ? sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n") : sb.append("");
        sb = this.deprecated != null ? sb.append("    deprecated: ").append(this.toIndentedString(this.deprecated)).append("\n") : sb.append("");
        sb = this.allowEmptyValue != null ? sb.append("    allowEmptyValue: ").append(this.toIndentedString(this.allowEmptyValue)).append("\n") : sb.append("");
        sb = this.style != null ? sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n") : sb.append("");
        sb = this.explode != null ? sb.append("    explode: ").append(this.toIndentedString(this.explode)).append("\n") : sb.append("");
        sb = this.allowReserved != null ? sb.append("    allowReserved: ").append(this.toIndentedString(this.allowReserved)).append("\n") : sb.append("");
        sb = this.schema != null ? sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n") : sb.append("");
        sb = this.examples != null ? sb.append("    examples: ").append(OpenAPIUtils.mapToString(this.examples)).append("\n") : sb.append("");
        sb = this.example != null ? sb.append("    example: ").append(this.toIndentedString(this.example)).append("\n") : sb.append("");
        sb = this.content != null ? sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n") : sb.append("");
        sb = this.$ref != null ? sb.append("    $ref: ").append(this.toIndentedString(this.$ref)).append("\n") : sb.append("");
        sb = this.extensions != null ? sb.append("    extensions: ").append(OpenAPIUtils.mapToString(this.extensions)).append("\n") : sb.append("");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

