/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.microprofile.metrics.cdi.binding.MetricsBinding;
import com.ibm.ws.microprofile.metrics.cdi.decorator.AnnotatedTypeDecorator;
import com.ibm.ws.microprofile.metrics.cdi20.helper.Utils;
import com.ibm.ws.microprofile.metrics.cdi20.producer.MetricRegistryFactory;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi20.MetricName;
import io.astefanutti.metrics.cdi20.MetricProducer;
import io.astefanutti.metrics.cdi20.MetricRegistryBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.InterceptorBinding;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebSphereCDIExtension.class}, immediate=true)
public class MetricsExtension
implements Extension,
WebSphereCDIExtension {
    protected static final AnnotationLiteral<Nonbinding> NON_BINDING;
    protected static final AnnotationLiteral<InterceptorBinding> INTERCEPTOR_BINDING;
    protected static final AnnotationLiteral<MetricsBinding> METRICS_BINDING;
    protected static final AnnotationLiteral<Default> DEFAULT;
    protected final Map<Bean<?>, AnnotatedMember<?>> metrics = new HashMap();
    protected final Set<MetricID> metricIDs = Collections.synchronizedSortedSet(new TreeSet());
    protected final Map<Member, Map<Annotation, String>> memberMap = Collections.synchronizedMap(new HashMap());
    private final Set<Class<?>> beansVisited = Collections.synchronizedSet(new HashSet());
    static final long serialVersionUID = -7034115826836535880L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    public void getSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        MetricRegistryFactory.SHARED_METRIC_REGISTRIES = sharedMetricRegistry;
    }

    protected <X> void metricsAnnotations(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Metered.class, Timed.class, ConcurrentGauge.class}) ProcessAnnotatedType<X> pat) {
        pat.setAnnotatedType(new AnnotatedTypeDecorator(pat.getAnnotatedType(), (Annotation)METRICS_BINDING));
    }

    protected void metricProducerField(@Observes ProcessProducerField<? extends Metric, ?> ppf) {
        this.metrics.put((Bean<?>)ppf.getBean(), (AnnotatedMember<?>)ppf.getAnnotatedProducerField());
    }

    protected void metricProducerMethod(@Observes ProcessProducerMethod<? extends Metric, ?> ppm) {
        if (!ppm.getBean().getBeanClass().equals(MetricProducer.class)) {
            this.metrics.put((Bean<?>)ppm.getBean(), (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod());
        }
    }

    protected void defaultMetricRegistry(@Observes AfterBeanDiscovery abd, BeanManager manager) {
        if (manager.getBeans(MetricRegistry.class, new Annotation[0]).isEmpty()) {
            abd.addBean((Bean)new MetricRegistryBean(manager));
        }
    }

    protected <T extends Metric> void configuration(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        MetricRegistry registry = MetricsExtension.getReference(manager, MetricRegistry.class);
        MetricName name = MetricsExtension.getReference(manager, MetricName.class);
        for (Map.Entry<Bean<?>, AnnotatedMember<?>> bean : this.metrics.entrySet()) {
            if (!bean.getKey().getQualifiers().contains(DEFAULT) || MetricsExtension.hasInjectionPoints(bean.getValue())) continue;
            Metadata metadata = name.metadataOf(bean.getValue());
            String[] tags = name.tagOf(bean.getValue());
            registry.register(metadata, (Metric)MetricsExtension.getReference(manager, bean.getValue().getBaseType(), bean.getKey()), Utils.tagsToTags(tags));
            MetricID mid = new MetricID(metadata.getName(), Utils.tagsToTags(tags));
            this.addMetricID(mid);
        }
        this.metrics.clear();
    }

    protected void beforeShutdown(@Observes BeforeShutdown shutdown) {
        MetricRegistry registry = MetricRegistryFactory.getApplicationRegistry();
        for (MetricID mid : this.metricIDs) {
            registry.remove(mid);
        }
    }

    protected static <T> T getReference(BeanManager manager, Class<T> type) {
        return MetricsExtension.getReference(manager, type, manager.resolve(manager.getBeans(type, new Annotation[0])));
    }

    protected static <T> T getReference(BeanManager manager, Type type, Bean<?> bean) {
        return (T)manager.getReference(bean, type, manager.createCreationalContext(bean));
    }

    protected static boolean hasInjectionPoints(AnnotatedMember<?> member) {
        if (!(member instanceof AnnotatedMethod)) {
            return false;
        }
        AnnotatedMethod method = (AnnotatedMethod)member;
        for (AnnotatedParameter parameter : method.getParameters()) {
            if (!parameter.getBaseType().equals(InjectionPoint.class)) continue;
            return true;
        }
        return false;
    }

    public String getMetricNameForMember(Member member, Annotation annotation) {
        Map<Annotation, String> map = this.memberMap.get(member);
        if (map == null) {
            return null;
        }
        return map.get(annotation);
    }

    public void addMetricID(Member member, Annotation annotation, MetricID mid) {
        Map<Annotation, String> map = this.memberMap.get(member);
        String name = mid.getName();
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            this.memberMap.put(member, map);
        }
        map.put(annotation, name);
        this.metricIDs.add(mid);
    }

    public void addMetricID(MetricID mid) {
        this.metricIDs.add(mid);
    }

    public Set<Class<?>> getBeansVisited() {
        return this.beansVisited;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi20.MetricsExtension", MetricsExtension.class, null, null);
        NON_BINDING = new AnnotationLiteral<Nonbinding>(){
            static final long serialVersionUID = -2262683151595323007L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi20.MetricsExtension$1", 1.class, null, null);
            }
        };
        INTERCEPTOR_BINDING = new AnnotationLiteral<InterceptorBinding>(){
            static final long serialVersionUID = 7928317807885747594L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi20.MetricsExtension$2", 2.class, null, null);
            }
        };
        METRICS_BINDING = new AnnotationLiteral<MetricsBinding>(){
            static final long serialVersionUID = -5162831304029641805L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi20.MetricsExtension$3", 3.class, null, null);
            }
        };
        DEFAULT = new AnnotationLiteral<Default>(){
            static final long serialVersionUID = 4915112562196423177L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi20.MetricsExtension$4", 4.class, null, null);
            }
        };
    }
}

