/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class HexUtil {
    private static TraceComponent tc = SibTr.register(HexUtil.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final char[] digits = "0123456789ABCDEF".toCharArray();

    private HexUtil() {
    }

    public static String toString(int[] frame) {
        return HexUtil.toString(frame, 0, frame.length);
    }

    public static String toString(int[] frame, int offset, int length) {
        byte[] temp = new byte[length * 4];
        int j = 0;
        int i = 0;
        while (i < length) {
            temp[j] = (byte)(frame[i] >>> 24);
            temp[j + 1] = (byte)(frame[i] >>> 16);
            temp[j + 2] = (byte)(frame[i] >>> 8);
            temp[j + 3] = (byte)frame[i];
            ++i;
            j += 4;
        }
        return HexUtil.toString(temp, 0, length * 4);
    }

    public static String toString(byte[] frame, int offset, int length) {
        if (frame == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int limit = offset + length;
        while (offset < limit) {
            buf.append(digits[frame[offset] >>> 4 & 0xF]);
            buf.append(digits[frame[offset++] & 0xF]);
        }
        return buf.toString();
    }

    public static String toString(byte[] array) {
        return HexUtil.toString(array, 0, array.length);
    }

    public static String dumpString(byte[] frame, int offset, int length) {
        return HexUtil.dumpString(frame, offset, length, false);
    }

    public static String dumpString(byte[] frame, int offset, int length, boolean ascii) {
        if (frame == null || length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer asciibuf = new StringBuffer();
        buf.append("Length=").append(length);
        for (int i = 0; i < length; ++i) {
            if (i % 32 == 0) {
                if (ascii) {
                    buf.append(asciibuf);
                    asciibuf.setLength(0);
                    asciibuf.append("\n").append(HexUtil.pad(0)).append("   ");
                }
                buf.append("\n").append(HexUtil.pad(offset + i)).append(offset + i).append(": ");
            } else if (i % 16 == 0) {
                buf.append("  ");
                if (ascii) {
                    asciibuf.append("  ");
                }
            } else if (i % 4 == 0) {
                buf.append(" ");
                if (ascii) {
                    asciibuf.append(" ");
                }
            }
            buf.append(digits[frame[offset + i] >>> 4 & 0xF]);
            buf.append(digits[frame[offset + i] & 0xF]);
            if (!ascii) continue;
            if (frame[offset + i] >= 32 && (frame[offset + i] & 0x80) == 0) {
                asciibuf.append(' ').append((char)frame[offset + i]);
                continue;
            }
            asciibuf.append(" .");
        }
        if (ascii) {
            buf.append(asciibuf);
        }
        return buf.toString();
    }

    static String pad(int i) {
        if (i > 999) {
            return "";
        }
        if (i > 99) {
            return " ";
        }
        if (i > 9) {
            return "  ";
        }
        return "   ";
    }

    public static void main(String[] args) {
        System.err.println(HexUtil.toString(new int[]{Integer.parseInt(args[0])}));
    }
}

