/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFDynamicType;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulationManager;
import com.ibm.ws.sib.mfp.jmf.JMFEnumType;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFPrimitiveType;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFRepeatedType;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaIdException;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFTupleType;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JMFVariantType;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSBaseTypes;
import com.ibm.ws.sib.mfp.jmf.impl.JSCompatibleMessageImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSNativePartCopier;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSRepeated;
import com.ibm.ws.sib.mfp.jmf.impl.JSTuple;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.jmf.impl.JSchemaInterpreter;
import com.ibm.ws.sib.mfp.jmf.impl.JSchemaInterpreterImpl;
import com.ibm.ws.sib.mfp.util.HashedArray;
import java.util.HashMap;
import java.util.Map;

public final class JSRegistry
implements JMFRegistry {
    private static TraceComponent tc = JmfTr.register(JSRegistry.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private HashedArray schemaTable = new HashedArray(8191, 2);
    private Map associations = new HashMap();
    private Map mmmgrTable = new HashMap();
    private JSNativePartCopier copier = null;
    private JSchemaInterpreter[] interpTab = new JSchemaInterpreter[1];

    public JSRegistry() {
        this.interpTab[0] = new JSchemaInterpreterImpl();
    }

    @Override
    public void register(JMFEncapsulationManager mgr, int id) {
        if (id <= 0) {
            throw new IllegalArgumentException("model ID cannot be negative");
        }
        this.mmmgrTable.put(id - 1, mgr);
    }

    @Override
    public JMFEncapsulationManager retrieve(int id) {
        return (JMFEncapsulationManager)this.mmmgrTable.get(id - 1);
    }

    public JSchemaInterpreter getInterpreter(short id) {
        return this.interpTab[id - 1];
    }

    @Override
    public void register(JMFSchema schema) throws JMFSchemaIdException {
        if (!this.isPresent(schema)) {
            this.registerInternal(schema);
        }
    }

    private void registerInternal(JMFSchema schema) {
        this.schemaTable.set((HashedArray.Element)((Object)schema));
        Object assoc = schema.getJMFType().getAssociation();
        if (assoc != null) {
            this.associations.put(assoc, schema);
        }
    }

    private boolean isPresent(JMFSchema schema) throws JMFSchemaIdException {
        long id = schema.getID();
        JMFSchema reg = (JMFSchema)((Object)this.schemaTable.get(id));
        if (reg != null) {
            Object oldAssoc;
            if (!schema.equals(reg)) {
                throw new JMFSchemaIdException("Schema id clash: id=" + id);
            }
            Object newAssoc = schema.getJMFType().getAssociation();
            if (newAssoc != (oldAssoc = reg.getJMFType().getAssociation()) && newAssoc != null) {
                if (oldAssoc != null) {
                    this.associations.remove(oldAssoc);
                }
                reg.getJMFType().updateAssociations(schema.getJMFType());
                this.associations.put(newAssoc, reg);
            }
            return true;
        }
        return false;
    }

    @Override
    public void registerAll(JMFSchema schema) throws JMFSchemaIdException {
        if (this.isPresent(schema)) {
            return;
        }
        this.registerInternal(schema);
        this.registerDependents(schema.getJMFType());
    }

    private void registerDependents(JMFType type) throws JMFSchemaIdException {
        block8: {
            block7: {
                if (!(type instanceof JMFDynamicType)) break block7;
                JMFSchema schema = ((JMFDynamicType)type).getExpectedSchema();
                if (schema == null) break block8;
                this.registerAll(schema);
                break block8;
            }
            if (type instanceof JMFRepeatedType) {
                this.registerDependents(((JMFRepeatedType)type).getItemType());
            } else if (type instanceof JMFTupleType) {
                JMFTupleType tup = (JMFTupleType)type;
                for (int i = 0; i < tup.getFieldCount(); ++i) {
                    this.registerDependents(tup.getField(i));
                }
            } else if (type instanceof JMFVariantType) {
                JMFVariantType var = (JMFVariantType)type;
                for (int i = 0; i < var.getCaseCount(); ++i) {
                    this.registerDependents(var.getCase(i));
                }
            }
        }
    }

    @Override
    public JMFSchema retrieve(long id) {
        return (JMFSchema)((Object)this.schemaTable.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMFSchema[] retrieveAll() {
        HashedArray hashedArray = this.schemaTable;
        synchronized (hashedArray) {
            return (JMFSchema[])this.schemaTable.toArray(new JMFSchema[this.schemaTable.size()]);
        }
    }

    @Override
    public JMFMessage newMessage(JMFSchema schema) {
        return this.interpTab[0].newMessage((JSchema)schema);
    }

    @Override
    public JMFNativePart newNativePart(JMFSchema schema) {
        return this.newMessage(schema);
    }

    @Override
    public JMFMessage decode(JMFSchema schema, byte[] contents, int offset, int length) throws JMFMessageCorruptionException {
        return this.interpTab[0].decode((JSchema)schema, contents, offset, length);
    }

    @Override
    public JMFMessage decode(JMFSchema access, short interp, long encoding, byte[] contents, int offset, int length) throws JMFSchemaViolationException, JMFMessageCorruptionException {
        if (access.getID() == encoding) {
            return this.interpTab[interp - 1].decode((JSchema)access, contents, offset, length);
        }
        JSchema encSchema = (JSchema)this.retrieve(encoding);
        if (encSchema == null) {
            throw new JMFSchemaViolationException("schemaId=null");
        }
        JMFMessage encMsg = this.interpTab[interp - 1].decode(encSchema, contents, offset, length);
        return new JSCompatibleMessageImpl((JSchema)access, encMsg);
    }

    @Override
    public long[] checkSchemata(short interp, byte[] contents, int offset) throws JMFMessageCorruptionException {
        return this.interpTab[interp - 1].checkSchemata(contents, offset);
    }

    public void clear() {
        this.schemaTable = new HashedArray(8191, 2);
        this.associations = new HashMap();
    }

    public void remove(long id) {
        JMFSchema oldSchema = (JMFSchema)((Object)this.schemaTable.remove(id));
        if (oldSchema != null) {
            this.associations.remove(oldSchema.getJMFType().getAssociation());
        }
    }

    public void removeAssociations() {
        JMFSchema[] schemas = this.associations.values().toArray(new JMFSchema[0]);
        for (int i = 0; i < schemas.length; ++i) {
            this.remove(schemas[i].getID());
        }
    }

    @Override
    public JMFPrimitiveType createJMFPrimitiveType() {
        return new JSPrimitive();
    }

    @Override
    public JMFEnumType createJMFEnumType() {
        return new JSEnum();
    }

    @Override
    public JMFDynamicType createJMFDynamicType() {
        return new JSDynamic();
    }

    @Override
    public JMFVariantType createJMFVariantType() {
        return new JSVariant();
    }

    @Override
    public JMFRepeatedType createJMFRepeatedType() {
        return new JSRepeated();
    }

    @Override
    public JMFTupleType createJMFTupleType() {
        return new JSTuple();
    }

    @Override
    public JMFSchema createJMFSchema(JMFType type) {
        return new JSchema((JSType)type);
    }

    @Override
    public JMFSchema createJMFSchema(byte[] frame) {
        return new JSchema(frame);
    }

    @Override
    public JMFSchema createJMFSchema(byte[] frame, int offset, int length) {
        return new JSchema(frame, offset, length);
    }

    @Override
    public int getTypeCode(Class cls) {
        Integer ans = (Integer)JSBaseTypes.classTypes.get(cls);
        if (ans == null) {
            return -1;
        }
        return ans;
    }

    @Override
    public void copy(JMFNativePart source, JMFNativePart target, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (this.copier == null) {
            this.copier = new JSNativePartCopier();
        }
        this.copier.copy(source, target, deep);
    }

    @Override
    public JMFSchema retrieve(Object association) {
        return (JMFSchema)this.associations.get(association);
    }
}

