/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal;

import com.ibm.ejs.container.PersistentTimer;
import com.ibm.ejs.container.PersistentTimerTaskHandler;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.ejb.TimerStatus;
import com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.NoSuchObjectLocalException;
import java.util.Date;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PersistentTimerImpl
extends PersistentTimer {
    private static final TraceComponent tc = Tr.register(PersistentTimerImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final EJBPersistentTimerRuntimeImpl persistentTimerRuntime;
    private TimerStatus<?> cachedTimerStatus;
    static final long serialVersionUID = 7733314572798794962L;

    @Trivial
    public PersistentTimerImpl(Long taskId, J2EEName j2eeName, int cachedTimerDataAllowed, PersistentTimerTaskHandler taskHandler, TimerStatus<?> timerStatus, EJBPersistentTimerRuntimeImpl persistentTimerRuntime) {
        super(taskId, j2eeName, cachedTimerDataAllowed, taskHandler);
        this.persistentTimerRuntime = persistentTimerRuntime;
        this.cachedTimerStatus = timerStatus;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        boolean removed;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cancel: " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        try {
            removed = this.persistentTimerRuntime.remove(this.taskId);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerImpl", (String)"116", (Object)((Object)this), (Object[])new Object[0]);
            throw this.newTimerServiceException((Throwable)ex);
        }
        if (!removed) {
            throw this.newNoSuchObjectLocalException();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancel: successful");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    protected Date getNextTimeout(int operation) {
        Date nextTimeout;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNextTimeout: " + operation), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        if (this.j2eeName == null || this.isAnyCachingAllowed()) {
            TimerStatus<?> taskStatus = this.getTimerStatus(operation);
            nextTimeout = taskStatus.getNextExecutionTime();
        } else {
            try {
                nextTimeout = this.persistentTimerRuntime.getNextExecutionTime(this.taskId);
            }
            catch (Throwable taskStatus) {
                void ex;
                FFDCFilter.processException((Throwable)taskStatus, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerImpl", (String)"152", (Object)((Object)this), (Object[])new Object[]{operation});
                throw this.newTimerServiceException((Throwable)ex);
            }
            if (nextTimeout == null) {
                throw this.newNoSuchObjectLocalException();
            }
        }
        if (this.isTimeoutCallback) {
            PersistentTimerTaskHandler taskHandler = this.getTimerTaskHandler(operation);
            Date afterCurrentTimeout = taskHandler.getNextTimeout(nextTimeout, null);
            if (afterCurrentTimeout != null) {
                nextTimeout = afterCurrentTimeout;
            } else if (taskHandler.getParsedSchedule() != null) {
                NoMoreTimeoutsException nmte = new NoMoreTimeoutsException(this.toString());
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getNextTimeout: " + nmte));
                }
                throw nmte;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNextTimeout: " + nextTimeout));
        }
        return nextTimeout;
    }

    /*
     * WARNING - void declaration
     */
    private TimerStatus<?> getTimerStatus(int operation) {
        TimerStatus<?> timerStatus = this.cachedTimerStatus;
        if (timerStatus != null && this.isCachingAllowed(operation)) {
            return timerStatus;
        }
        try {
            timerStatus = this.cachedTimerStatus = this.persistentTimerRuntime.getTimerStatus(this.taskId);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerImpl", (String)"205", (Object)((Object)this), (Object[])new Object[]{operation});
            throw this.newTimerServiceException((Throwable)ex);
        }
        if (timerStatus == null) {
            throw this.newNoSuchObjectLocalException();
        }
        if (this.j2eeName == null) {
            try {
                PersistentTimerTaskHandler taskHandler = this.cachedTaskHandler = (PersistentTimerTaskHandler)timerStatus.getTimer();
                this.j2eeName = taskHandler.getJ2EEName();
                this.cachedTimerDataAllowed = this.persistentTimerRuntime.getAllowCachedTimerData(this.j2eeName);
            }
            catch (Throwable taskHandler) {
                void ex;
                FFDCFilter.processException((Throwable)taskHandler, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerImpl", (String)"216", (Object)((Object)this), (Object[])new Object[]{operation});
                throw this.newTimerServiceException((Throwable)ex);
            }
        }
        return timerStatus;
    }

    /*
     * WARNING - void declaration
     */
    protected PersistentTimerTaskHandler getTimerTaskHandler(int operation) {
        PersistentTimerTaskHandler taskHandler = this.cachedTaskHandler;
        if (taskHandler != null && this.isCachingAllowed(operation)) {
            return taskHandler;
        }
        TimerStatus<?> taskStatus = this.getTimerStatus(operation);
        try {
            taskHandler = this.cachedTaskHandler = (PersistentTimerTaskHandler)taskStatus.getTimer();
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerImpl", (String)"232", (Object)((Object)this), (Object[])new Object[]{operation});
            throw this.newTimerServiceException((Throwable)ex);
        }
        return taskHandler;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkTimerExists(int operation) {
        if (!this.isCachingAllowed(operation)) {
            Date nextExecution = null;
            try {
                nextExecution = this.persistentTimerRuntime.getNextExecutionTime(this.taskId);
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerImpl", (String)"248", (Object)((Object)this), (Object[])new Object[]{operation});
                throw this.newTimerServiceException((Throwable)ex);
            }
            if (nextExecution == null) {
                throw this.newNoSuchObjectLocalException();
            }
        }
    }

    private TimerServiceException newTimerServiceException(Throwable ex) {
        StringBuilder msg = new StringBuilder();
        msg.append("An error occurred accessing the persistent EJB timer with the ").append(this.taskId).append(" task identifier");
        if (this.j2eeName != null) {
            msg.append(" for the ").append(this.j2eeName.getComponent()).append(" bean in the ");
            msg.append(this.j2eeName.getModule()).append(" module in the ").append(this.j2eeName.getApplication()).append(" application");
        }
        msg.append(" : ").append(ex.getMessage());
        return new TimerServiceException(msg.toString(), ex);
    }

    private NoSuchObjectLocalException newNoSuchObjectLocalException() {
        StringBuilder msg = new StringBuilder();
        msg.append("Persistent EJB timer with the ").append(this.taskId).append(" task identifier");
        if (this.j2eeName != null) {
            msg.append(" for the ").append(this.j2eeName.getComponent()).append(" bean in the ");
            msg.append(this.j2eeName.getModule()).append(" module in the ").append(this.j2eeName.getApplication()).append(" application");
        }
        msg.append(" no longer exists.");
        return new NoSuchObjectLocalException(msg.toString());
    }
}

