/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20;

import com.ibm.oauth.core.internal.OAuthConstants;
import com.ibm.ws.common.crypto.CryptoUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public interface OAuth20Constants
extends OAuthConstants {
    public static final String REQUEST_TYPE = "request_type";
    public static final String REQUEST_TYPE_AUTHORIZATION = "authorization";
    public static final String REQUEST_TYPE_ACCESS_TOKEN = "access_token";
    public static final String REQUEST_TYPE_RESOURCE = "resource";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String RESPONSE_TYPE_CODE = "code";
    public static final String RESPONSE_TYPE_TOKEN = "token";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String TRUSTED_URI_PREFIXES = "trustedUriPrefixes";
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_IDS = "resourceIds";
    public static final String RESOURCE_OWNER_USERNAME = "username";
    public static final String RESOURCE_OWNER_OVERRIDDEN_USERNAME = "overriddenusername";
    public static final String RESOURCE_OWNER_PASSWORD = "password";
    public static final String SCOPE = "scope";
    public static final String GRANT_TYPE = "grant_type";
    public static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    public static final String GRANT_TYPE_PASSWORD = "password";
    public static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    public static final String GRANT_TYPE_RESOURCE_OWNER = "resource_owner";
    public static final String GRANT_TYPE_IMPLICIT = "implicit";
    public static final String GRANT_TYPE_IMPLICIT_INTERNAL = "implicit_internal";
    public static final String GRANT_TYPE_APP_TOKEN = "app_token";
    public static final String GRANT_TYPE_APP_PASSWORD = "app_password";
    public static final String GRANT_TYPE_JWT = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    public static final String[] ALL_GRANT_TYPES = new String[]{"authorization_code", "password", "refresh_token", "client_credentials", "implicit", "implicit_internal", "urn:ietf:params:oauth:grant-type:jwt-bearer", "app_password", "app_token"};
    public static final HashSet<String> ALL_GRANT_TYPES_SET = new HashSet<String>(Arrays.asList(ALL_GRANT_TYPES));
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String ID_TOKEN = "id_token";
    public static final String CODE = "code";
    public static final String EXPIRES_IN = "expires_in";
    public static final String TOKEN_TYPE = "token_type";
    public static final String STATE = "state";
    public static final String CODE_CHALLENGE = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
    public static final String CODE_VERIFIER = "code_verifier";
    public static final String CODE_VERIFIER_ASCCI = "US-ASCII";
    public static final String ISSUER_IDENTIFIER = "issuerIdentifier";
    public static final String REFRESH_TOKEN_KEY = "refresh_key";
    public static final String OLD_REFRESH_TOKEN_KEY = "old_refresh_key";
    public static final String OAUTH_REQUEST_OBJECT_ATTR_NAME = "OAuth20Request";
    public static final String OIDC_REQUEST_OBJECT_ATTR_NAME = "OidcRequest";
    public static final String TOKENTYPE_AUTHORIZATION_GRANT = "authorization_grant";
    public static final String TOKENTYPE_ACCESS_TOKEN = "access_token";
    public static final String SUBTYPE_BEARER = "Bearer";
    public static final String SUBTYPE_AUTHORIZATION_CODE = "authorization_code";
    public static final String SUBTYPE_REFRESH_TOKEN = "refresh_token";
    public static final String LIFETIME = "LIFETIME";
    public static final String LENGTH = "LENGTH";
    public static final String COMPONENTID = "COMPONENTID";
    public static final String RESPONSEATTR_EXPIRES = "expires";
    public static final String KEY_CUSTOMIZED_GRANT_TYPE_HANDLER_ID_QUAL = "com.ibm.ws.security.oauth20.provider.granttype.handler.id";
    public static final String ATTRTYPE_PARAM_JWT = "urn:ibm:names:jwt:param";
    public static final String ATTRTYPE_PARAM_OAUTH_REQUEST = "urn:ibm:names:oauth:param:request";
    public static final String CLAIM_NAME_ISS = "iss";
    public static final String CLAIM_NAME_SUB = "sub";
    public static final String CLAIM_NAME_AUD = "aud";
    public static final String CLAIM_NAME_EXP = "exp";
    public static final String CLAIM_NAME_NBF = "nbf";
    public static final String CLAIM_NAME_IAT = "iat";
    public static final String CLAIM_NAME_JTI = "jti";
    public static final String CLAIM_NAME_SCOPE = "scope";
    public static final String AUTHORIZATION_CODE_ID = "authorization_code_id";
    public static final String REFRESH_TOKEN_ID = "refresh_token_id";
    public static final String ACCESS_TOKEN_ID = "access_token_id";
    public static final String REQUEST_FEATURE = "request_feature";
    public static final String REQUEST_FEATURE_OIDC = "oidc";
    public static final String REQUEST_FEATURE_OAUTH2 = "oauth2";
    public static final String OAUTH_TOKEN_CLIENT_ID = "oauth_token_client_id";
    public static final String[] OAuth20RequestParameters = new String[]{"client_id", "client_secret", "response_type", "redirect_uri", "scope", "state", "grant_type", "code", "username", "password", "refresh_token", "access_token"};
    public static final Set<String> OAuth20RequestParametersSet = new HashSet<String>(Arrays.asList(OAuth20RequestParameters));
    public static final String SIGNATURE_ALGORITHM_RS256 = "RS256";
    public static final String SIGNATURE_ALGORITHM_HS256 = "HS256";
    public static final String SIGNATURE_ALGORITHM_NONE = "none";
    public static final String EXTERNAL_CLAIM_NAMES = "externalClaimNames";
    public static final String EXTERNAL_CLAIMS = "com.ibm.wsspi.security.oidc.external.claims";
    public static final String EXTERNAL_CLAIMS_PREFIX = "com.ibm.wsspi.security.oidc.external.claims:";
    public static final String EXTERNAL_MEDIATION = "com.ibm.wsspi.security.oidc.external.mediation";
    public static final int EXTERNAL_CLAIMS_PREFIX_LENGTH = "com.ibm.wsspi.security.oidc.external.claims:".length();
    public static final String DEFAULT_AUTHZ_LOGIN_URL = "login.jsp";
    public static final String PROXY_HOST = "X-Forwarded-Host";
    public static final String ATTRTYPE_PARAM_HEADER = "urn:ibm:names:header:param";
    public static final String OAUTH20_AUTHZ_PARAM_RESOURCES = "resource";
    public static final String OAUTH20_AUTHZ_PARAM_NONCE = "nonce";
    public static final String OAUTH20_AUTHEN_PARAM_RESOURCE = "urn:ibm:names:authn:param:resource";
    public static final String APP_PASSWORD_STATE_ID = "iamapppasswordstateid";
    public static final String APP_TOKEN_STATE_ID = "iamapptokenstateid";
    public static final String APP_PASSWORD = "app_password";
    public static final String APP_TOKEN = "app_token";
    public static final String APP_PASSWORD_URI = "app-passwords";
    public static final String APP_TOKEN_URI = "app-tokens";
    public static final String AUTHORIZE_URI = "authorize";
    public static final String USERS_TOKEN_MGMT_URI = "usersTokenManagement";
    public static final String PERS_TOKEN_MGMT_URI = "personalTokenManagement";
    public static final String CLIENT_MGMT_URI = "clientManagement";
    public static final String CLIENT_METATYPE_URI = "clientMetatype";
    public static final String USED_FOR = "used_for";
    public static final String USED_BY = "used_by";
    public static final String APP_NAME = "app_name";
    public static final String APP_ID = "app_id";
    public static final String LAST_ACCESS = "last_access";
    public static final String CREATED_AT = "created_at";
    public static final String EXPIRES_AT = "expires_at";
    public static final String TOKEN_MANAGER_ROLE = "tokenManager";
    public static final String PARAM_USER_ID = "user_id";
    public static final String REFRESH_TOKEN_ORIGINAL_GT = "originalGrantType";
    public static final String HASH = "hash";
    public static final String APP_PASSWORD_HASH_SALT = CryptoUtils.isFips140_3EnabledWithBetaGuard() ? "notrandomnotrandom" : "notrandom";
    public static final String PLAIN_ENCODING = "plain";
    public static final String APP_PASSWORD_TOKEN_STATE_ID = "iamapppasswordorapptokenstateid";
    public static final String XOR = "xor";
    public static final String SALT = "salt";
    public static final String HASH_ALGORITHM = "hash_alg";
    public static final String HASH_ITERATIONS = "hash_itr";
    public static final String HASH_LENGTH = "hash_len";
    public static final String THIRD_PARTY_ID_TOKEN = "third_party_idtoken";
    public static final String THIRD_PARTY_ID_TOKEN_PREFIX = "third_party_idtoken:";
}

