/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.requests.ExecutionRequestId;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpSession {
    private final String sessionId;
    private final Instant created;
    private Instant lastAccessed;
    private final Set<ExecutionRequestId> activeRequests = ConcurrentHashMap.newKeySet();
    static final long serialVersionUID = -8996038848225464388L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public McpSession(String sessionId) {
        this.sessionId = sessionId;
        this.lastAccessed = this.created = Instant.now();
    }

    public void addRequest(ExecutionRequestId requestId) {
        this.activeRequests.add(requestId);
    }

    public boolean isRequestActive(ExecutionRequestId requestId) {
        return this.activeRequests.contains(requestId);
    }

    public void removeRequest(ExecutionRequestId requestId) {
        this.activeRequests.remove(requestId);
    }

    public boolean hasNoActiveRequests() {
        return this.activeRequests.isEmpty();
    }

    public Instant getCreatedAt() {
        return this.created;
    }

    public void clearAllRequests() {
        this.activeRequests.clear();
    }

    public void touch() {
        this.lastAccessed = Instant.now();
    }

    public Set<ExecutionRequestId> getActiveRequests() {
        return new HashSet<ExecutionRequestId>(this.activeRequests);
    }

    public Instant getLastAccessed() {
        return this.lastAccessed;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.McpSession", McpSession.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    }
}

