/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentPropertyDescriptor;

public class ImplementationHandler
extends TagHandler {
    private static final Logger log = Logger.getLogger(ImplementationHandler.class.getName());
    public static final String NAME = "implementation";

    public ImplementationHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!((AbstractFaceletContext)ctx).isBuildingCompositeComponentMetadata()) {
            this.nextHandler.apply(ctx, parent);
        } else {
            UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
            CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
            if (beanInfo == null) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
                }
                return;
            }
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            HashMap<String, CompositeComponentPropertyDescriptor> facetPropertyDescriptorMap = (HashMap<String, CompositeComponentPropertyDescriptor>)beanDescriptor.getValue("jakarta.faces.component.FACETS_KEY");
            if (facetPropertyDescriptorMap == null) {
                facetPropertyDescriptorMap = new HashMap<String, CompositeComponentPropertyDescriptor>();
                beanDescriptor.setValue("jakarta.faces.component.FACETS_KEY", facetPropertyDescriptorMap);
            }
            if (!facetPropertyDescriptorMap.containsKey("jakarta.faces.component.COMPOSITE_FACET_NAME")) {
                try {
                    facetPropertyDescriptorMap.put("jakarta.faces.component.COMPOSITE_FACET_NAME", new CompositeComponentPropertyDescriptor("jakarta.faces.component.COMPOSITE_FACET_NAME"));
                }
                catch (IntrospectionException e) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "Cannot create PropertyDescriptor for facet ", e);
                    }
                    throw new TagException(this.tag, (Throwable)e);
                }
            }
            this.nextHandler.apply(ctx, parent);
        }
    }

    public Location getLocation() {
        return this.tag.getLocation();
    }
}

