/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.myfaces.spi.FacesFlowProvider;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FacesFlowProviderFactory {
    protected static final String FACTORY_DEFAULT = "org.apache.myfaces.spi.impl.DefaultFacesFlowProviderFactory";
    private static final String FACTORY_KEY = FacesFlowProviderFactory.class.getName();

    public static FacesFlowProviderFactory getFacesFlowProviderFactory(ExternalContext ctx) {
        FacesFlowProviderFactory factory = (FacesFlowProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (factory != null) {
            return factory;
        }
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                factory = (FacesFlowProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, FacesFlowProviderFactory.class, FacesFlowProviderFactory.FACTORY_DEFAULT);
                    }
                });
            } else {
                factory = (FacesFlowProviderFactory)SpiUtils.build(ctx, FacesFlowProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (factory != null) {
            FacesFlowProviderFactory.setFacesFlowProviderFactory(ctx, factory);
        }
        return factory;
    }

    public static void setFacesFlowProviderFactory(ExternalContext ctx, FacesFlowProviderFactory factory) {
        ctx.getApplicationMap().put(FACTORY_KEY, factory);
    }

    public abstract FacesFlowProvider getFacesFlowProvider(ExternalContext var1);
}

