/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.saml2.Saml20Attribute;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.HashUtils;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.token.Saml20TokenImpl;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.registry.RegistryHelper;
import com.ibm.wsspi.security.saml2.UserCredentialResolver;
import com.ibm.wsspi.security.saml2.UserIdentityException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.joda.time.DateTime;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AssertionToSubject {
    public static final TraceComponent tc = Tr.register(AssertionToSubject.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoConfig ssoConfig = null;
    Saml20Token token = null;
    SsoRequest samlRequest = null;
    public static final String KEY_USER_RESOLVER = "userResolver";
    static ConcurrentServiceReferenceMap<String, UserCredentialResolver> activatedUserResolverRef = new ConcurrentServiceReferenceMap("userResolver");
    static final String fixedStr = "_ibm";
    static final long serialVersionUID = -1475273301771710071L;

    public AssertionToSubject(SsoRequest samlRequest, SsoConfig ssoConfig, Saml20Token token) {
        this.ssoConfig = ssoConfig;
        this.token = token;
        this.samlRequest = samlRequest;
    }

    public static void setActivatedUserResolverRef(ConcurrentServiceReferenceMap<String, UserCredentialResolver> userResolverRef) {
        activatedUserResolverRef = userResolverRef;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activatedUserResolverRef size():" + activatedUserResolverRef.size()), (Object[])new Object[0]);
        }
    }

    public String getUser() throws SamlException {
        String user = null;
        if (activatedUserResolverRef.size() > 0 && (user = this.getUserFromUserResolver(user)) != null && !user.isEmpty()) {
            return user;
        }
        user = this.token.getSAMLNameID();
        String name = this.ssoConfig.getUserIdentifier();
        if (name != null && !name.isEmpty()) {
            user = null;
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().size() != 1) continue;
                user = (String)attribute.getValuesAsString().get(0);
            }
            if (user == null) {
                throw new SamlException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{"NameID"});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user from Token Attributes:" + user), (Object[])new Object[0]);
            }
        }
        if (user == null || user.isEmpty()) {
            throw new SamlException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{"NameID"});
        }
        return user;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    String getUserFromUserResolver(String user) throws SamlException {
        String userid = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                userid = userIdResolver.mapSAMLAssertionToUser(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), false, new Object[]{e});
            }
        }
        return userid;
    }

    public String getRealm() throws SamlException {
        String realm = null;
        if (activatedUserResolverRef.size() > 0 && (realm = this.getRealmFromUserResolver()) != null && !realm.isEmpty()) {
            return realm;
        }
        realm = this.ssoConfig.getRealmName();
        if (realm != null && !realm.isEmpty()) {
            return realm;
        }
        realm = this.token.getSAMLIssuerName();
        String name = this.ssoConfig.getRealmIdentifier();
        if (name != null && !name.isEmpty()) {
            realm = null;
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().size() != 1) continue;
                realm = (String)attribute.getValuesAsString().get(0);
            }
            if (realm == null) {
                throw new SamlException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{"realm"});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("realm from Token Attributes:" + realm), (Object[])new Object[0]);
            }
        }
        if (realm == null) {
            throw new SamlException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{"realm"});
        }
        return realm;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    String getRealmFromUserResolver() throws SamlException {
        String realm = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                realm = userIdResolver.mapSAMLAssertionToRealm(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), new Object[]{e});
            }
        }
        return realm;
    }

    public String getUserUniqueIdentity(String user, String realm) throws SamlException {
        String uid = null;
        if (activatedUserResolverRef.size() > 0 && (uid = this.getUserUniqueIDFromUserResolver(user)) != null && !uid.isEmpty()) {
            return uid;
        }
        uid = user;
        String name = this.ssoConfig.getUserUniqueIdentifier();
        if (name != null && !name.isEmpty()) {
            uid = null;
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().size() != 1) continue;
                uid = (String)attribute.getValuesAsString().get(0);
            }
            if (uid == null) {
                throw new SamlException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{"unique nameID"});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unique nameId from Token Attributes:" + uid), (Object[])new Object[0]);
            }
        }
        if (uid == null) {
            throw new SamlException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{"unique nameID"});
        }
        String prefix = "user:" + realm + "/";
        if (!uid.startsWith(prefix)) {
            int userIndex = uid.indexOf("/");
            uid = uid.startsWith("user:") && userIndex > 0 ? prefix + uid.substring(userIndex + 1) : prefix + uid;
        }
        return uid;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    String getUserUniqueIDFromUserResolver(String user) throws SamlException {
        String uid = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                uid = userIdResolver.mapSAMLAssertionToUserUniqueID(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), new Object[]{e});
            }
        }
        return uid;
    }

    public List<String> getGroupUniqueIdentityFromRegistry(String realm) throws WSSecurityException, RemoteException, SamlException {
        List<String> newGroups;
        if (activatedUserResolverRef.size() > 0 && (newGroups = this.getGroupsFromUserResolver()) != null && newGroups.size() > 0) {
            return this.mapGroupsToUserRegistry(newGroups, realm);
        }
        ArrayList<String> groups = new ArrayList<String>();
        String name = this.ssoConfig.getGroupIdentifier();
        if (name != null) {
            String idpRealmPrefix = "group:" + realm + "/";
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().isEmpty()) continue;
                for (String idpGroup : attribute.getValuesAsString()) {
                    this.mapGroupToUserRegistry(groups, idpGroup, idpRealmPrefix);
                }
            }
        }
        return groups;
    }

    @FFDCIgnore(value={EntryNotFoundException.class})
    List<String> mapGroupToUserRegistry(List<String> groups, String origGroup, String origRealmPrefix) throws RemoteException, WSSecurityException {
        int groupIndex;
        UserRegistry reg = RegistryHelper.getUserRegistry(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("UserRegistry:" + reg), (Object[])new Object[0]);
        }
        if (origGroup != null && origGroup.startsWith(origRealmPrefix)) {
            origGroup = origGroup.substring(origRealmPrefix.length());
        } else if (origGroup != null && origGroup.startsWith("group:") && (groupIndex = origGroup.indexOf("/")) > 0) {
            origGroup = origGroup.substring(groupIndex + 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("original Group:" + origGroup), (Object[])new Object[0]);
        }
        try {
            String groupDN = reg.getUniqueGroupId(origGroup);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("groupDN from registry:" + groupDN), (Object[])new Object[0]);
            }
            String group = origRealmPrefix + groupDN;
            groups.add(group);
            List localGroups = reg.getUniqueGroupIds(groupDN);
            ListIterator it3 = localGroups.listIterator();
            while (it3.hasNext()) {
                groupDN = (String)it3.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("groupDN from GroupIds:" + groupDN), (Object[])new Object[0]);
                }
                group = origRealmPrefix + groupDN;
                groups.add(group);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        return groups;
    }

    List<String> mapGroupsToUserRegistry(List<String> oldGroups, String realm) throws RemoteException, WSSecurityException {
        String origRealmPrefix = "group:" + realm + "/";
        ArrayList<String> groups = new ArrayList<String>();
        for (String group : oldGroups) {
            this.mapGroupToUserRegistry(groups, group, origRealmPrefix);
        }
        return groups;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    List<String> getGroupsFromUserResolver() throws SamlException {
        List groups = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                groups = userIdResolver.mapSAMLAssertionToGroups(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), new Object[]{e});
            }
        }
        return groups;
    }

    public List<String> getGroupUniqueIdentity(String realm) throws SamlException {
        List<String> newGroups;
        ArrayList<String> groups = new ArrayList<String>();
        if (activatedUserResolverRef.size() > 0 && (newGroups = this.getGroupsFromUserResolver()) != null && newGroups.size() > 0) {
            String groupPrefix = "group:" + realm + "/";
            for (String group : newGroups) {
                if (!group.startsWith("group:")) {
                    group = groupPrefix + group;
                }
                groups.add(group);
            }
            return groups;
        }
        String name = this.ssoConfig.getGroupIdentifier();
        if (name != null && !name.isEmpty()) {
            String idpRealmPrefix = "group:" + realm + "/";
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().isEmpty()) continue;
                for (String groupDN : attribute.getValuesAsString()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("groupDN from Token Attributes:" + groupDN), (Object[])new Object[0]);
                    }
                    String group = groupDN;
                    if (!groupDN.startsWith(idpRealmPrefix)) {
                        int groupIndex = groupDN.indexOf("/");
                        group = groupDN.startsWith("group:") && groupIndex > 0 ? idpRealmPrefix + groupDN.substring(groupIndex + 1) : idpRealmPrefix + groupDN;
                    }
                    groups.add(group);
                }
            }
        }
        return groups;
    }

    @Trivial
    public String getCustomCacheKeyValue(String providerName) {
        if (this.samlRequest.isDisableLtpaCookie()) {
            String preCookieValue = SamlUtil.generateRandom();
            this.samlRequest.setSpCookieValue(preCookieValue);
            return AssertionToSubject.getAfterDigestValue(providerName, preCookieValue);
        }
        String value = providerName + "_" + SamlUtil.hash(this.token.getSAMLAsString());
        this.samlRequest.setSpCookieValue(value);
        return value;
    }

    @Sensitive
    public static String getAfterDigestValue(String providerName, String preValue) {
        String preDigest = providerName + "_" + preValue + fixedStr;
        return HashUtils.digest(preDigest);
    }

    @Trivial
    public void handleSessionNotOnOrAfter(Hashtable<String, Object> hashtable, Saml20Token saml20Token) {
        if (this.samlRequest.isDisableLtpaCookie()) {
            long lSessionNotOnOrAfter = 0L;
            if (saml20Token instanceof Saml20TokenImpl) {
                lSessionNotOnOrAfter = ((Saml20TokenImpl)saml20Token).getSessionNotOnOrAfter();
            }
            if (lSessionNotOnOrAfter == 0L) {
                lSessionNotOnOrAfter = new DateTime().getMillis() + this.ssoConfig.getSessionNotOnOrAfter();
            }
            hashtable.put("com.ibm.ws.saml.spcookie.session.not.on.or.after", lSessionNotOnOrAfter);
        }
    }
}

