/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.grpc.Attributes;
import io.grpc.ForwardingServerBuilder;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.servlet.ServletAdapter;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ServletServerBuilder
extends ForwardingServerBuilder<ServletServerBuilder> {
    List<? extends ServerStreamTracer.Factory> streamTracerFactories;
    int maxInboundMessageSize = 0x400000;
    private final ServerImplBuilder serverImplBuilder = new ServerImplBuilder(this::buildTransportServers);
    private ScheduledExecutorService scheduler;
    private boolean internalCaller;
    private boolean usingCustomScheduler;
    private InternalServerImpl internalServer;
    static final long serialVersionUID = 3068689881764596090L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Server build() {
        return super.build();
    }

    public ServletAdapter buildServletAdapter() {
        return new ServletAdapter(this.buildAndStart(), this.streamTracerFactories, this.maxInboundMessageSize);
    }

    /*
     * WARNING - void declaration
     */
    private ServerTransportListener buildAndStart() {
        Server server;
        try {
            this.internalCaller = true;
            server = this.build().start();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"io.grpc.servlet.ServletServerBuilder", (String)"104", (Object)((Object)this), (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
        finally {
            this.internalCaller = false;
        }
        if (!this.usingCustomScheduler) {
            this.scheduler = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
        }
        ServerTransportImpl serverTransport = new ServerTransportImpl(this.scheduler);
        final ServerTransportListener delegate = this.internalServer.serverListener.transportCreated((ServerTransport)serverTransport);
        return new ServerTransportListener(){
            static final long serialVersionUID = -956142470566927164L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void streamCreated(ServerStream stream, String method, Metadata headers) {
                delegate.streamCreated(stream, method, headers);
            }

            public Attributes transportReady(Attributes attributes) {
                return delegate.transportReady(attributes);
            }

            public void transportTerminated() {
                server.shutdown();
                delegate.transportTerminated();
                if (!ServletServerBuilder.this.usingCustomScheduler) {
                    SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)ServletServerBuilder.this.scheduler);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$1", 1.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
            }
        };
    }

    InternalServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        Preconditions.checkNotNull(streamTracerFactories, (Object)"streamTracerFactories");
        this.streamTracerFactories = streamTracerFactories;
        this.internalServer = new InternalServerImpl();
        return this.internalServer;
    }

    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    public ServletServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS should be configured by the servlet container");
    }

    public ServletServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument((bytes >= 0 ? 1 : 0) != 0, (Object)"bytes must be >= 0");
        this.maxInboundMessageSize = bytes;
        return this;
    }

    public ServletServerBuilder scheduledExecutorService(ScheduledExecutorService scheduler) {
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        this.usingCustomScheduler = true;
        return this;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder", ServletServerBuilder.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    @VisibleForTesting
    static final class ServerTransportImpl
    implements ServerTransport {
        private final InternalLogId logId = InternalLogId.allocate(ServerTransportImpl.class, null);
        private final ScheduledExecutorService scheduler;
        static final long serialVersionUID = -2717900637925887099L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ServerTransportImpl(ScheduledExecutorService scheduler) {
            this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        }

        public void shutdown() {
        }

        public void shutdownNow(Status reason) {
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduler;
        }

        public ListenableFuture<InternalChannelz.SocketStats> getStats() {
            return null;
        }

        public InternalLogId getLogId() {
            return this.logId;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$ServerTransportImpl", ServerTransportImpl.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class InternalServerImpl
    implements InternalServer {
        ServerListener serverListener;
        static final long serialVersionUID = 1614851166043272093L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        InternalServerImpl() {
        }

        public void start(ServerListener listener) {
            this.serverListener = listener;
        }

        public void shutdown() {
            if (this.serverListener != null) {
                this.serverListener.serverShutdown();
            }
        }

        public SocketAddress getListenSocketAddress() {
            return new SocketAddress(){
                static final long serialVersionUID = -6757261809185057330L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public String toString() {
                    return "ServletServer";
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$InternalServerImpl$1", 1.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
                }
            };
        }

        public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
            return null;
        }

        public List<? extends SocketAddress> getListenSocketAddresses() {
            return Collections.emptyList();
        }

        public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSocketStatsList() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerBuilder$InternalServerImpl", InternalServerImpl.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }
}

