/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.EntityGroupName;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.AffiliateMember;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityGroupNamePredicate
implements Predicate<EntityDescriptor> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityGroupNamePredicate.class);
    @Nonnull
    @NonnullElements
    private final Set<String> groupNames;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    @NonnullElements
    private Collection<CriteriaSet> criteriaSets;

    public EntityGroupNamePredicate(@Nullable @ParameterName(name="names") Collection<String> names) {
        this(names, null);
    }

    public EntityGroupNamePredicate(@Nullable @ParameterName(name="names") Collection<String> names, @Nullable @ParameterName(name="resolver") MetadataResolver resolver) {
        this.groupNames = Collections.unmodifiableSet(new HashSet(StringSupport.normalizeStringCollection(names)));
        this.metadataResolver = resolver;
        if (resolver != null) {
            this.criteriaSets = new ArrayList<CriteriaSet>(this.groupNames.size());
            for (String name : this.groupNames) {
                this.criteriaSets.add(new CriteriaSet(new Criterion[]{new EntityIdCriterion(name)}));
            }
        }
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<String> getGroupNames() {
        return this.groupNames;
    }

    public boolean test(@Nullable EntityDescriptor input) {
        if (input == null) {
            this.log.debug("Input was null, condition is false");
            return false;
        }
        for (EntityGroupName group : input.getObjectMetadata().get(EntityGroupName.class)) {
            if (!this.groupNames.contains(group.getName())) continue;
            this.log.debug("Found matching group '{}' attached to entity '{}'", (Object)group.getName(), (Object)input.getEntityID());
            return true;
        }
        if (this.metadataResolver != null) {
            for (CriteriaSet criteria : this.criteriaSets) {
                try {
                    EntityDescriptor affiliation = (EntityDescriptor)this.metadataResolver.resolveSingle(criteria);
                    if (affiliation == null || affiliation.getAffiliationDescriptor() == null) continue;
                    for (AffiliateMember member : affiliation.getAffiliationDescriptor().getMembers()) {
                        if (!member.getURI().equals(input.getEntityID())) continue;
                        this.log.debug("Found AffiliationDescriptor '{}' membership for entity '{}'", (Object)affiliation.getEntityID(), (Object)input.getEntityID());
                        return true;
                    }
                }
                catch (ResolverException e) {
                    this.log.warn("Metadata lookup for AffiliationDescriptor failed", (Throwable)e);
                }
            }
        }
        this.log.debug("No group match found for entity '{}'", (Object)input.getEntityID());
        return false;
    }
}

