/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest.v1.utils;

import com.ibm.ws.ui.internal.rest.CommonJSONRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.rest.exceptions.UserNotAuthorizedException;
import com.ibm.ws.ui.internal.v1.IFeatureToolService;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.util.HashMap;
import java.util.Map;

public class FeatureUtils
extends CommonJSONRESTHandler {
    private final IFeatureToolService featureToolService;

    public FeatureUtils(IFeatureToolService featureToolService) {
        super("/adminCenter/v1/utils/feature", true, false);
        this.featureToolService = featureToolService;
    }

    @Override
    public Map<String, String> getBase(RESTRequest request, RESTResponse response) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String url = request.getURL();
        map.put("{featureName}", url + (url.endsWith("/") ? "{featureName}" : "/{featureName}"));
        return map;
    }

    @Override
    public Map<String, Boolean> getChild(RESTRequest request, RESTResponse response, String featureToFind) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("provisioned", this.featureToolService.isFeatureProvisioned(featureToFind));
        return data;
    }
}

