/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;

public final class ThreadLocalX509TrustEngineContext {
    private static ThreadLocal<Data> current = new ThreadLocal();

    private ThreadLocalX509TrustEngineContext() {
    }

    public static void loadCurrent(@Nonnull TrustEngine<? super X509Credential> trustEngine, @Nonnull CriteriaSet criteria, @Nullable Boolean fatal) {
        Constraint.isNotNull(trustEngine, (String)"TrustEngine may not be null");
        Constraint.isNotNull((Object)criteria, (String)"CriteriaSet may not be null");
        current.set(new Data(trustEngine, criteria, fatal));
    }

    public static void clearCurrent() {
        current.remove();
    }

    public static boolean haveCurrent() {
        return current.get() != null;
    }

    @Nullable
    public static TrustEngine<? super X509Credential> getTrustEngine() {
        return current.get() != null ? current.get().trustEngine : null;
    }

    @Nullable
    public static CriteriaSet getCriteria() {
        return current.get() != null ? current.get().criteriaSet : null;
    }

    @Nonnull
    public static Boolean isFailureFatal() {
        return current.get() != null ? current.get().failureFatal : Boolean.TRUE;
    }

    @Nullable
    public static Boolean getTrusted() {
        return current.get() != null ? current.get().trusted : null;
    }

    public static void setTrusted(@Nullable Boolean trusted) {
        if (current.get() != null) {
            current.get().trusted = trusted;
        }
    }

    private static final class Data {
        private TrustEngine<? super X509Credential> trustEngine;
        private CriteriaSet criteriaSet;
        private Boolean trusted;
        private Boolean failureFatal;

        private Data(@Nonnull TrustEngine<? super X509Credential> engine, @Nonnull CriteriaSet criteria, @Nullable Boolean fatal) {
            this.trustEngine = engine;
            this.criteriaSet = criteria;
            this.failureFatal = fatal != null ? fatal : Boolean.TRUE;
        }
    }
}

