/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.support;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SAML2MetadataSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SAML2MetadataSupport.class);

    private SAML2MetadataSupport() {
    }

    public static <T extends IndexedEndpoint> T getDefaultIndexedEndpoint(List<T> candidates) {
        LOG.debug("Selecting default IndexedEndpoint");
        if (candidates == null || candidates.isEmpty()) {
            LOG.debug("IndexedEndpoint list was null or empty, returning null");
            return null;
        }
        IndexedEndpoint firstNoDefault = null;
        for (IndexedEndpoint endpoint : candidates) {
            if (endpoint.isDefault().booleanValue()) {
                LOG.debug("Selected IndexedEndpoint with explicit isDefault of true");
                return (T)endpoint;
            }
            if (firstNoDefault != null || endpoint.isDefaultXSBoolean() != null) continue;
            firstNoDefault = endpoint;
        }
        if (firstNoDefault != null) {
            LOG.debug("Selected first IndexedEndpoint with no explicit isDefault");
            return (T)firstNoDefault;
        }
        LOG.debug("Selected first IndexedEndpoint with explicit isDefault of false");
        return (T)((IndexedEndpoint)candidates.get(0));
    }
}

