/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.persist;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.persist.ConditionalLoadXMLObjectLoadSaveManager;

public abstract class AbstractConditionalLoadXMLObjectLoadSaveManager<T extends XMLObject>
implements ConditionalLoadXMLObjectLoadSaveManager<T> {
    private boolean loadConditionally;
    private Map<String, Instant> loadLastModified = new HashMap<String, Instant>();

    protected AbstractConditionalLoadXMLObjectLoadSaveManager(@ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        this.loadConditionally = conditionalLoad;
    }

    @Override
    public boolean isLoadConditionally() {
        return this.loadConditionally;
    }

    @Override
    @Nullable
    public synchronized Instant getLoadLastModified(@Nonnull String key) {
        return this.loadLastModified.get(key);
    }

    @Override
    @Nullable
    public synchronized Instant clearLoadLastModified(@Nonnull String key) {
        Instant prev = this.loadLastModified.get(key);
        this.loadLastModified.remove(key);
        return prev;
    }

    @Override
    public void clearAllLoadLastModified() {
        this.loadLastModified.clear();
    }

    protected synchronized Instant updateLoadLastModified(@Nonnull String key) {
        return this.updateLoadLastModified(key, Instant.now());
    }

    @Nullable
    protected synchronized Instant updateLoadLastModified(@Nonnull String key, @Nullable Instant modified) {
        if (modified == null) {
            return null;
        }
        Instant prev = this.loadLastModified.get(key);
        this.loadLastModified.put(key, modified);
        return prev;
    }

    protected abstract boolean isUnmodifiedSinceLastLoad(@Nonnull String var1) throws IOException;
}

