/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions.ct;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmRetransmissionIntervalHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmRetransmissionMaxIntervalHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmTransactionTimeoutHeader;
import com.ibm.ws.sip.stack.dispatch.TimerEvent;
import com.ibm.ws.sip.stack.transaction.SIPStackConfiguration;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionHelper;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public class SIPNonInviteClientTransactionImpl
extends SIPClientTransactionImpl {
    public static final int STATE_TRYING = 0;
    private TimerF m_timerF;
    private TimerE m_timerE;
    private TimerK m_timerK;
    private final int m_timerFvalue;
    private int m_timerEvalue;
    private Response m_lastResponse;
    private final int m_timerT2value;
    private static final LogMgr c_logger = Log.get(SIPNonInviteClientTransactionImpl.class);

    public SIPNonInviteClientTransactionImpl(SIPTransactionStack transactionStack, SipProvider provider, Request req, BranchMethodKey key, long transactionId) {
        super(transactionStack, provider, req, key, transactionId);
        this.m_timerFvalue = SIPNonInviteClientTransactionImpl.getTimerF(req);
        this.m_timerEvalue = SIPNonInviteClientTransactionImpl.getTimerE(req);
        this.m_timerT2value = SIPNonInviteClientTransactionImpl.getTimerT2(req);
    }

    @Override
    public synchronized void processRequest(Request sipRequest) throws SipParseException {
        try {
            switch (this.getState()) {
                case -1: {
                    this.setState(0);
                    this.m_timerF = new TimerF(this, this.getCallId());
                    this.addTimerTask(this.m_timerF, this.m_timerFvalue);
                    this.sendRequestToTransport(sipRequest);
                    if (this.isTransportReliable()) break;
                    this.m_timerE = new TimerE(this, this.getCallId());
                    this.addTimerTask(this.m_timerE, this.m_timerEvalue);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
        catch (SIPTransportException exp) {
            this.prossesTransportError();
        }
    }

    @Override
    public synchronized void processResponse(Response sipResponse) throws SipParseException {
        switch (this.getState()) {
            case 0: {
                if (SIPTransactionHelper.isProvionalResponse(sipResponse.getStatusCode())) {
                    this.setState(1);
                    this.sendResponseToUA(sipResponse);
                    break;
                }
                if (!SIPTransactionHelper.isFinalResponse(sipResponse.getStatusCode())) break;
                this.setFinalResponse(sipResponse);
                this.sendResponseToUA(sipResponse);
                this.setCompletedState();
                break;
            }
            case 1: {
                if (!SIPTransactionHelper.isFinalResponse(sipResponse.getStatusCode())) break;
                this.setFinalResponse(sipResponse);
                this.sendResponseToUA(sipResponse);
                this.setCompletedState();
                break;
            }
        }
        this.m_lastResponse = sipResponse;
    }

    @Override
    public synchronized void prossesTransportError() {
        this.notifyRequestErrorToUA(this.getFirstRequest());
        this.destroyTransaction();
    }

    private synchronized void setCompletedState() {
        if (this.m_timerE != null) {
            this.m_timerE.cancel();
        }
        if (this.m_timerF != null) {
            this.m_timerF.cancel();
        }
        if (this.isTransportReliable()) {
            this.destroyTransaction();
        } else {
            this.setState(2);
            long delay = this.getParentStack().getConfiguration().getTimerK();
            this.m_timerK = new TimerK(this, this.getCallId());
            this.addTimerTask(this.m_timerK, delay);
        }
    }

    private static int getTimerE(Request request) {
        int timerValue;
        block4: {
            timerValue = -1;
            try {
                IbmRetransmissionIntervalHeader header = (IbmRetransmissionIntervalHeader)request.getHeader("IBM-RetransmissionInterval", true);
                if (header != null && header.applicationCreated()) {
                    timerValue = header.getTimeValue();
                    request.removeHeader("IBM-RetransmissionInterval", true);
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug(SIPNonInviteClientTransactionImpl.class, "getTimerE", "error getting header [IBM-RetransmissionInterval] in message\r\n" + request, e2);
            }
        }
        if (timerValue == -1) {
            SIPStackConfiguration config = SIPTransactionStack.instance().getConfiguration();
            timerValue = config.getTimerE();
        }
        return timerValue;
    }

    private static int getTimerF(Request request) {
        int timerValue;
        block4: {
            timerValue = -1;
            try {
                IbmTransactionTimeoutHeader header = (IbmTransactionTimeoutHeader)request.getHeader("IBM-TransactionTimeout", true);
                if (header != null && header.applicationCreated()) {
                    timerValue = header.getTimeValue();
                    request.removeHeader("IBM-TransactionTimeout", true);
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug(SIPNonInviteClientTransactionImpl.class, "getTimerF", "error getting header [IBM-TransactionTimeout] in message\r\n" + request, e2);
            }
        }
        if (timerValue == -1) {
            SIPStackConfiguration config = SIPTransactionStack.instance().getConfiguration();
            timerValue = config.getTimerF();
        }
        return timerValue;
    }

    static int getTimerT2(Request request) {
        int timerValue;
        block4: {
            timerValue = -1;
            try {
                IbmRetransmissionMaxIntervalHeader header = (IbmRetransmissionMaxIntervalHeader)request.getHeader("IBM-RetransmissionMaxInterval", true);
                if (header != null && header.applicationCreated()) {
                    timerValue = header.getTimeValue();
                    request.removeHeader("IBM-RetransmissionMaxInterval", true);
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug(SIPNonInviteClientTransactionImpl.class, "getTimerT2", "error getting header [IBM-RetransmissionInterval] in message\r\n" + request, e2);
            }
        }
        if (timerValue == -1) {
            SIPStackConfiguration config = SIPTransactionStack.instance().getConfiguration();
            timerValue = config.getTimerT2();
        }
        return timerValue;
    }

    synchronized void timerEfired() {
        boolean resend;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerEfired", "Timer E fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        switch (this.getState()) {
            case 0: {
                this.m_timerEvalue = 2 * this.m_timerEvalue > this.m_timerT2value ? this.m_timerT2value : 2 * this.m_timerEvalue;
                resend = true;
                break;
            }
            case 1: {
                this.m_timerEvalue = this.m_timerT2value;
                resend = true;
                break;
            }
            default: {
                resend = false;
            }
        }
        if (resend) {
            try {
                this.sendRequestToTransport(this.getFirstRequest());
                this.m_timerE = new TimerE(this, this.getCallId());
                this.addTimerTask(this.m_timerE, this.m_timerEvalue);
            }
            catch (SIPTransportException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "timerEfired", "", e2);
                }
                this.destroyTransaction();
            }
        }
    }

    @Override
    public synchronized void destroyTransaction() {
        this.setState(3);
        if (this.m_timerE != null) {
            this.m_timerE.cancel();
        }
        if (this.m_timerF != null) {
            this.m_timerF.cancel();
        }
        if (this.m_timerK != null) {
            this.m_timerK.cancel();
        }
        this.startAPITimer();
    }

    @Override
    public synchronized Response getMostRecentResponse() {
        return this.m_lastResponse;
    }

    @Override
    protected String getType() {
        return "Client non-INVITE";
    }

    void timerFfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerFfired", "Timer F fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() == 0 || this.getState() == 1) {
            this.notifyTransactionTimeoutToUA();
            this.destroyTransaction();
        }
    }

    void timerKfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerKfired", "Timer K fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() == 2) {
            this.destroyTransaction();
        }
    }

    @Override
    public LogMgr getLoger() {
        return c_logger;
    }

    @Override
    public String getStateAsString() {
        switch (this.getState()) {
            case 0: {
                return "Trying";
            }
        }
        return super.getStateAsString();
    }

    public class TimerF
    extends TimerEvent {
        private SIPNonInviteClientTransactionImpl m_ct;

        TimerF(SIPNonInviteClientTransactionImpl ct, String callId) {
            super(callId);
            this.m_ct = ct;
        }

        @Override
        public void onExecute() {
            if (this.m_ct != null) {
                this.m_ct.timerFfired();
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }

    static class TimerE
    extends TimerEvent {
        private SIPNonInviteClientTransactionImpl m_ct;

        TimerE(SIPNonInviteClientTransactionImpl ct, String callId) {
            super(callId);
            this.m_ct = ct;
        }

        @Override
        public void onExecute() {
            if (this.m_ct != null) {
                this.m_ct.timerEfired();
                this.m_ct = null;
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }

    static class TimerK
    extends TimerEvent {
        private SIPNonInviteClientTransactionImpl m_ct;

        TimerK(SIPNonInviteClientTransactionImpl ct, String callId) {
            super(callId);
            this.m_ct = ct;
        }

        @Override
        public void onExecute() {
            if (this.m_ct != null) {
                this.m_ct.timerKfired();
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }
}

