/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericNameAddressHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.router.CompositionData;
import com.ibm.ws.sip.container.router.CompositionInfoMap;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.servlets.TelURLImpl;
import com.ibm.ws.sip.container.servlets.URIImpl;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.dar.util.StateInfo;
import com.ibm.ws.sip.security.auth.AuthInfoFactory;
import com.ibm.ws.sip.security.auth.AuthInfoImpl;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.wsspi.webcontainer.servlet.IServletRequestWrapper;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.RecordRouteHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.message.Request;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public abstract class SipServletRequestImpl
extends SipServletMessageImpl
implements SipServletRequest,
IServletRequestWrapper,
Serializable {
    static final long serialVersionUID = -546972310341594665L;
    private static final LogMgr c_logger = Log.get(SipServletRequestImpl.class);
    private boolean m_isInital = false;
    private transient HashMap m_excludeAppsList;
    protected transient URI m_requestURI;
    protected static final String APP_PATH_HEADER = "Siplets-App-Path";
    public static final String COMPOSITION_ID = "Composition-Id";
    private static final String SIPLETS_SEPARATOR = ";#$";
    private transient boolean _checkedTopRoute;
    private SipServletRequestImpl _b2bLinkedRequest;
    protected Address _poppedRoute = null;
    protected Address _initialPoppedRoute = null;
    private SipApplicationRoutingDirective directive = null;
    private Serializable stateInfo;
    private String nextApplication = null;
    private SipApplicationRoutingRegion routingRegion = null;
    private URI subscriberURI = null;
    private boolean externalRoute = false;
    private SipURIImpl externalRouteUri = null;
    private transient boolean m_isUnmatchedReqeust = false;

    public SipServletRequestImpl(IncomingSipServletRequest request) {
        super(request);
        this.m_requestURI = request.getRequestURI();
        this._checkedTopRoute = request.isCheckedTopRoute();
        this._b2bLinkedRequest = request.getB2bLinkedRequest();
        this._poppedRoute = request.getPoppedRoute();
        this._initialPoppedRoute = request.getInitialPoppedRoute();
        this.subscriberURI = request.getSubscriberURI();
    }

    public SipServletRequestImpl() {
    }

    public SipServletRequestImpl(Request request, long transactionId, SipProvider provider) {
        super(request, transactionId, provider);
        this.extractCompositionInfo();
    }

    public String getVirtualHost() {
        String virtualHost = null;
        TransactionUserWrapper tu = this.getTransactionUser();
        if (tu != null) {
            virtualHost = tu.getSipServletDesc().getSipApp().getVirtualHostName();
        } else if (this.m_excludeAppsList != null && this.m_excludeAppsList.size() != 0) {
            SipAppDesc appDesc;
            Set keySet = this.m_excludeAppsList.keySet();
            Iterator iter = keySet.iterator();
            String appName = null;
            if (iter.hasNext()) {
                appName = (String)iter.next();
            }
            if (appName != null && (appDesc = SipContainer.getInstance().getSipApp(appName)) != null) {
                virtualHost = appDesc.getVirtualHostName();
            }
        }
        return virtualHost;
    }

    private void extractCompositionInfo() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "extractCompositionInfo");
        }
        try {
            Header compositionIdHeader = this.getRequest().getHeader(COMPOSITION_ID, true);
            if (compositionIdHeader != null) {
                String compositionId = compositionIdHeader.getValue();
                CompositionData compositionData = CompositionInfoMap.getInstance().removeCompositionInfo(compositionId);
                if (compositionData == null && c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "extractCompositionInfo", "Composition Id: " + compositionId + " was not found!");
                }
                this.setDirective(compositionData.getRoutingDirective());
                this.setSubscriberURI(compositionData.getSubscriberUri());
                this.setRoutingRegion(compositionData.getRoutingRegion());
                this.setStateInfo(compositionData.getStateInfo());
                this.setNextApplication(compositionData.getNextApplication());
                this._initialPoppedRoute = compositionData.getInitialPoppedRoute();
                this.getRequest().removeHeader(COMPOSITION_ID, true);
            }
        }
        catch (IllegalArgumentException e2) {
            c_logger.error(e2.getMessage());
        }
        catch (HeaderParseException e3) {
            c_logger.error(e3.getMessage());
        }
        catch (NullPointerException e4) {
            c_logger.error(e4.getMessage());
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("\n").append("Composition data retrieved from the map: \n").append("----------------- \n").append("Next application  = " + this.getNextApplication() + " \n").append("Subscriber uri    = " + this.getSubscriberURI() + " \n").append("Routing region    = " + this.getRegion() + " \n").append("Routing directive = " + (Object)((Object)this.getDirective()) + " \n\n");
            c_logger.traceDebug(this, "extractCompositionInfo", buff.toString());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "extractCompositionInfo");
        }
    }

    private final void createExcludeMapIfNeeded() {
        if (null == this.m_excludeAppsList) {
            this.m_excludeAppsList = new HashMap(3);
        }
    }

    public Request getRequest() {
        return (Request)this.getMessage();
    }

    public boolean fromCaller() {
        return false;
    }

    @Override
    public int getMaxForwards() {
        int rValue;
        block4: {
            rValue = -1;
            Request request = this.getRequest();
            if (null != request) {
                try {
                    MaxForwardsHeader h = request.getMaxForwardsHeader();
                    if (null != h) {
                        rValue = h.getMaxForwards();
                    }
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isErrorEnabled()) break block4;
                    Object[] args = new Object[]{};
                    c_logger.error("error.get.max.forwards", "Request", args, (Throwable)e2);
                }
            }
        }
        return rValue;
    }

    @Override
    public Proxy getProxy(boolean create) throws TooManyHopsException {
        if (this.isUnmatchedReqeust()) {
            throw new IllegalStateException("This is unmatched incoming request. It is incactive");
        }
        SipTransaction transaction = this.getTransaction();
        if (transaction == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getProxy", "Failed to get proxy - ServerTransaction object unavailable. ");
            }
            return null;
        }
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        if (create && transactionUser.isB2B()) {
            throw new IllegalStateException("the application cannot act as Proxy after this application wishes to be a B2BUA");
        }
        if (create && transactionUser.isUAS()) {
            throw new IllegalStateException("the application cannot act as Proxy after this application wishes to be a UAS");
        }
        Proxy proxy = null;
        proxy = transaction.getProxy(false);
        if (!create || proxy != null) {
            return proxy;
        }
        if (transaction.isTerminated()) {
            throw new IllegalStateException("Transaction already completed");
        }
        if (!this.isInitial()) {
            if (proxy != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getProxy", "not initial request, return same proxy object, that was generated for initial request");
                }
                return proxy;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getProxy", "Unable to get Proxy for Request, not initial request: " + this);
            }
            throw new IllegalStateException("Unable to create proxy for subsequent requests on the same dialog");
        }
        int maxForwards = this.getMaxForwards();
        if (maxForwards == -1) {
            this.addHeader("Max-Forwards", "70");
        } else if (maxForwards == 0) {
            throw new TooManyHopsException();
        }
        proxy = transaction.getProxy(create);
        transactionUser.setIsProxying(true);
        return proxy;
    }

    @Override
    public Proxy getProxy() throws TooManyHopsException, IllegalStateException {
        return this.getProxy(true);
    }

    @Override
    public abstract B2buaHelper getB2buaHelper();

    public B2buaHelper getB2buaHelper(boolean create, UAMode mode) throws IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipServletRequestImpl.class.getName(), "getB2buaHelper");
        }
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        B2buaHelper b2buaHelper = null;
        if (transactionUser != null) {
            b2buaHelper = transactionUser.getB2buaHelper(create, mode);
        } else if (create) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getB2buaHelper", "Failed to get B2buaHelper - Transaction object unavailable. ");
            }
            throw new IllegalStateException("can not create getB2buaHelper without transaction");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)SipServletRequestImpl.class.getName(), "getB2buaHelper", b2buaHelper);
        }
        return b2buaHelper;
    }

    @Override
    public boolean isInitial() {
        return this.m_isInital;
    }

    @Override
    protected boolean checkIsSystemContactHeader() {
        boolean isSystemHeader = true;
        if (this.getMethod().equals("REGISTER")) {
            isSystemHeader = false;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)SipServletRequestImpl.class.getName(), "checkIsSystemContactHeader", isSystemHeader);
        }
        return isSystemHeader;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getParameter(String arg0) {
        return null;
    }

    public Map getParameterMap() {
        return null;
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String arg0) {
        return null;
    }

    @Deprecated
    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getScheme() {
        return this.getRequestURI().getScheme();
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    @Override
    public void removeAttribute(String key) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (this.m_attributes != null) {
            this.m_attributes.remove(key);
        }
    }

    public void setIsInital(boolean isInital) {
        this.m_isInital = isInital;
    }

    public boolean isInExcludeAppsList(SipAppDesc appDesc) {
        SipServletDesc handler;
        boolean rc = false;
        TransactionUserWrapper tUser = this.getTransactionUser();
        if (tUser != null && null != (handler = tUser.getSipServletDesc()) && appDesc.equals(handler.getSipApp())) {
            rc = true;
        }
        if (!rc && this.m_excludeAppsList != null && this.m_excludeAppsList.containsKey(this.getHashkeyForApp(appDesc))) {
            rc = true;
        }
        return rc;
    }

    public void addToExcludeSipletsList(HashMap excludeSiplets) {
        if (null == excludeSiplets) {
            return;
        }
        this.createExcludeMapIfNeeded();
        this.m_excludeAppsList.putAll(excludeSiplets);
    }

    public void addToExcludeAppsList(SipAppDesc appDesc) {
        if (null == appDesc) {
            return;
        }
        this.createExcludeMapIfNeeded();
        this.m_excludeAppsList.put(this.getHashkeyForApp(appDesc), null);
    }

    private String getHashkeyForApp(SipAppDesc sipApp) {
        return sipApp.getApplicationName();
    }

    public String getExcludeSipletsList() {
        if (null == this.m_excludeAppsList) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(32);
        Iterator iter = this.m_excludeAppsList.keySet().iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(SIPLETS_SEPARATOR);
        }
        return buffer.toString();
    }

    public HashMap getExcludedAppsList() {
        return this.m_excludeAppsList;
    }

    @Override
    public URI getRequestURI() {
        block4: {
            if (null == this.m_requestURI) {
                try {
                    jain.protocol.ip.sip.address.URI jainUri = this.getRequest().getRequestURI();
                    if (jainUri != null) {
                        String scheme = jainUri.getScheme();
                        this.m_requestURI = SipURIImpl.isSchemeSupported(scheme) ? new SipURIImpl((SipURL)jainUri) : (TelURLImpl.isSchemeSupported(scheme) ? new TelURLImpl(jainUri) : new URIImpl(jainUri));
                    }
                }
                catch (SipParseException e2) {
                    if (!c_logger.isErrorEnabled()) break block4;
                    Object[] args = new Object[]{this.getRequest()};
                    c_logger.error("error.get.request.uri", "Request", args, (Throwable)e2);
                }
            }
        }
        return this.m_requestURI;
    }

    private void validatePushRoute() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        boolean isIncomingRequest = false;
        this.checkTopRouteDestination(isIncomingRequest);
    }

    @Override
    public void pushRoute(SipURI uri) {
        this.validatePushRoute();
        SipURL jainSipUri = ((SipURIImpl)uri).getJainSipUrl();
        NameAddress address = this.getAddressFactory().createNameAddress(jainSipUri);
        this.setRouteHeader(address);
    }

    private void setRouteHeader(NameAddress address) {
        block4: {
            try {
                RouteHeader routeH = this.getHeadersFactory().createRouteHeader(address);
                this.addHeader(routeH, true);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{address};
                    c_logger.error("error.push.route", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block4;
                Object[] args = new Object[]{address};
                c_logger.error("error.push.route", "Request", args, (Throwable)e3);
            }
        }
    }

    @Override
    public void pushRoute(Address uri) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "pushRoute", "Pushing address to route header" + uri);
        }
        this.validatePushRoute();
        if (!(uri instanceof AddressImpl) || !(uri.getURI() instanceof SipURIImpl)) {
            throw new IllegalArgumentException("Pushing a non-SIP route header to this request is illegal");
        }
        this.setRouteHeader(((AddressImpl)uri).getNameAddressHeader().getNameAddress());
    }

    @Override
    public void pushPath(Address uri) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (this.getMethod() != "REGISTER") {
            throw new IllegalStateException("Can not add Path header to non REGISTER request.");
        }
        SipURL jainSipPathUri = ((SipURIImpl)uri.getURI()).getJainSipUrl();
        NameAddress address = this.getAddressFactory().createNameAddress(jainSipPathUri);
        GenericNameAddressHeaderImpl pathHeader = new GenericNameAddressHeaderImpl("Path");
        pathHeader.setNameAddress(address);
        this.addHeader(pathHeader, true);
    }

    public void pushRecordRoute(SipURI uri) {
        block4: {
            try {
                SipURL jainSipUri = ((SipURIImpl)uri).getJainSipUrl();
                NameAddress address = this.getAddressFactory().createNameAddress(jainSipUri);
                RecordRouteHeader recordRouteH = this.getHeadersFactory().createRecordRouteHeader(address);
                this.addHeader(recordRouteH, true);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{uri};
                    c_logger.error("error.push.route", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block4;
                Object[] args = new Object[]{uri};
                c_logger.error("error.push.route", "Request", args, (Throwable)e3);
            }
        }
    }

    public void addHeader(Header header, boolean first) {
        this.getRequest().addHeader(header, first);
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return null;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public void checkTopRouteDestination(boolean isIncomingRequest) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "checkTopRouteDestination", (Object)new Boolean(isIncomingRequest));
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("checkTopRouteDestination: request=" + this);
        }
        if (this._checkedTopRoute) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkTopRouteDestination", "Top Route already removed - not checking anymore");
            }
            return;
        }
        this._checkedTopRoute = true;
        Request request = this.getRequest();
        try {
            boolean doubleRecordRoute = this.isDoubleRecordRoute(request);
            String removedSessionId = this.removeRoute(request, isIncomingRequest);
            if (removedSessionId != null && doubleRecordRoute) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "checkTopRouteDestination", "Trying to remove another route header in case that it was added by the double record route mechanism");
                }
                this.removeRoute(request, false);
            }
        }
        catch (ServletParseException e1) {
            this.logException((Exception)((Object)e1));
        }
        catch (HeaderParseException e2) {
            this.logException(e2);
        }
        catch (NoSuchElementException e2) {
            this.logException(e2);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "checkTopRouteDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleRecordRoute(Request request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "isDoubleRecordRoute");
        }
        boolean rc = false;
        try {
            HeaderIterator iter = request.getHeaders("Route");
            if (iter != null) {
                NameAddressHeader secondRoute;
                NameAddressHeader firstRoute = iter.hasNext() ? (NameAddressHeader)iter.next() : null;
                NameAddressHeader nameAddressHeader = secondRoute = iter.hasNext() ? (NameAddressHeader)iter.next() : null;
                if (firstRoute != null && secondRoute != null) {
                    jain.protocol.ip.sip.address.URI firstRouteUri = firstRoute.getNameAddress().getAddress();
                    jain.protocol.ip.sip.address.URI secondRouteUri = secondRoute.getNameAddress().getAddress();
                    if (firstRouteUri instanceof SipURL && secondRouteUri instanceof SipURL) {
                        SipURL firstURL = (SipURL)firstRouteUri;
                        SipURL secondURL = (SipURL)secondRouteUri;
                        if (firstURL.hasParameter("ibmdrr") && secondURL.hasParameter("ibmdrr")) {
                            boolean bl = rc = true;
                            return bl;
                        }
                    }
                }
            }
        }
        catch (HeaderParseException e1) {
            this.logException(e1);
        }
        catch (IllegalArgumentException e2) {
            this.logException(e2);
        }
        catch (NoSuchElementException e3) {
            this.logException(e3);
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "isDoubleRecordRoute", rc);
            }
        }
        return rc;
    }

    private String removeRoute(Request request, boolean setPoppedRoute) throws ServletParseException, HeaderParseException, IllegalArgumentException {
        NameAddressHeader route = (NameAddressHeader)request.getHeader("Route", true);
        String removedSID = null;
        if (route != null) {
            jain.protocol.ip.sip.address.URI routeUri = route.getNameAddress().getAddress();
            if (routeUri instanceof SipURL) {
                String sessionParamID;
                SipURL url = (SipURL)routeUri;
                String sessionId = "";
                TransactionUserWrapper tu = this.getTransactionUser();
                if (tu != null) {
                    sessionId = tu.getSharedIdForDS();
                }
                if ((sessionParamID = url.getParameter("ibmsid")) == null || sessionParamID.equals(sessionId)) {
                    boolean secure;
                    String host = url.getHost();
                    int port = url.getPort();
                    boolean bl = secure = url.getScheme().equalsIgnoreCase("sips") || "tls".equalsIgnoreCase(url.getTransport());
                    if (this.checkIsLocalListeningPoint(host, port, secure)) {
                        if (setPoppedRoute) {
                            this.setPoppedRoute(this.getAddressHeader("Route"));
                        }
                        request.removeHeader("Route", true);
                        removedSID = sessionParamID;
                    }
                }
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeRoute", "There is no route header");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "removeRoute", removedSID);
        }
        return removedSID;
    }

    public boolean checkIsLocalListeningPoint(String host, int port, boolean secure) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "checkIsLocalListeningPoint", host, String.valueOf(port), String.valueOf(secure));
        }
        boolean rc = false;
        Iterator lpIter = SipContainer.getInstance().getListeningPoints();
        if (lpIter != null) {
            while (lpIter.hasNext()) {
                ListeningPointImpl lpoint = (ListeningPointImpl)lpIter.next();
                int lpointPort = lpoint.getPort();
                if (!SipServletRequestImpl.isSamePort(lpointPort, port, secure) || !SIPStackUtil.isSameHost(lpoint.getHost(), host) && (!lpoint.isAnyAddress() || !SipServletRequestImpl.isLocalHost(host))) continue;
                rc = true;
                break;
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "checkIsLocalListeningPoint", "Warning no listening points availalbe ");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("checkIsLocalListeningPoint: " + rc);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "checkIsLocalListeningPoint");
        }
        return rc;
    }

    private static boolean isSamePort(int port1, int port2, boolean secure) {
        if (port1 == -1) {
            int n = port1 = secure ? 5061 : 5060;
        }
        if (port2 == -1) {
            port2 = secure ? 5061 : 5060;
        }
        return port1 == port2;
    }

    private static boolean isLocalHost(String host) {
        return host.equals("127.0.0.1") || host.equals("::1") || host.equals("localhost");
    }

    public String getLocalName() {
        return null;
    }

    public ServletRequest getWrappedRequest() {
        return this.getHttpServletRequest();
    }

    @Override
    public void addAuthHeader(SipServletResponse response, AuthInfo authInfo) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        AuthInfoImpl writeableInfo = (AuthInfoImpl)authInfo;
        SipServletResponseImpl responseImpl = (SipServletResponseImpl)response;
        writeableInfo.writeToRequest(this, responseImpl);
    }

    @Override
    public void addAuthHeader(SipServletResponse challangeResponse, String userName, String password) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        AuthInfo authInfo = AuthInfoFactory.createAuthInfo();
        int statusCode = challangeResponse.getStatus();
        Iterator<String> iter = challangeResponse.getChallengeRealms();
        while (iter.hasNext()) {
            String element = iter.next();
            authInfo.addAuthInfo(statusCode, element, userName, password);
            this.addAuthHeader(challangeResponse, authInfo);
        }
    }

    public SipApplicationRoutingDirective getDirective() {
        return this.directive;
    }

    public void setDirective(SipApplicationRoutingDirective directive) {
        this.directive = directive;
    }

    public Serializable getStateInfo() {
        return this.stateInfo;
    }

    public void setStateInfo(Serializable stateInfo) {
        this.stateInfo = stateInfo;
        if (stateInfo != null && stateInfo instanceof StateInfo) {
            StateInfo info = (StateInfo)stateInfo;
            StateInfo temp = new StateInfo();
            temp.setIndex(info.getIndex());
            this.stateInfo = temp;
        }
    }

    public String getNextApplication() {
        return this.nextApplication;
    }

    public void setNextApplication(String nextApplication) {
        this.nextApplication = nextApplication;
    }

    @Override
    public SipApplicationRoutingRegion getRegion() {
        return this.routingRegion;
    }

    public void setRoutingRegion(SipApplicationRoutingRegion routingRegion) {
        this.routingRegion = routingRegion;
    }

    @Override
    public URI getSubscriberURI() {
        return this.subscriberURI;
    }

    public void setSubscriberURI(URI subscriberURI) {
        this.subscriberURI = subscriberURI;
    }

    public void linkSipRequest(SipServletRequestImpl req) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipServletRequestImpl.class.getName(), "linkSipRequest");
        }
        this._b2bLinkedRequest = req;
    }

    public SipServletRequestImpl getLinkedRequest() {
        SipSessionImplementation ss = (SipSessionImplementation)this.getSession(false);
        if (ss == null || ss.getLinkedSession() == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getLinkedRequest", "Sessions are not linked, request is unlinked");
            }
            this._b2bLinkedRequest = null;
        }
        return this._b2bLinkedRequest;
    }

    @Override
    public Address getPoppedRoute() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._poppedRoute};
            c_logger.traceEntry((Object)SipServletRequestImpl.class.getName(), "getPoppedRoute", params);
        }
        return this._poppedRoute;
    }

    public void setPoppedRoute(Address route) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{route};
            c_logger.traceEntry((Object)SipServletRequestImpl.class.getName(), "setPoppedRoute", params);
        }
        this._poppedRoute = route;
        RequestImpl jReq = (RequestImpl)this.getRequest();
        if (!jReq.isLoopback()) {
            this._initialPoppedRoute = route;
        }
    }

    @Override
    public Address getInitialPoppedRoute() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._initialPoppedRoute};
            c_logger.traceEntry((Object)SipServletRequestImpl.class.getName(), "getInitialPoppedRoute", params);
        }
        return this._initialPoppedRoute;
    }

    @Override
    public Object getContent(Class[] classes) throws IOException, UnsupportedEncodingException {
        throw new UnsupportedOperationException("getContent: Not Done Yet");
    }

    @Override
    public SipApplicationRoutingDirective getRoutingDirective() throws IllegalStateException {
        if (!this.isInitial()) {
            throw new IllegalStateException("request is not initial");
        }
        return this.directive;
    }

    public boolean isExternalRoute() {
        return this.externalRoute;
    }

    public void setExternalRoute(boolean externalRoute) {
        this.externalRoute = externalRoute;
    }

    public void unLinkSipRequest() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipServletRequestImpl.class.getName(), "unLinkSipRequest");
        }
        this._b2bLinkedRequest = null;
    }

    public void imitateInitialForComposition() {
    }

    public void cleanInitialForComposition() {
    }

    public abstract void processCompositionErrorResponse();

    public abstract boolean isAppInvoked116Type();

    public abstract String getAppInvokedName();

    public abstract void setAppInvokedName(String var1);

    public boolean isCheckedTopRoute() {
        return this._checkedTopRoute;
    }

    public void setCheckedTopRoute(boolean topRoute) {
        this._checkedTopRoute = topRoute;
    }

    public SipServletRequestImpl getB2bLinkedRequest() {
        return this._b2bLinkedRequest;
    }

    public abstract void cleanExpiredCompositionHeaders();

    @Override
    public void setMaxForwards(int n) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Max-Forwards value out of range [" + n + ']');
        }
        try {
            Request request = this.getRequest();
            MaxForwardsHeader maxForwards = request.getMaxForwardsHeader();
            if (maxForwards == null) {
                maxForwards = this.getHeadersFactory().createMaxForwardsHeader(n);
                request.setMaxForwardsHeader(maxForwards);
            } else {
                maxForwards.setMaxForwards(n);
            }
        }
        catch (HeaderParseException e2) {
            this.logException(e2);
        }
        catch (SipParseException e3) {
            this.logException(e3);
        }
    }

    protected jain.protocol.ip.sip.address.URI createJainRequestURI(URI fromURI) throws IllegalArgumentException, SipParseException {
        jain.protocol.ip.sip.address.URI ruri = null;
        if (fromURI instanceof URIImpl) {
            ruri = (jain.protocol.ip.sip.address.URI)((URIImpl)fromURI).getJainURI().clone();
        } else {
            String uri = fromURI.toString();
            uri = uri.substring(uri.indexOf(58) + 1);
            ruri = this.getAddressFactory().createURI(fromURI.getScheme(), uri);
        }
        return ruri;
    }

    @Override
    public void setRequestURI(URI uri) {
        if (this.isCommitted()) {
            if (this.isJSR289Application()) {
                throw new IllegalStateException("Can not modify committed message");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setRequestURI", "Set Request URI Failed, Message already Committed");
            }
            return;
        }
        if (uri == null) {
            throw new NullPointerException("null URI");
        }
        if (this.m_requestURI == uri) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "setRequestUri", "same requestUri set");
            }
            return;
        }
        try {
            jain.protocol.ip.sip.address.URI reqURI = this.createJainRequestURI(uri);
            Request req = this.getRequest();
            req.setRequestURI(reqURI);
            c_logger.traceDebug("previous requestUri is cleared. New uri=" + uri + ", old uri=" + this.m_requestURI);
            this.m_requestURI = null;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "setRequestUri", this.m_requestURI);
            }
        }
        catch (IllegalArgumentException e2) {
            this.logException(e2);
        }
        catch (SipParseException e3) {
            this.logException(e3);
        }
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public boolean isUnmatchedReqeust() {
        return this.m_isUnmatchedReqeust;
    }

    public void setUnmatchedReqeust() {
        this.m_isUnmatchedReqeust = true;
    }
}

