/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router.tasks;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.router.tasks.RoutedTask;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TooManyHopsException;

public class EmulateProxyRoute
extends RoutedTask {
    private SipServletRequestImpl request = null;
    private static final LogMgr c_logger = Log.get(EmulateProxyRoute.class);

    public static EmulateProxyRoute getInstance(SipServletRequestImpl request) {
        return new EmulateProxyRoute(request);
    }

    public EmulateProxyRoute(SipServletRequestImpl request) {
        this.request = request;
        this.setForDispatching(false);
    }

    @Override
    protected void doTask() {
        block5: {
            try {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "doTask", "Sending to external route, request:" + this.request);
                }
                Proxy proxy = this.request.getProxy();
                proxy.setSupervised(false);
                proxy.proxyTo(this.request.getRequestURI());
            }
            catch (TooManyHopsException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.exception", "Create", null, (Throwable)((Object)e2));
                }
            }
            catch (IllegalStateException e3) {
                if (!c_logger.isErrorEnabled()) break block5;
                c_logger.error("error.exception", "Create", null, (Throwable)e3);
            }
        }
    }

    @Override
    public String getMethod() {
        return "External routing";
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        return this.request.getApplicationSession(false);
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        return this.request.getTransactionUser();
    }
}

