/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.taglib.GlobalTagLibraryCache;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.webcontainer.annotation.AnnotationHelperManager;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public abstract class AbstractJSPExtensionFactory
implements ExtensionFactory {
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.JSPExtensionFactory";
    private static final long NANOS_IN_A_MILLISECONDS = 1000000L;
    protected static GlobalTagLibraryCache globalTagLibraryCache = null;
    private static final Object lock = new Object();
    static final long serialVersionUID = -7519754761602947459L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractJSPExtensionFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.webcontainerext.AbstractJSPExtensionFactory", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.webcontainerext.AbstractJSPExtensionFactory", "<init>", this);
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExtensionProcessor createExtensionProcessor(IServletContext webapp) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "createExtensionProcessor", " app contextPath --> " + webapp.getContextPath());
        }
        AbstractJSPExtensionFactory.createGlobalTagLibraryCache();
        JspXmlExtConfig webAppConfig = this.createConfig(webapp);
        JspClassloaderContext jspClassloaderContext = this.createJspClassloaderContext(webapp, webAppConfig);
        ExtensionProcessor extensionProcessor = this.createProcessor(webapp, webAppConfig, jspClassloaderContext);
        AnnotationHelperManager aHM = new AnnotationHelperManager((ServletContext)webapp);
        AnnotationHelperManager.addInstance((ServletContext)webapp, (AnnotationHelperManager)aHM);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, "JSPExtensionFactory", "createExtensionProcessor", "Added AnnotationHelperManager of: " + aHM);
            logger.logp(Level.FINE, "JSPExtensionFactory", "createExtensionProcessor", "with IServletContext of: " + webapp);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "createExtensionProcessor", " app contextPath --> " + webapp.getContextPath());
        }
        return extensionProcessor;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List getPatternList() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getPatternList");
        }
        ArrayList<String> extensionsSupported = new ArrayList<String>();
        for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
            extensionsSupported.add(Constants.STANDARD_JSP_EXTENSIONS[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getPatternList");
        }
        return extensionsSupported;
    }

    protected abstract JspXmlExtConfig createConfig(IServletContext var1);

    protected abstract JspClassloaderContext createJspClassloaderContext(IServletContext var1, JspXmlExtConfig var2);

    protected abstract ExtensionProcessor createProcessor(IServletContext var1, JspXmlExtConfig var2, JspClassloaderContext var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void createGlobalTagLibraryCache() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.webcontainerext.AbstractJSPExtensionFactory", "createGlobalTagLibraryCache", new Object[0]);
        }
        Object object = lock;
        synchronized (object) {
            if (globalTagLibraryCache == null) {
                long start = System.nanoTime();
                globalTagLibraryCache = new GlobalTagLibraryCache();
                long end = System.nanoTime();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, "JSPExtensionFactory", "createGlobalTagLibraryCache", "GlobalTagLibraryCache created in " + (end - start) / 1000000L + " ms");
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.webcontainerext.AbstractJSPExtensionFactory", "createGlobalTagLibraryCache");
        }
    }
}

