/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.function.Function;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.eclipse.yasson.internal.model.Property;

public abstract class PropertyValuePropagation {
    private final Field field;
    private final Method getter;
    private final Method setter;
    private final PropertyVisibilityStrategy propertyVisibilityStrategy;
    private boolean writable;
    private boolean readable;
    private final boolean getterVisible;
    private final boolean setterVisible;

    protected PropertyValuePropagation(Property property, PropertyVisibilityStrategy strategy) {
        this.field = property.getField();
        this.getter = property.getGetter();
        this.setter = property.getSetter();
        this.propertyVisibilityStrategy = strategy;
        this.getterVisible = this.isMethodVisible(this.field, this.getter);
        this.setterVisible = this.isMethodVisible(this.field, this.setter);
        this.initReadable(this.field, this.getter);
        this.initWritable(this.field, this.setter);
    }

    private void initReadable(Field field, Method getter) {
        boolean fieldReadable;
        boolean bl = fieldReadable = field == null || (field.getModifiers() & 0x88) == 0;
        if (!fieldReadable) {
            this.readable = false;
            return;
        }
        if (getter != null && this.getterVisible) {
            this.acceptMethod(getter, OperationMode.GET);
            this.readable = true;
        } else if (this.isFieldVisible(field, getter)) {
            this.acceptField(field, OperationMode.GET);
            this.readable = true;
        }
    }

    private void initWritable(Field field, Method setter) {
        boolean fieldWritable;
        boolean bl = fieldWritable = field == null || (field.getModifiers() & 0x98) == 0;
        if (!fieldWritable) {
            this.writable = false;
            return;
        }
        if (setter != null && this.setterVisible && !setter.getDeclaringClass().isAnonymousClass()) {
            this.acceptMethod(setter, OperationMode.SET);
            this.writable = true;
        } else if (this.isFieldVisible(field, setter) && !field.getDeclaringClass().isAnonymousClass()) {
            this.acceptField(field, OperationMode.SET);
            this.writable = true;
        }
    }

    private boolean isFieldVisible(Field field, Method method) {
        if (field == null) {
            return false;
        }
        Boolean accessible = this.isVisible(strategy -> strategy.isVisible(field), field, method);
        if (accessible.booleanValue() && (!Modifier.isPublic(field.getModifiers()) || field.getDeclaringClass().isAnonymousClass() || this.isNotPublicAndNonNested(field.getDeclaringClass()))) {
            this.overrideAccessible(field);
        }
        return accessible;
    }

    private boolean isNotPublicAndNonNested(Class<?> declaringClass) {
        return !declaringClass.isMemberClass() && !Modifier.isPublic(declaringClass.getModifiers());
    }

    private boolean isMethodVisible(Field field, Method method) {
        if (method == null || Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Boolean accessible = this.isVisible(strategy -> strategy.isVisible(method), field, method);
        if (accessible.booleanValue() && (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().isAnonymousClass() || method.getDeclaringClass().isSynthetic())) {
            this.overrideAccessible(method);
        }
        return accessible;
    }

    private void overrideAccessible(AccessibleObject accessibleObject) {
        AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return null;
        });
    }

    private Boolean isVisible(Function<PropertyVisibilityStrategy, Boolean> visibilityCheckFunction, Field field, Method method) {
        return this.propertyVisibilityStrategy != null ? visibilityCheckFunction.apply(this.propertyVisibilityStrategy) : visibilityCheckFunction.apply(new DefaultVisibilityStrategy(field, method));
    }

    protected abstract void acceptMethod(Method var1, OperationMode var2);

    protected abstract void acceptField(Field var1, OperationMode var2);

    abstract void setValue(Object var1, Object var2);

    abstract Object getValue(Object var1);

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isGetterVisible() {
        return this.getterVisible;
    }

    public boolean isSetterVisible() {
        return this.setterVisible;
    }

    public static enum OperationMode {
        GET,
        SET;

    }

    private static final class DefaultVisibilityStrategy
    implements PropertyVisibilityStrategy {
        private final Field field;
        private final Method method;

        DefaultVisibilityStrategy(Field field, Method method) {
            this.field = field;
            this.method = method;
        }

        public boolean isVisible(Field field) {
            if (this.method != null && !this.isVisible(this.method)) {
                return false;
            }
            return Modifier.isPublic(field.getModifiers());
        }

        public boolean isVisible(Method method) {
            return Modifier.isPublic(method.getModifiers());
        }
    }
}

