/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;

public final class ObjectUtils {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    private ObjectUtils() {
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return object != null ? object : defaultValue;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ObjectUtils.isEmpty(array);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean arrayContains(Object[] array, Object objectToFind) {
        if (array == null) {
            return false;
        }
        for (Object o : array) {
            if (!o.equals(objectToFind)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] arrayAdd(T[] array, T objectToAdd) {
        if (array != null) {
            Class<?> type = array.getClass().getComponentType();
        } else if (objectToAdd != null) {
            Class<?> type = objectToAdd.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        int arrayLength = Array.getLength(array);
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        newArray[newArray.length - 1] = objectToAdd;
        return newArray;
    }
}

