/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.pkce;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.pkce.ProofKeyForCodeExchange;
import com.ibm.ws.security.oauth20.pkce.ProofKeyForCodeExchangeMethod;
import com.ibm.ws.security.openidconnect.pkce.ProofKeyForCodeExchangeCache;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequestParameters;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProofKeyForCodeExchangeHelper {
    private static final TraceComponent tc = Tr.register(ProofKeyForCodeExchangeHelper.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    static final long serialVersionUID = 6520301409452156644L;

    public void generateAndAddPkceParametersToAuthzRequest(String codeChallengeMethod, String state, AuthorizationRequestParameters parameters) {
        ProofKeyForCodeExchangeMethod pkceMethod = ProofKeyForCodeExchangeMethod.getInstance((String)codeChallengeMethod);
        if (pkceMethod == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find a PKCE method class for challenge method [" + codeChallengeMethod + "]"), (Object[])new Object[0]);
            }
            return;
        }
        String codeVerifier = this.getAndCacheCodeVerifier(state);
        String codeChallenge = pkceMethod.generateCodeChallenge(codeVerifier);
        parameters.addParameter("code_challenge", codeChallenge);
        parameters.addParameter("code_challenge_method", codeChallengeMethod);
    }

    public String getAndCacheCodeVerifier(String state) {
        String codeVerifier = ProofKeyForCodeExchange.generateCodeVerifier();
        ProofKeyForCodeExchangeCache.cacheCodeVerifier(state, codeVerifier);
        return codeVerifier;
    }

    public HashMap<String, String> addCodeVerifierToTokenRequestParameters(String state, HashMap<String, String> parameters) {
        String codeVerifier = ProofKeyForCodeExchangeCache.getCachedCodeVerifier(state);
        parameters.put("code_verifier", codeVerifier);
        return parameters;
    }
}

