/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.health.internal.HealthCheckHttpResponseBuilder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.Optional;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.health.HealthCheckResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheck20HttpResponseBuilder
extends HealthCheckHttpResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheck20HttpResponseBuilder.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    static final long serialVersionUID = -4205360218818748105L;

    @Override
    public void setHttpResponse(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "application/json; charset=UTF-8");
        JsonObjectBuilder payload = jsonBuilderFactory.createObjectBuilder();
        httpResponse.setStatus(this.overallState == HealthCheckResponse.State.UP ? 200 : 503);
        payload.add("status", this.overallState.name());
        payload.add("checks", this.checks);
        this.setJSONPayload(payload.build(), httpResponse);
    }

    @Override
    protected void setChecks(HealthCheckResponse response) {
        Optional dataMap;
        JsonObjectBuilder check = jsonBuilderFactory.createObjectBuilder();
        check.add("name", response.getName());
        HealthCheckResponse.State checkState = response.getState();
        check.add("status", checkState == null ? null : checkState.name());
        if (checkState != null) {
            if (checkState.equals((Object)HealthCheckResponse.State.DOWN)) {
                this.overallState = HealthCheckResponse.State.DOWN;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setChecks(): checkState is null", (Object[])new Object[0]);
            }
            this.overallState = HealthCheckResponse.State.DOWN;
        }
        if ((dataMap = response.getData()) != null && dataMap.isPresent()) {
            JsonObjectBuilder data = jsonBuilderFactory.createObjectBuilder();
            for (Map.Entry entry : ((Map)dataMap.get()).entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    data.add((String)entry.getKey(), JsonValue.NULL);
                    continue;
                }
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
                    continue;
                }
                data.add((String)entry.getKey(), ((Long)value).longValue());
            }
            check.add("data", (JsonValue)data.build());
        }
        this.checks.add(check);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setChecks(): checks = " + this.checks), (Object[])new Object[0]);
        }
    }
}

