/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/fileTransfer/router/{filePath}"})
public class FileTransferRouterHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(FileTransferRouterHandler.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    private final String KEY_FILE_TRANSFER_HELPER = "fileTransferHelper";
    private transient FileTransferHelper fileTransferHelper;
    private final AtomicServiceReference<FileTransferHelper> fileTransferHelperRef = new AtomicServiceReference("fileTransferHelper");
    static final long serialVersionUID = 7392389307956912504L;

    @Activate
    protected void activate(ComponentContext context) {
        this.fileTransferHelperRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.fileTransferHelperRef.deactivate(context);
    }

    @Reference(name="fileTransferHelper", service=FileTransferHelper.class)
    protected void setFileTransferHelperRef(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.setReference(ref);
    }

    protected void unsetFileTransferHelperRef(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.unsetReference(ref);
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (RESTHelper.isGetMethod(method)) {
            this.routedDownload(request, response);
        } else if (RESTHelper.isPostMethod(method)) {
            this.routedUpload(request, response);
        } else if (RESTHelper.isDeleteMethod(method)) {
            this.routedDelete(request, response);
        } else {
            throw new RESTHandlerMethodNotAllowedError("GET,POST,DELETE");
        }
    }

    private void routedDownload(RESTRequest request, RESTResponse response) {
        String filePath = RESTHelper.getRequiredParam(request, "filePath");
        FileTransferHelper helper = this.getFileTransferHelper();
        helper.routedDownloadInternal(request, response, filePath, true);
        response.setStatus(204);
    }

    private void routedUpload(RESTRequest request, RESTResponse response) {
        String filePath = RESTHelper.getRequiredParam(request, "filePath");
        String expand = RESTHelper.getQueryParam(request, "expandOnCompletion");
        boolean expansion = expand != null && "true".compareToIgnoreCase(expand) == 0;
        FileTransferHelper helper = this.getFileTransferHelper();
        helper.routedUploadInternal(request, filePath, expansion, true);
        response.setStatus(204);
    }

    private void routedDelete(RESTRequest request, RESTResponse response) {
        String filePath = RESTHelper.getRequiredParam(request, "filePath");
        FileTransferHelper helper = this.getFileTransferHelper();
        helper.routedDeleteInternal(request, filePath, false);
        response.setStatus(204);
    }

    private synchronized FileTransferHelper getFileTransferHelper() {
        if (this.fileTransferHelper == null) {
            FileTransferHelper fileTransferHelper = this.fileTransferHelper = this.fileTransferHelperRef != null ? (FileTransferHelper)this.fileTransferHelperRef.getService() : null;
            if (this.fileTransferHelper == null) {
                IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"FileTransferHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
                throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
            }
        }
        return this.fileTransferHelper;
    }
}

