/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestUtils
extends com.ibm.wsspi.webcontainer.util.RequestUtils {
    private static final String SYSTEM_CLIENT_ENCODING;
    private static final String SYSTEM_FILE_ENCODING;
    public static final String SYS_PROP_FILE_ENCODING = "file.encoding";
    public static final String SYS_PROP_DFLT_CLIENT_ENCODING = "default.client.encoding";
    private static final TraceNLS nls;
    private static final Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.RequestUtils";
    public static final String ACCEPT_CHARSET_HEADER = "Accept-Charset";
    public static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    public static final String DEFAULT_CLIENT_ENCODING = "iso-8859-1";
    public static final String HEADER_SEPARATOR = ",";
    public static final String LANG_CHINESE_S = "zh-cn";
    public static final String LANG_CHINESE = "zh";
    public static final String LANG_CHINESE_T = "zh-tw";
    public static final String LANG_EN = "en";
    public static final String LANG_KOREA = "ko";
    public static final String LANG_JAPAN1 = "ja";
    public static final String LANG_JAPAN2 = "jp";
    public static final String ENC_CHINESE_S = "Cp1381";
    public static final String ENC_CHINESE_T = "Cp950";
    public static final String ENC_ENGLISH = "iso-8859-1";
    public static final String ENC_KOREA = "KSC5601";
    public static final String ENC_JAPAN = "Shift_JIS";
    private static final String SHORT_ASCII = "8859";
    private static final String ACCEPT_ALL_VAL = "*";
    private static final String CP1047_ENCODING = "Cp1047";
    private static final String ISO8859_1_ENCODING = "8859_1";
    private static final String CP939_ENCODING = "Cp939";
    private static final String SJIS_ENCODING = "SJIS";
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public static String getClientEncoding(HttpServletRequest req) {
        String encoding = null;
        if (SYSTEM_CLIENT_ENCODING != null) {
            encoding = SYSTEM_CLIENT_ENCODING;
            return encoding;
        }
        String header = ISRTServletRequest.getHeader(req, HttpHeaderKeys.HDR_ACCEPT_CHARSET);
        if (header != null) {
            if (header.indexOf(SHORT_ASCII) != -1) {
                encoding = RequestUtils.getLanguage(req);
            } else {
                StringTokenizer st = new StringTokenizer(header, HEADER_SEPARATOR);
                encoding = st.nextToken().trim();
                if (encoding.equals(ACCEPT_ALL_VAL)) {
                    encoding = "iso-8859-1";
                }
                if (!EncodingUtils.isCharsetSupported(encoding)) {
                    encoding = RequestUtils.getLanguage(req);
                }
            }
        } else {
            encoding = RequestUtils.getLanguage(req);
        }
        return encoding;
    }

    public static String getEbcdicEncodingIfZos() {
        String osName = System.getProperty("os.name");
        String encoding = null;
        if (osName.equalsIgnoreCase("z/OS") || osName.equalsIgnoreCase("OS/390")) {
            String lang = Locale.getDefault().getLanguage();
            if (lang.startsWith(LANG_EN)) {
                encoding = CP1047_ENCODING;
            } else if (lang.equals(LANG_JAPAN1) || lang.equals(LANG_JAPAN2)) {
                encoding = SJIS_ENCODING;
            }
        }
        return encoding;
    }

    public static String getEncodingFromLanguage(String lang) {
        if (lang.startsWith(LANG_EN)) {
            return "iso-8859-1";
        }
        if (lang.equals(LANG_JAPAN1) || lang.equals(LANG_JAPAN2)) {
            return ENC_JAPAN;
        }
        if (lang.equals(LANG_CHINESE_T)) {
            return ENC_CHINESE_T;
        }
        if (lang.equals(LANG_KOREA)) {
            return ENC_KOREA;
        }
        if (lang.equals(LANG_CHINESE_S) || lang.equals(LANG_CHINESE)) {
            return ENC_CHINESE_S;
        }
        return "iso-8859-1";
    }

    public static String getLanguage(HttpServletRequest req) {
        String encoding = null;
        String header = ISRTServletRequest.getHeader(req, HttpHeaderKeys.HDR_ACCEPT_LANGUAGE);
        if (header != null) {
            StringTokenizer st = new StringTokenizer(header, HEADER_SEPARATOR);
            String lang = st.nextToken().trim().toLowerCase();
            encoding = RequestUtils.getEncodingFromLanguage(lang);
        } else {
            encoding = SYSTEM_FILE_ENCODING != null ? (SYSTEM_FILE_ENCODING.equals(CP1047_ENCODING) ? ISO8859_1_ENCODING : (SYSTEM_FILE_ENCODING.equals(CP939_ENCODING) ? SJIS_ENCODING : "iso-8859-1")) : "iso-8859-1";
        }
        if (!EncodingUtils.isCharsetSupported(encoding)) {
            encoding = SYSTEM_FILE_ENCODING == null ? "iso-8859-1" : SYSTEM_FILE_ENCODING;
        }
        return encoding;
    }

    private static String getPostBody(int len, ServletInputStream in, String encoding) throws IOException {
        String postedBody;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPostBody", "len = " + len, ", encoding = " + encoding);
        }
        byte[] postedBytes = null;
        if (len <= 0) {
            return null;
        }
        if (in == null) {
            throw new IllegalArgumentException("post data inputstream is null");
        }
        try {
            int inputLen;
            postedBytes = new byte[len];
            int offset = 0;
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) <= 0) {
                    String msg = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                    throw new IOException(msg);
                }
                logger.logp(Level.FINE, CLASS_NAME, "getPostBody", "read of " + inputLen + " bytes.");
            } while (len - (offset += inputLen) > 0);
        }
        catch (IOException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "398");
            throw e;
        }
        try {
            postedBody = new String(postedBytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "411");
            postedBody = new String(postedBytes);
        }
        return postedBody;
    }

    public static Hashtable parsePostData(int len, ServletInputStream in, String encoding, boolean multireadPropertyEnabled) throws IOException {
        String postedBody = RequestUtils.getPostBody(len, in, encoding);
        if (multireadPropertyEnabled) {
            in.close();
        }
        return RequestUtils.parseQueryString(postedBody, encoding);
    }

    public static Hashtable parsePostDataLong(long len, ServletInputStream in, String encoding, boolean multireadPropertyEnabled) throws IOException {
        int MaxBufferSize;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parsePostDataLong", "len = " + len, ", encoding = " + encoding);
        }
        if (len <= (long)(MaxBufferSize = WCCustomProperties.SERVLET31_PRIVATE_BUFFERSIZE_FOR_LARGE_POST_DATA)) {
            return RequestUtils.parsePostData((int)len, in, encoding, multireadPropertyEnabled);
        }
        long remaining = len;
        long arraySize = len / (long)MaxBufferSize;
        if (len % (long)MaxBufferSize > 0L) {
            ++arraySize;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parsePostDataLong", "buffer size in use = " + MaxBufferSize + ", arraySize required = " + Long.toString(arraySize));
        }
        if (arraySize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        char[][] paramData = new char[(int)arraySize][];
        int readLen = MaxBufferSize;
        String data = null;
        int index = 0;
        while (remaining > 0L) {
            readLen = remaining > (long)MaxBufferSize ? MaxBufferSize : (int)remaining;
            data = RequestUtils.getPostBody(readLen, in, encoding);
            paramData[index] = data.toCharArray();
            ++index;
            remaining -= (long)readLen;
        }
        if (multireadPropertyEnabled) {
            in.close();
        }
        return RequestUtils.parseQueryString(paramData, encoding);
    }

    public static Hashtable parsePostData(ServletInputStream in, String encoding, boolean multireadPropertyEnabled) throws IOException {
        String postedBody;
        byte[] postedBytes = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parsePostData", "parsing chunked post data. encoding = " + encoding);
        }
        if (in == null) {
            throw new IllegalArgumentException("post data inputstream is null");
        }
        try {
            int inputLen;
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream(2048);
            do {
                byte[] readInBytes;
                if ((inputLen = in.read(readInBytes = new byte[2048], 0, 2048)) <= 0) continue;
                byteOS.write(readInBytes, 0, inputLen);
            } while (inputLen != -1);
            if (multireadPropertyEnabled) {
                in.close();
            }
            postedBytes = byteOS.toByteArray();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "parsePostData", "finished reading [" + postedBytes.length + "] bytes");
            }
        }
        catch (IOException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "598");
            throw e;
        }
        try {
            postedBody = new String(postedBytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", "618");
            postedBody = new String(postedBytes);
        }
        if (WCCustomProperties.PARSE_UTF8_POST_DATA && encoding.equalsIgnoreCase("UTF-8")) {
            for (byte nextByte : postedBytes) {
                if (nextByte >= 0) continue;
                encoding = ISO8859_1_ENCODING;
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break;
                logger.logp(Level.FINE, CLASS_NAME, "parsePostData", "UTF8 post data, set encoing to 8859_1 to prevent futrther encoding");
                break;
            }
        }
        return RequestUtils.parseQueryString(postedBody, encoding);
    }

    static {
        nls = TraceNLS.getTraceNLS(RequestUtils.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
        logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
        SYSTEM_FILE_ENCODING = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(RequestUtils.SYS_PROP_FILE_ENCODING);
            }
        });
        SYSTEM_CLIENT_ENCODING = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(RequestUtils.SYS_PROP_DFLT_CLIENT_ENCODING);
            }
        });
    }
}

