/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.XidAlreadyKnownException;
import com.ibm.ws.sib.msgstore.XidStillAssociatedException;
import com.ibm.ws.sib.msgstore.XidUnknownException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionParticipant;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.msgstore.transactions.impl.XidParticipant;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class XidManager {
    private static TraceComponent tc = SibTr.register(XidManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Vector<PersistentTranId> _indoubtXids = new Vector();
    private Hashtable<PersistentTranId, TransactionParticipant> _associatedTrans = new Hashtable();
    private Hashtable<PersistentTranId, TransactionParticipant> _unassociatedTrans = new Hashtable();
    private Hashtable<PersistentTranId, TransactionParticipant> _suspendedTrans = new Hashtable();
    private final AssociationLock _associationLock = new AssociationLock();
    private MessageStoreImpl _ms;
    private PersistenceManager _persistence;
    private int _localTranIdCounter = 0;

    public XidManager(MessageStoreImpl ms) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("MessageStore=" + (Object)((Object)ms)));
        }
        this._ms = ms;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionParticipant start(PersistentTranId ptid, int flags) throws XidUnknownException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{"PersistentTranId=" + ptid, this.xaFlagsToString(flags)});
        }
        TransactionParticipant retval = null;
        if ((flags & 0x200000) != 0) {
            retval = this._associatedTrans.get(ptid);
            if (retval == null) {
                XidUnknownException xue = new XidUnknownException("XID_NOT_RECOGNISED_SIMS1007", new Object[]{"start(XID,TMJOIN)", ptid.toTMString()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot JOIN with this Xid. It has not previously been started!", (Object)((Object)xue));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
                }
                throw xue;
            }
        } else if ((flags & 0x8000000) != 0) {
            AssociationLock associationLock = this._associationLock;
            synchronized (associationLock) {
                retval = this._suspendedTrans.remove(ptid);
                if (retval == null) {
                    XidUnknownException xue = new XidUnknownException("XID_NOT_RECOGNISED_SIMS1007", new Object[]{"start(XID,TMRESUME)", ptid.toTMString()});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot RESUME this Xid. It has not previously been SUSPENDED!", (Object)((Object)xue));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
                    }
                    throw xue;
                }
                this._associatedTrans.put(ptid, retval);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)("return=" + retval));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(PersistentTranId ptid, TransactionParticipant participant) throws XidAlreadyKnownException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{"PersistentTranId=" + ptid, "Participant=" + participant});
        }
        AssociationLock associationLock = this._associationLock;
        synchronized (associationLock) {
            if (this._associatedTrans.containsKey(ptid) || this._unassociatedTrans.containsKey(ptid) || this._suspendedTrans.containsKey(ptid)) {
                XidAlreadyKnownException xake = new XidAlreadyKnownException("XID_ALREADY_ASSOCIATED_SIMS1009", new Object[]{"start(XID,TMNOFLAGS)", ptid.toTMString()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot start new association with this Xid. It is already known!", (Object)((Object)xake));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
                }
                throw xake;
            }
            this._associatedTrans.put(ptid, participant);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(PersistentTranId ptid, int flags) throws XidUnknownException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object)new Object[]{"PersistentTranId=" + ptid, this.xaFlagsToString(flags)});
        }
        AssociationLock associationLock = this._associationLock;
        synchronized (associationLock) {
            TransactionParticipant tran = this._associatedTrans.remove(ptid);
            if (tran != null) {
                if ((flags & 0x2000000) != 0) {
                    this._suspendedTrans.put(ptid, tran);
                } else {
                    this._unassociatedTrans.put(ptid, tran);
                }
            } else if (this._suspendedTrans.containsKey(ptid)) {
                if ((flags & 0x4000000) != 0 || (flags & 0x20000000) != 0) {
                    tran = this._suspendedTrans.remove(ptid);
                    this._unassociatedTrans.put(ptid, tran);
                }
            } else if (!this._unassociatedTrans.containsKey(ptid)) {
                XidUnknownException xue = new XidUnknownException("XID_NOT_RECOGNISED_SIMS1007", new Object[]{"end(XID)", ptid.toTMString()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot disassociate from this Xid. It is not currently associated!", (Object)((Object)xue));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"end");
                }
                throw xue;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(PersistentTranId ptid) throws XidUnknownException, XidStillAssociatedException, ProtocolException, RollbackException, SeverePersistenceException, TransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object)("PersistentTranId=" + ptid));
        }
        if (this._associatedTrans.containsKey(ptid)) {
            XidStillAssociatedException xsae = new XidStillAssociatedException("XID_STILL_ASSOCIATED_SIMS1008", new Object[]{"prepare(XID)", ptid.toTMString()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Xid is still associated. Needs to be disassociated before completion!", (Object)((Object)xsae));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            throw xsae;
        }
        int retval = 0;
        TransactionParticipant participant = this._unassociatedTrans.get(ptid);
        if (participant != null) {
            try {
                retval = participant.prepare();
                this._indoubtXids.add(ptid);
            }
            catch (RollbackException rbe) {
                FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.ws.sib.msgstore.transactions.XidManager.prepare", (String)"1:304:1.62");
                AssociationLock associationLock = this._associationLock;
                synchronized (associationLock) {
                    participant = this._unassociatedTrans.remove(ptid);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Participant removed from XidManager due to RollbackException: " + participant));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"RollbackException caught during prepare phase of transaction!", (Object)((Object)rbe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
                }
                throw rbe;
            }
        }
        XidUnknownException xue = new XidUnknownException("XID_NOT_RECOGNISED_SIMS1007", new Object[]{"prepare(XID)", ptid.toTMString()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot prepare transaction branch, Xid is unknown!", (Object)((Object)xue));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
        }
        throw xue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)("return=" + retval));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void commit(PersistentTranId ptid, boolean onePhase) throws XidUnknownException, XidStillAssociatedException, ProtocolException, RollbackException, SeverePersistenceException, PersistenceException, TransactionException {
        if (TraceComponent.isAnyTracingEnabled() && XidManager.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)XidManager.tc, (String)"commit", (Object)("onePhase=" + onePhase + ", PersistentTranId=" + ptid));
        }
        if (this._associatedTrans.containsKey(ptid)) {
            xsae = new XidStillAssociatedException("XID_STILL_ASSOCIATED_SIMS1008", new Object[]{"commit(XID)", ptid.toTMString()});
            if (TraceComponent.isAnyTracingEnabled() && XidManager.tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)XidManager.tc, (String)"Xid is still associated. Needs to be disassociated before completion!", (Object)xsae);
            }
            if (TraceComponent.isAnyTracingEnabled() && XidManager.tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XidManager.tc, (String)"commit");
            }
            throw xsae;
        }
        participant = this._unassociatedTrans.get(ptid);
        if (participant != null) {
            xidCompleted = false;
            try {
                participant.commit(onePhase);
                xidCompleted = true;
                if (onePhase) ** GOTO lbl40
                this._indoubtXids.remove(ptid);
            }
            catch (RollbackException rbe) {
                xidCompleted = true;
                throw rbe;
            }
            finally {
                if (xidCompleted) {
                    var8_11 = this._associationLock;
                    synchronized (var8_11) {
                        this._unassociatedTrans.remove(ptid);
                    }
                }
            }
        } else {
            xue = new XidUnknownException("XID_NOT_RECOGNISED_SIMS1007", new Object[]{"commit(XID)", ptid.toTMString()});
            if (TraceComponent.isAnyTracingEnabled() && XidManager.tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)XidManager.tc, (String)"Cannot commit transaction branch, Xid is unknown!", (Object)xue);
            }
            if (TraceComponent.isAnyTracingEnabled() && XidManager.tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XidManager.tc, (String)"commit");
            }
            throw xue;
        }
lbl40:
        // 2 sources

        if (TraceComponent.isAnyTracingEnabled() && XidManager.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)XidManager.tc, (String)"commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(PersistentTranId ptid) throws XidUnknownException, XidStillAssociatedException, ProtocolException, SeverePersistenceException, PersistenceException, TransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object)("PersistentTranId=" + ptid));
        }
        if (this._associatedTrans.containsKey(ptid)) {
            XidStillAssociatedException xsae = new XidStillAssociatedException("XID_STILL_ASSOCIATED_SIMS1008", new Object[]{"rollback(XID)", ptid.toTMString()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Xid is still associated. Needs to be disassociated before completion!", (Object)((Object)xsae));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            throw xsae;
        }
        TransactionParticipant participant = this._unassociatedTrans.get(ptid);
        if (participant != null) {
            participant.rollback();
            this._indoubtXids.remove(ptid);
            AssociationLock associationLock = this._associationLock;
            synchronized (associationLock) {
                this._unassociatedTrans.remove(ptid);
            }
        } else {
            XidUnknownException xue = new XidUnknownException("XID_NOT_RECOGNISED_SIMS1007", new Object[]{"rollback(XID)", ptid.toTMString()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot rollback transaction branch, Xid is unknown!", (Object)((Object)xue));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            throw xue;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(PersistentMessageStore PM) throws TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restart", (Object)("PersistenceManager=" + PM));
        }
        if (PM != null) {
            if (!(PM instanceof PersistenceManager)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"No PersistenceManager provided at startup. MessageStore cannot continue!");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"restart");
                }
                throw new SevereMessageStoreException("UNRECOVERABLE_ERROR_SIMS1499", new Object[0]);
            }
            this._persistence = (PersistenceManager)((Object)PM);
            try {
                List list = PM.readIndoubtXIDs();
                for (PersistentTranId ptid : list) {
                    this._indoubtXids.add(ptid);
                    AssociationLock associationLock = this._associationLock;
                    synchronized (associationLock) {
                        this._unassociatedTrans.put(ptid, new XidParticipant(this._ms, ptid, this._persistence, 0, TransactionState.STATE_PREPARED));
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Indoubt Transaction Re-instated from database: " + ptid));
                }
            }
            catch (PersistenceException pe) {
                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.transactions.XidManager.restart", (String)"1:516:1.62");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Persistence exception caught reading indoubt transactions from database!", (Object)((Object)pe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"restart");
                }
                throw new TransactionException("UNEXPECTED_EXCEPTION_SIMS1099", new Object[]{pe}, (Throwable)pe);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.event((Object)this, (TraceComponent)tc, (String)"PersistenceManager is null. MessageStore cannot continue!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restart");
        }
        throw new SevereMessageStoreException("UNRECOVERABLE_ERROR_SIMS1499", new Object[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restart");
        }
    }

    public Xid[] recover() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"recover");
        }
        Object[] xids = new Xid[this._indoubtXids.size()];
        this._indoubtXids.toArray(xids);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)("return=" + Arrays.toString(xids) + ", size=" + xids.length));
        }
        return xids;
    }

    public PersistentTransaction getTransactionFromTranId(PersistentTranId ptid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionFromTranId", (Object)("TranId=" + ptid));
        }
        PersistentTransaction retval = this._unassociatedTrans.get(ptid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionFromTranId", (Object)("return=" + retval));
        }
        return retval;
    }

    public boolean isTranIdKnown(PersistentTranId ptid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isTranIdKnown", (Object)("PersistentTranId=" + ptid));
        }
        boolean retval = false;
        if (this._associatedTrans.containsKey(ptid) || this._unassociatedTrans.containsKey(ptid)) {
            retval = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isTranIdKnown", (Object)("return=" + retval));
        }
        return retval;
    }

    public Xid[] listRemoteInDoubts() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"listRemoteInDoubts");
        }
        Vector xids = (Vector)this._indoubtXids.clone();
        Xid[] retval = null;
        if (xids.size() > 0) {
            retval = new Xid[xids.size()];
            xids.toArray(retval);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"There are currently no in-doubt transaction branches within the ME.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"listRemoteInDoubts", (Object)("return=" + retval));
        }
        return retval;
    }

    public String toXmlString() {
        TransactionParticipant tran;
        StringBuffer retval = new StringBuffer();
        retval.append("<transaction-management>\n");
        retval.append("<associated-transactions>\n");
        Enumeration<TransactionParticipant> enumeration = this._associatedTrans.elements();
        while (enumeration.hasMoreElements()) {
            tran = enumeration.nextElement();
            retval.append(tran.toXmlString());
        }
        retval.append("</associated-transactions>\n");
        retval.append("<unassociated-transactions>\n");
        enumeration = this._unassociatedTrans.elements();
        while (enumeration.hasMoreElements()) {
            tran = enumeration.nextElement();
            retval.append(tran.toXmlString());
        }
        retval.append("</unassociated-transactions>\n");
        retval.append("<suspended-transactions>\n");
        enumeration = this._suspendedTrans.elements();
        while (enumeration.hasMoreElements()) {
            tran = enumeration.nextElement();
            retval.append(tran.toXmlString());
        }
        retval.append("</suspended-transactions>\n");
        retval.append("<indoubt-transaction-ids>\n");
        for (PersistentTranId xid : this._indoubtXids) {
            retval.append("<xid>");
            retval.append(xid.toString());
            retval.append("</xid>\n");
        }
        retval.append("</indoubt-transaction-ids>\n");
        retval.append("</transaction-management>\n");
        return retval.toString();
    }

    public synchronized int generateLocalTranId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"generateLocalTranId");
        }
        int retval = this._localTranIdCounter++;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"generateLocalTranId", (Object)("return=" + retval));
        }
        return retval;
    }

    public String xaFlagsToString(int flags) {
        StringBuilder retval = new StringBuilder("Flags=");
        retval.append(Integer.toHexString(flags));
        retval.append("( ");
        if (flags == 0) {
            retval.append("TMNOFLAGS ");
        } else {
            if ((flags & 0x800000) != 0) {
                retval.append("TMENDRSCAN ");
            }
            if ((flags & 0x20000000) != 0) {
                retval.append("TMFAIL ");
            }
            if ((flags & 0x200000) != 0) {
                retval.append("TMJOIN ");
            }
            if ((flags & 0x40000000) != 0) {
                retval.append("TMONEPHASE ");
            }
            if ((flags & 0x8000000) != 0) {
                retval.append("TMRESUME ");
            }
            if ((flags & 0x1000000) != 0) {
                retval.append("TMSTARTRSCAN ");
            }
            if ((flags & 0x4000000) != 0) {
                retval.append("TMSUCCESS ");
            }
            if ((flags & 0x2000000) != 0) {
                retval.append("TMSUSPEND ");
            }
        }
        retval.append(")");
        return retval.toString();
    }

    private static final class AssociationLock {
        private AssociationLock() {
        }
    }
}

