/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs21.providers.json;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.spi.JsonProvider;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JsonPProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final TraceComponent tc = Tr.register(JsonPProvider.class, null, null);
    JsonProvider jsonProvider;
    static final long serialVersionUID = -6498096711519205475L;

    @FFDCIgnore(value={Throwable.class})
    public JsonPProvider(JsonProvider jsonProvider) {
        block4: {
            this.jsonProvider = null;
            if (jsonProvider != null) {
                this.jsonProvider = jsonProvider;
            } else {
                try {
                    this.jsonProvider = JsonProvider.provider();
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Unable to find a valid JSON-P provider implemenation", (Object[])new Object[]{t});
                }
            }
        }
    }

    public long getSize(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(type) || JsonArray.class.isAssignableFrom(type) || JsonObject.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream == null) {
            throw new IOException("Initialized OutputStream should be provided");
        }
        JsonWriter writer = null;
        writer = this.jsonProvider.createWriter(entityStream);
        if (writer != null) {
            writer.write((JsonStructure)obj);
        }
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs21.providers.json.JsonPProvider", (String)"97", (Object)this, (Object[])new Object[]{obj, type, genericType, annotations, mediaType, httpHeaders, entityStream});
        }
        return;
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs21.providers.json.JsonPProvider", (String)"91", (Object)this, (Object[])new Object[]{obj, type, genericType, annotations, mediaType, httpHeaders, entityStream});
                if (writer == null) return;
            }
            catch (Throwable throwable2) {
                if (writer == null) throw throwable2;
                try {
                    writer.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.jaxrs21.providers.json.JsonPProvider", (String)"97", (Object)this, (Object[])new Object[]{obj, type, genericType, annotations, mediaType, httpHeaders, entityStream});
                }
                throw throwable2;
            }
            try {
                writer.close();
                return;
            }
            catch (Throwable throwable4) {
                FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.jaxrs21.providers.json.JsonPProvider", (String)"97", (Object)this, (Object[])new Object[]{obj, type, genericType, annotations, mediaType, httpHeaders, entityStream});
            }
            return;
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(type) || JsonArray.class.isAssignableFrom(type) || JsonObject.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Throwable.class})
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream == null) {
            throw new IOException("Initialized InputStream should be provided");
        }
        JsonReader reader = null;
        try {
            reader = this.jsonProvider.createReader(entityStream);
            if (reader != null) {
                JsonStructure jsonStructure = reader.read();
                return jsonStructure;
            }
        }
        catch (Throwable e) {
            if (JsonException.class.isAssignableFrom(e.getClass())) {
                throw ExceptionUtils.toBadRequestException(e, null);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }
}

