/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.StatefulSessionActivationStrategy;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileBeanStore
implements SessionBeanStore {
    private static final TraceComponent tc = Tr.register(FileBeanStore.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = FileBeanStore.class.getName();
    private static final String FILENAME_PREFIX = "BeanId_";
    private String passivationDir;
    private String serverName;
    private String clusterName;

    public FileBeanStore(String passivationDir) {
        this(passivationDir, null, null);
    }

    public FileBeanStore(String passivationDir, String serverName, String clusterName) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{passivationDir, serverName, clusterName});
        }
        if (passivationDir != null && new File(passivationDir).isDirectory()) {
            this.passivationDir = passivationDir;
        } else {
            this.passivationDir = null;
            if (passivationDir != null) {
                Tr.warning((TraceComponent)tc, (String)"PASSIVATION_DIRECTORY_DOES_NOT_EXIST_CNTR0023W", (Object[])new Object[]{passivationDir});
            }
        }
        this.serverName = serverName;
        this.clusterName = clusterName;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void removeAll() {
        FileBeanFilter theFilter;
        File[] files;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAll", (Object[])new Object[0]);
        }
        if ((files = new File(this.passivationDir == null ? "." : this.passivationDir).listFiles(theFilter = new FileBeanFilter())) != null) {
            for (File file : files) {
                String name = file.getName();
                if (name.startsWith(FILENAME_PREFIX)) {
                    if (file.delete()) {
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("deleted " + name), (Object[])new Object[0]);
                        continue;
                    }
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("failed to delete " + name), (Object[])new Object[0]);
                    continue;
                }
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("skipping " + name), (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAll");
        }
    }

    private File getStatefulBeanFile(String fileNamePrefix, boolean checkAll) {
        File statefulBeanFile = null;
        if (this.clusterName != null) {
            statefulBeanFile = new File(this.passivationDir, fileNamePrefix + this.clusterName);
            if (checkAll && statefulBeanFile.exists()) {
                return statefulBeanFile;
            }
        }
        statefulBeanFile = new File(this.passivationDir, fileNamePrefix + this.serverName);
        if (checkAll && statefulBeanFile.exists()) {
            return statefulBeanFile;
        }
        return new File(this.passivationDir, fileNamePrefix);
    }

    @Override
    public GZIPInputStream getGZIPInputStream(BeanId beanId) throws CSIException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGZIPInputStream", (Object[])new Object[]{beanId});
        }
        final String fileName = this.getPortableFilename(beanId);
        GZIPInputStream result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<GZIPInputStream>(){

                @Override
                public GZIPInputStream run() throws FileNotFoundException, IOException {
                    File statefulBeanFile = FileBeanStore.this.getStatefulBeanFile(fileName, true);
                    FileInputStream fis = new FileInputStream(statefulBeanFile);
                    return new GZIPInputStream(fis);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception ex2 = ex.getException();
            if (ex2 instanceof FileNotFoundException) {
                FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".getGZIPInputStream"), (String)"91", (Object)this);
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No file found while trying to activate passivated stateful session bean", (Object[])new Object[]{fileName});
                }
                throw new StreamUnavailableException("");
            }
            if (ex2 instanceof IOException) {
                FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".getGZIPInputStream"), (String)"98", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_READING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0024W", (Object[])new Object[]{fileName, this, ex2});
                throw new CSIException("IOException reading input stream for stateful session bean", (IOException)ex2);
            }
            throw new CSIException("Unexpected exception reading input stream for stateful session bean", ex2);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGZIPInputStream");
        }
        return result;
    }

    private long getBeanTimeoutTime(BeanId beanId) {
        if (EJSPlatformHelper.isZOS()) {
            StatefulSessionActivationStrategy as = (StatefulSessionActivationStrategy)beanId.getActivationStrategy();
            StatefulBeanReaper reaper = as.getReaper();
            return reaper.getBeanTimeoutTime(beanId);
        }
        return 0L;
    }

    @Override
    public GZIPOutputStream getGZIPOutputStream(BeanId beanId) throws CSIException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutputStream", (Object[])new Object[]{beanId});
        }
        final String fileName = this.getPortableFilename(beanId);
        final long beanTimeoutTime = this.getBeanTimeoutTime(beanId);
        GZIPOutputStream result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<GZIPOutputStream>(){

                @Override
                public GZIPOutputStream run() throws IOException {
                    File statefulBeanFile = FileBeanStore.this.getStatefulBeanFile(fileName, false);
                    FileOutputStream fos = EJSPlatformHelper.isZOS() ? new WSFileOutputStream(statefulBeanFile, beanTimeoutTime) : new FileOutputStream(statefulBeanFile);
                    return new GZIPOutputStream(fos);
                }
            });
        }
        catch (PrivilegedActionException ex2) {
            Exception ex = ex2.getException();
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getOutputStream"), (String)"127", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_WRITING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0025W", (Object[])new Object[]{fileName, this, ex});
            throw new CSIException("Unable to open output stream", ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream");
        }
        return result;
    }

    @Override
    public void remove(BeanId beanId) {
        boolean isTraceOn;
        block4: {
            final String fileName = this.getPortableFilename(beanId);
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("remove: key=" + beanId + ", file=" + fileName), (Object[])new Object[0]);
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        File theFile = FileBeanStore.this.getStatefulBeanFile(fileName, true);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("deleting file: " + theFile.getName() + ", path: " + theFile.getPath()), (Object[])new Object[0]);
                        }
                        boolean deleted = theFile.delete();
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("File.delete returned: " + deleted), (Object[])new Object[0]);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                FFDCFilter.processException((Throwable)ex.getException(), (String)(CLASS_NAME + ".remove"), (String)"150", (Object)this);
                if (!isTraceOn || !tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Failed to remove session bean state", (Object[])new Object[]{beanId, ex});
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    private String getPortableFilename(BeanId beanId) {
        StringBuilder result = new StringBuilder();
        result.append(FILENAME_PREFIX);
        this.appendPortableFilenameString(result, beanId.getJ2EEName().toString());
        result.append("__");
        this.appendPortableFilenameString(result, beanId.getPrimaryKey().toString());
        result.append('_');
        return result.toString();
    }

    private void appendPortableFilenameString(StringBuilder result, String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    @Override
    public OutputStream getOutputStream(BeanId beanId) throws CSIException {
        final String fileName = this.getPortableFilename(beanId);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getOutputStream: key=" + beanId + ", file="), (Object[])new Object[]{fileName});
        }
        final long beanTimeoutTime = this.getBeanTimeoutTime(beanId);
        FileOutputStream result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    File file = new File(FileBeanStore.this.passivationDir, fileName);
                    if (EJSPlatformHelper.isZOS()) {
                        return new WSFileOutputStream(file, beanTimeoutTime);
                    }
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getUnCompressedOutputStream"), (String)"460", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_WRITING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0025W", (Object[])new Object[]{fileName, this, ex});
            throw new CSIException("Unable to open output stream", ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream");
        }
        return result;
    }

    @Override
    public InputStream getInputStream(BeanId beanId) throws CSIException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInputStream", (Object[])new Object[]{beanId});
        }
        final String fileName = this.getPortableFilename(beanId);
        FileInputStream result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(new File(FileBeanStore.this.passivationDir, fileName));
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception ex2 = ex.getException();
            if (ex2 instanceof FileNotFoundException) {
                FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".getInputStream"), (String)"524", (Object)this);
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No file found while trying to activate passivated stateful session bean", (Object[])new Object[]{fileName});
                }
                throw new StreamUnavailableException("");
            }
            if (ex2 instanceof IOException) {
                FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".getInputStream"), (String)"531", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_READING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0024W", (Object[])new Object[]{fileName, this, ex2});
                throw new CSIException("IOException reading input stream for stateful session bean", (IOException)ex2);
            }
            throw new CSIException("Unexpected exception reading input stream for stateful session bean", ex2);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInputStream");
        }
        return result;
    }

    private class FileBeanFilter
    implements FileFilter {
        private FileBeanFilter() {
        }

        @Override
        public boolean accept(File fileObj) {
            String fileName = fileObj.getName();
            return fileName.startsWith(FileBeanStore.FILENAME_PREFIX) && (fileName.endsWith(FileBeanStore.this.serverName) || FileBeanStore.this.clusterName != null && fileName.endsWith(FileBeanStore.this.clusterName));
        }
    }

    private static class WSFileOutputStream
    extends FileOutputStream
    implements PrivilegedAction<Object> {
        long beanTimeoutTime;
        File beanFileObj;

        public WSFileOutputStream(File fileObj, long TimeoutTime) throws IOException {
            super(fileObj);
            this.beanFileObj = fileObj;
            this.beanTimeoutTime = TimeoutTime;
        }

        @Override
        public void close() throws IOException {
            super.close();
            AccessController.doPrivileged(this);
        }

        @Override
        public Object run() {
            this.beanFileObj.setLastModified(this.beanTimeoutTime);
            return null;
        }
    }
}

