/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKey;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.RemoteQPConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.RefillKey;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;

public final class RemoteQPConsumerKey
extends LocalQPConsumerKey
implements RemoteDispatchableKey,
RefillKey {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(RemoteQPConsumerKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    final SelectionCriteria[] criteria;
    private final RemoteConsumerDispatcher rcd;
    final boolean readAhead;
    private int prefetchWindowSize;
    private int consumptionInterval;
    static final double alpha = 0.5;
    private long lastNotReadyTime;
    private boolean usable;
    private int countOfOutstandingInfiniteTimeoutGets;
    private int countOfUnlockedMessages;
    private boolean isRefilling;
    protected boolean doRefill;
    private long refillTick = -1L;
    private long refillTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteQPConsumerKey(DispatchableConsumerPoint consumerPoint, ConsumerDispatcher consumerDispatcher, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean readAhead, boolean forwardScanning) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        super(consumerPoint, consumerDispatcher, criteria, connectionUuid, forwardScanning, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteQPConsumerKey", (Object)new Object[]{consumerPoint, consumerDispatcher, criteria, connectionUuid, readAhead, forwardScanning});
        }
        this.criteria = new SelectionCriteria[1];
        if (super.isSpecific()) {
            this.criteria[0] = criteria;
        } else {
            SelectionCriteria theCriteria = null;
            this.criteria[0] = theCriteria = consumerDispatcher.getMessageProcessor().getSelectionCriteriaFactory().createSelectionCriteria();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"RemoteQPConsumerKey", (Object)this);
            }
        }
        this.rcd = (RemoteConsumerDispatcher)consumerDispatcher;
        this.readAhead = readAhead;
        RemoteQPConsumerKey remoteQPConsumerKey = this;
        synchronized (remoteQPConsumerKey) {
            this.prefetchWindowSize = 0;
            this.consumptionInterval = 2 * consumerDispatcher.getMessageProcessor().getCustomProperties().get_max_interval_for_prefetch();
            this.lastNotReadyTime = 0L;
            this.usable = false;
            this.countOfOutstandingInfiniteTimeoutGets = 0;
            this.countOfUnlockedMessages = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waiting(long timeout, boolean modifyTimeout) {
        block38: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"waiting", (Object)new Object[]{new Long(timeout), modifyTimeout});
            }
            boolean processGets = true;
            RemoteQPConsumerKey remoteQPConsumerKey = this;
            synchronized (remoteQPConsumerKey) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("refilling: " + Boolean.valueOf(this.isRefilling) + "doRefill: " + Boolean.valueOf(this.doRefill)));
                }
                if (this.isRefilling) {
                    processGets = false;
                    if (timeout == 0L) {
                        this.refillTime = timeout;
                    } else if (timeout != -1L) {
                        long expiryTime = System.currentTimeMillis() + timeout;
                        if (this.refillTime != 0L && this.refillTime < expiryTime) {
                            this.refillTime = expiryTime;
                        }
                    }
                } else if (this.doRefill) {
                    this.isRefilling = true;
                    this.doRefill = false;
                }
            }
            if (processGets) {
                try {
                    AIStreamKey key;
                    long protocolTimeout;
                    if (modifyTimeout) {
                        if (timeout == 0L) {
                            protocolTimeout = -1L;
                        } else if (timeout == -1L) {
                            timeout = this.getRoundTripTime();
                            protocolTimeout = 0L;
                        } else {
                            long rtt = this.getRoundTripTime();
                            timeout = protocolTimeout = timeout + rtt;
                        }
                    } else {
                        protocolTimeout = timeout == 0L ? -1L : (timeout == -1L ? 0L : timeout);
                    }
                    boolean callIssueGet = true;
                    if (this.readAhead || protocolTimeout == -1L) {
                        RemoteQPConsumerKey remoteQPConsumerKey2 = this;
                        synchronized (remoteQPConsumerKey2) {
                            if (this.countOfOutstandingInfiniteTimeoutGets > 0) {
                                callIssueGet = false;
                            } else if (this.keyGroup == null && protocolTimeout == -1L) {
                                ++this.countOfOutstandingInfiniteTimeoutGets;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfOutstandingInfiniteTimeoutGets++ " + this.countOfOutstandingInfiniteTimeoutGets));
                                }
                            }
                        }
                        if (this.readAhead) {
                            this.tryPrefetching();
                        }
                    }
                    if (!callIssueGet || (key = this.keyGroup == null ? this.rcd.issueGet(this.criteria, protocolTimeout, this, this) : ((RemoteQPConsumerKeyGroup)this.keyGroup).issueGet(protocolTimeout, this)) != null) break block38;
                    RemoteQPConsumerKey remoteQPConsumerKey3 = this;
                    synchronized (remoteQPConsumerKey3) {
                        if (this.keyGroup == null && protocolTimeout == -1L) {
                            --this.countOfOutstandingInfiniteTimeoutGets;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfOutstandingInfiniteTimeoutGets-- " + this.countOfOutstandingInfiniteTimeoutGets));
                            }
                        }
                    }
                    SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0481", new Object[]{this.rcd.getDestName(), this.rcd.getLocalisationUuid().toString()}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey.waiting", (String)"1:357:1.47.1.26", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    this.consumerPoint.notifyException(e);
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey.waiting", (String)"1:369:1.47.1.26", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"waiting", (Object)"SIErrorException");
                    }
                    throw new SIErrorException((Throwable)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waiting", (Object)timeout);
        }
        return timeout;
    }

    @Override
    public void notReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notReady");
        }
        this.updateLastNotReadyTime();
        super.notReady();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notReady");
        }
    }

    @Override
    public void ready(Reliability unrecoverability) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ready", (Object)unrecoverability);
        }
        this.updateConsumptionInterval();
        super.ready(unrecoverability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ready");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateLastNotReadyTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLastNotReadyTime");
        }
        if (this.readAhead) {
            RemoteQPConsumerKey remoteQPConsumerKey = this;
            synchronized (remoteQPConsumerKey) {
                if (!this.usable) {
                    this.lastNotReadyTime = System.currentTimeMillis();
                    this.usable = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateLastNotReadyTime");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateConsumptionInterval() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateConsumptionInterval");
        }
        if (this.readAhead) {
            RemoteQPConsumerKey remoteQPConsumerKey = this;
            synchronized (remoteQPConsumerKey) {
                if (this.usable) {
                    this.usable = false;
                    long latestConsumptionInterval = System.currentTimeMillis() - this.lastNotReadyTime;
                    this.consumptionInterval = (int)(0.5 * (double)latestConsumptionInterval + 0.5 * (double)this.consumptionInterval);
                    if (this.consumptionInterval == 0) {
                        this.prefetchWindowSize = this.rcd.getMessageProcessor().getCustomProperties().get_max_prefetch_window();
                    } else if (this.consumptionInterval > this.rcd.getMessageProcessor().getCustomProperties().get_max_interval_for_prefetch()) {
                        this.prefetchWindowSize = 0;
                    } else if ((long)this.consumptionInterval > this.getRoundTripTime()) {
                        this.prefetchWindowSize = 1;
                    } else {
                        this.prefetchWindowSize = (int)Math.ceil((double)this.getRoundTripTime() / (double)this.consumptionInterval);
                        if (this.prefetchWindowSize > this.rcd.getMessageProcessor().getCustomProperties().get_max_prefetch_window()) {
                            this.prefetchWindowSize = this.rcd.getMessageProcessor().getCustomProperties().get_max_prefetch_window();
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("readAhead change: prefetchWindowSize(" + this.prefetchWindowSize + ") consumptionInterval(" + this.consumptionInterval + ")"));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateConsumptionInterval");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void messageReceived(AIStreamKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"messageReceived", (Object)key);
        }
        long timeout = this.refillTime;
        boolean reissueGet = false;
        RemoteQPConsumerKey remoteQPConsumerKey = this;
        synchronized (remoteQPConsumerKey) {
            ++this.countOfUnlockedMessages;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfUnlockedMessages++ " + this.countOfUnlockedMessages));
            }
            if (key.getOriginalTimeout() == -1L) {
                --this.countOfOutstandingInfiniteTimeoutGets;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfOutstandingInfiniteTimeoutGets-- " + this.countOfOutstandingInfiniteTimeoutGets));
                }
            }
            if (this.isRefilling && key.getTick() == this.refillTick) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("we are refilling, refillTime: " + Long.valueOf(this.refillTime)));
                }
                this.isRefilling = false;
                this.refillTick = -1L;
                if (this.refillTime != -1L) {
                    if (timeout != 0L) {
                        timeout = this.refillTime - System.currentTimeMillis();
                    }
                    if (timeout == 0L || timeout > 0L) {
                        reissueGet = true;
                    }
                }
            }
        }
        if (reissueGet) {
            this.initiateRefill();
            this.waiting(timeout, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"messageReceived");
        }
    }

    protected final void completedReceived(AIStreamKey key, boolean reissueGet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"completedReceived", (Object)new Object[]{key, reissueGet});
        }
        this.completedReceivedNoPrefetch(key, reissueGet);
        try {
            if (this.readAhead) {
                this.tryPrefetching();
            }
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey.completedReceived", (String)"1:568:1.47.1.26", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"completedReceived");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void completedReceivedNoPrefetch(AIStreamKey key, boolean reissueGet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"completedReceivedNoPrefetch", (Object)new Object[]{key, reissueGet});
        }
        boolean initiateRefill = false;
        long timeout = key.getOriginalTimeout();
        RemoteQPConsumerKey remoteQPConsumerKey = this;
        synchronized (remoteQPConsumerKey) {
            if (timeout == -1L) {
                --this.countOfOutstandingInfiniteTimeoutGets;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfOutstandingInfiniteTimeoutGets-- " + this.countOfOutstandingInfiniteTimeoutGets));
                }
            }
            if (this.isRefilling) {
                this.checkAndResetRefillState(key.getTick());
            }
            if (timeout != 0L && timeout != -1L) {
                long timeoutTime;
                long currTime = System.currentTimeMillis();
                long expectedResponseTime = currTime + this.rcd.getRoundTripTime();
                timeout = expectedResponseTime < (timeoutTime = key.getIssueTime() + key.getOriginalTimeout()) ? timeoutTime - currTime : 0L;
            }
        }
        if (reissueGet && (timeout == -1L || timeout > 0L)) {
            if (initiateRefill) {
                this.initiateRefill();
            }
            this.waiting(timeout, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"completedReceivedNoPrefetch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageLocked(AIStreamKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"messageLocked", (Object)key);
        }
        RemoteQPConsumerKey remoteQPConsumerKey = this;
        synchronized (remoteQPConsumerKey) {
            --this.countOfUnlockedMessages;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfUnlockedMessages-- " + this.countOfUnlockedMessages));
            }
        }
        try {
            if (this.readAhead) {
                this.tryPrefetching();
            }
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey.messageLocked", (String)"1:663:1.47.1.26", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"messageLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageUnlocked(AIStreamKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"messageUnlocked", (Object)key);
        }
        RemoteQPConsumerKey remoteQPConsumerKey = this;
        synchronized (remoteQPConsumerKey) {
            ++this.countOfUnlockedMessages;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfUnlockedMessages++ " + this.countOfUnlockedMessages));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"messageUnlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPrefetching() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"tryPrefetching");
        }
        int toPrefetchCount = 0;
        RemoteQPConsumerKey remoteQPConsumerKey = this;
        synchronized (remoteQPConsumerKey) {
            if (!this.detached) {
                int count = this.countOfOutstandingInfiniteTimeoutGets + this.countOfUnlockedMessages;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("readAhead check: count(" + count + ") prefetchWindowSize(" + this.prefetchWindowSize + ")"));
                }
                if (count < this.prefetchWindowSize && (double)(this.prefetchWindowSize - count) / (double)this.prefetchWindowSize > 0.25) {
                    toPrefetchCount = this.prefetchWindowSize - count;
                    this.countOfOutstandingInfiniteTimeoutGets += toPrefetchCount;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfOutstandingInfiniteTimeoutGets+= " + this.countOfOutstandingInfiniteTimeoutGets));
                    }
                }
            }
        }
        if (toPrefetchCount > 0) {
            AIStreamKey[] keys;
            int i;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("readAhead change: toPrefetchCount " + toPrefetchCount));
            }
            if ((i = (keys = this.rcd.issueGet(this.criteria, toPrefetchCount, this)) == null ? 0 : keys.length) < toPrefetchCount) {
                RemoteQPConsumerKey remoteQPConsumerKey2 = this;
                synchronized (remoteQPConsumerKey2) {
                    this.countOfOutstandingInfiniteTimeoutGets -= toPrefetchCount - i;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("readAhead change: countOfOutstandingInfiniteTimeoutGets-= " + this.countOfOutstandingInfiniteTimeoutGets));
                    }
                }
                SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0481", new Object[]{this.rcd.getDestName(), this.rcd.getLocalisationUuid().toString()}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey.tryPrefetching", (String)"1:755:1.47.1.26", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                this.consumerPoint.notifyException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"tryPrefetching");
        }
    }

    @Override
    public final SelectionCriteria[] getSelectionCriteria() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelectionCriteria");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSelectionCriteria", (Object)this.criteria);
        }
        return this.criteria;
    }

    @Override
    public void notifyException(SIException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyException");
        }
        this.consumerPoint.notifyException(e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyException");
        }
    }

    @Override
    public boolean hasNonSpecificConsumers() {
        boolean value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNonSpecificConsumers");
        }
        boolean bl = value = !this.isSpecific();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasNonSpecificConsumers", (Object)value);
        }
        return value;
    }

    public long getRoundTripTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRoundTripTime");
        }
        long rc = this.rcd.getRoundTripTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRoundTripTime", (Object)rc);
        }
        return rc;
    }

    public boolean getReadAhead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReadAhead");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReadAhead", (Object)("rc=" + this.readAhead));
        }
        return this.readAhead;
    }

    @Override
    protected SIMPMessage getMessageLocked(int classification) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageLocked", (Object)classification);
        }
        SIMPMessage msg = null;
        msg = !this.classifyingMessages ? (SIMPMessage)this.getDefaultGetCursor().next() : (SIMPMessage)this.getGetCursor(classification).next();
        if (msg != null) {
            msg.setLocalisingME(this.rcd.getLocalisationUuid());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageLocked", (Object)msg);
        }
        return msg;
    }

    @Override
    public boolean filterMatches(AbstractItem item) {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"filterMatches", (Object)item);
        }
        if ((result = super.filterMatches(item)) && ((AIMessageItem)item).isReserved()) {
            result = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"filterMatches", (Object)result);
        }
        return result;
    }

    @Override
    public synchronized void initiateRefill() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initiateRefill", (Object)("isRefilling: " + Boolean.valueOf(this.isRefilling)));
        }
        if (!this.isRefilling) {
            this.refillTime = -1L;
            this.doRefill = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initiateRefill", (Object)this.doRefill);
        }
    }

    @Override
    public synchronized boolean isRefillAllowed() {
        boolean refillAllowed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isRefillAllowed");
        }
        boolean bl = refillAllowed = this.doRefill || this.isRefilling;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isRefillAllowed", (Object)refillAllowed);
        }
        return refillAllowed;
    }

    @Override
    public synchronized void setLatestTick(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLatestTick", (Object)tick);
        }
        this.refillTick = tick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLatestTick", (Object)this);
        }
    }

    public synchronized void checkAndResetRefillState(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetRefillState", (Object)tick);
        }
        if (this.refillTick == tick) {
            this.refillTick = -1L;
            this.refillTime = -1L;
            this.isRefilling = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resetRefillState");
        }
    }
}

