/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer61.osgi.webapp;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.response.ResponseUtils;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer40.osgi.webapp.WebAppDispatcherContext40;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebAppDispatcherContext61
extends WebAppDispatcherContext40 {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("io.openliberty.webcontainer61.osgi.webapp");
    protected static final String CLASS_NAME = WebAppDispatcherContext61.class.getName();

    public WebAppDispatcherContext61() {
    }

    public WebAppDispatcherContext61(WebApp webapp) {
        super(webapp);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructor", "this [" + String.valueOf((Object)this) + "] , webapp [" + String.valueOf(webapp) + "]");
        }
    }

    public WebAppDispatcherContext61(IExtendedRequest req) {
        super(req);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructor", "this [" + String.valueOf((Object)this) + "] , request [" + String.valueOf(req) + "]");
        }
    }

    public void sendRedirect(String location, int statusCode, boolean clearBuffer) throws IOException {
        HttpServletResponse response;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", "this [" + String.valueOf((Object)this) + "]");
        }
        if (!(response = (HttpServletResponse)this.getResponse()).isCommitted()) {
            if (!WCCustomProperties.REDIRECT_TO_RELATIVE_URL) {
                location = this.convertRelativeURIToURL(location);
            }
            response.setHeader("Location", location);
            response.setStatus(statusCode);
            if (clearBuffer) {
                String hyperText = ResponseUtils.encodeDataString((String)MessageFormat.format(nls.getString("sendRedirect.hyper.text.url"), location));
                response.resetBuffer();
                try {
                    ServletOutputStream out = response.getOutputStream();
                    out.write(hyperText.getBytes(StandardCharsets.UTF_8));
                }
                catch (IllegalStateException ise) {
                    PrintWriter writer = response.getWriter();
                    writer.print(hyperText);
                }
            }
        } else {
            throw new IllegalStateException(nls.getString("cannot.sendRedirect.response.already.committed"));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", "return from dispatcher.");
        }
    }
}

