/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.Securable;

public class SecurableObjectHolder {
    private String m_securableClassName;
    private Securable m_securableObject = null;

    public SecurableObjectHolder() {
        this(null);
    }

    public SecurableObjectHolder(String securableClassName) {
        this.m_securableClassName = securableClassName;
    }

    public String getEncryptionClassName() {
        return this.m_securableClassName;
    }

    public void setEncryptionClassName(String securableClassName) {
        this.m_securableClassName = securableClassName;
    }

    public Securable getSecurableObject() {
        if (this.m_securableObject == null) {
            this.initSecurableObject();
        }
        return this.m_securableObject;
    }

    public boolean hasSecurableObject() {
        return this.m_securableObject != null;
    }

    private void initSecurableObject() {
        block7: {
            boolean initPassThroughEncryptor = false;
            try {
                if (this.m_securableClassName == null || JCEEncryptor.class.getName().equals(this.m_securableClassName)) {
                    initPassThroughEncryptor = this.m_securableClassName == null;
                    this.m_securableObject = new JCEEncryptor();
                    return;
                }
                ConversionManager cm = ConversionManager.getDefaultManager();
                Class securableClass = cm.convertObject(this.m_securableClassName, Class.class);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_securableObject = (Securable)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(securableClass));
                        break block7;
                    }
                    catch (PrivilegedActionException exception) {
                        throw exception.getException();
                    }
                }
                this.m_securableObject = (Securable)PrivilegedAccessHelper.newInstanceFromClass(securableClass);
            }
            catch (Throwable e) {
                if (initPassThroughEncryptor) {
                    this.m_securableObject = new PassThroughEncryptor();
                }
                throw ValidationException.invalidEncryptionClass(this.m_securableClassName, e);
            }
        }
    }

    private static final class PassThroughEncryptor
    implements org.eclipse.persistence.security.Securable {
        private PassThroughEncryptor() {
        }

        @Override
        public String encryptPassword(String pswd) {
            return pswd;
        }

        @Override
        public String decryptPassword(String encryptedPswd) {
            return encryptedPswd;
        }
    }
}

