/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator.activator;

import java.util.ArrayList;
import java.util.List;
import org.apache.yoko.osgi.locator.LocalFactory;
import org.apache.yoko.osgi.locator.PackageProvider;
import org.apache.yoko.osgi.locator.Register;
import org.apache.yoko.osgi.locator.ServiceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractBundleActivator
implements BundleActivator {
    private static final Info[] NO_INFO = new Info[0];
    private final LocalFactory localFactory;
    private final Info[] providerInfo;
    private final Info[] serviceInfo;
    private final String[] providedPackages;
    private ServiceTracker<Register, Register> tracker;
    private BundleContext context;
    private boolean registered;
    private final List<ServiceProvider> providerLoaders = new ArrayList<ServiceProvider>();
    private final List<ServiceProvider> serviceLoaders = new ArrayList<ServiceProvider>();
    private PackageProvider packageProvider;

    protected AbstractBundleActivator(LocalFactory localFactory, Info[] providerInfo, Info[] serviceInfo, String ... providedPackages) {
        this.localFactory = localFactory;
        this.providerInfo = providerInfo;
        this.serviceInfo = serviceInfo;
        this.providedPackages = providedPackages;
    }

    protected AbstractBundleActivator(LocalFactory localFactory, String ... providedPackages) {
        this(localFactory, NO_INFO, NO_INFO, providedPackages);
    }

    public void start(final BundleContext context) throws Exception {
        this.context = context;
        this.tracker = new ServiceTracker(context, Register.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Register, Register>(){

            public Register addingService(ServiceReference<Register> reference) {
                Register register = (Register)context.getService(reference);
                AbstractBundleActivator.this.register(register);
                return register;
            }

            public void modifiedService(ServiceReference<Register> reference, Register service) {
            }

            public void removedService(ServiceReference<Register> reference, Register service) {
            }
        });
        this.tracker.open();
        Register register = (Register)this.tracker.getService();
        if (register != null) {
            this.register(register);
        }
    }

    private synchronized void register(Register register) {
        if (!this.registered) {
            ServiceProvider sp;
            this.registered = true;
            Bundle bundle = this.context.getBundle();
            for (Info info : this.providerInfo) {
                sp = new ServiceProvider(this.localFactory, info.id, info.className, info.priority);
                this.providerLoaders.add(sp);
                register.registerProvider(sp);
            }
            for (Info info : this.serviceInfo) {
                sp = new ServiceProvider(this.localFactory, info.id, info.className, info.priority);
                this.serviceLoaders.add(sp);
                register.registerService(sp);
            }
            if (this.providedPackages.length > 0) {
                this.packageProvider = new PackageProvider(this.localFactory, this.providedPackages);
                register.registerPackages(this.packageProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Register register = (Register)this.tracker.getService();
        this.tracker.close();
        AbstractBundleActivator abstractBundleActivator = this;
        synchronized (abstractBundleActivator) {
            if (register != null && this.registered) {
                for (ServiceProvider cp : this.providerLoaders) {
                    register.unregisterProvider(cp);
                }
                for (ServiceProvider cp : this.serviceLoaders) {
                    register.unregisterService(cp);
                }
                if (this.packageProvider != null) {
                    register.unregisterPackages(this.packageProvider);
                }
            }
        }
    }

    public static final class Info {
        final String id;
        final String className;
        final int priority;

        public Info(String id, String className, int priority) {
            this.id = id;
            this.className = className;
            this.priority = priority;
        }

        public Info(String id, String className) {
            this(id, className, 1);
        }

        public Info(String id, Class<?> implClass, int priority) {
            this(id, implClass.getName(), priority);
        }

        public Info(String id, Class<?> implClass) {
            this(id, implClass.getName());
        }

        public <T, U extends T> Info(Class<T> idClass, Class<U> implClass, int priority) {
            this(idClass.getName(), implClass.getName(), priority);
        }

        public <T, U extends T> Info(Class<T> idClass, Class<U> implClass) {
            this(idClass.getName(), implClass.getName());
        }

        public <T> Info(Class<T> svcClass, int priority) {
            this(svcClass, svcClass, priority);
        }

        public <T> Info(Class<T> svcClass) {
            this(svcClass, svcClass);
        }
    }
}

