/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.handlers;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.ws.logging.hpel.LogRecordSerializer;
import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import com.ibm.ws.logging.hpel.SerializationObject;
import com.ibm.ws.logging.hpel.impl.LogRecordWrapper;
import com.ibm.ws.logging.hpel.impl.LogRepositorySubManagerImpl;
import com.ibm.ws.logging.hpel.impl.SerializationObjectPool;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LogRecordHandler
extends Handler {
    private final SerializationObjectPool pool;
    private final byte[] headerBytes;
    private final int traceThreshold;
    private LogRepositorySubManagerImpl logSubManager = null;
    private LogRepositorySubManagerImpl traceSubManager = null;
    private LogRepositoryWriter logWriter = null;
    private LogRepositoryWriter traceWriter = null;
    private ThreadLocal<Integer> logStackCount = new ThreadLocal<Integer>(){

        @Override
        public Integer initialValue() {
            return 0;
        }
    };

    public LogRecordHandler(int traceThreshold, LogRecordSerializer formatter) {
        this(traceThreshold, formatter, HpelHelper.getHeaderAsProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecordHandler(int traceThreshold, final LogRecordSerializer formatter, Properties headerProps) throws IllegalArgumentException {
        if (headerProps == null) {
            throw new IllegalArgumentException("Null properties object to populate headers");
        }
        this.pool = new SerializationObjectPool(){

            @Override
            public SerializationObject createNewObject() {
                return new SerializationBuffer(formatter);
            }
        };
        SerializationObject serializationObject = this.pool.getSerializationObject();
        try {
            this.headerBytes = serializationObject.serializeFileHeader(headerProps);
        }
        finally {
            this.pool.returnSerializationObject(serializationObject);
        }
        this.traceThreshold = traceThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(LogRecord record) {
        byte[] bytes;
        SerializationObject serializationObject = this.pool.getSerializationObject();
        try {
            bytes = serializationObject.serialize(record);
        }
        finally {
            this.pool.returnSerializationObject(serializationObject);
        }
        LogRecordHandler logRecordHandler = this;
        synchronized (logRecordHandler) {
            if (this.traceWriter != null && record.getLevel().intValue() < this.traceThreshold) {
                this.traceWriter.logRecord(record.getMillis(), bytes);
            } else if (this.logWriter != null) {
                this.logWriter.logRecord(record.getMillis(), bytes);
            }
        }
    }

    public void stop() {
        if (this.logWriter != null) {
            this.logWriter.stop();
            this.logWriter.getLogRepositoryManager().stop();
            this.logWriter = null;
        }
        if (this.traceWriter != null) {
            this.traceWriter.stop();
            this.traceWriter.getLogRepositoryManager().stop();
            this.traceWriter = null;
        }
    }

    public synchronized LogRepositoryWriter getLogWriter() {
        return this.logWriter;
    }

    public synchronized void setLogWriter(LogRepositoryWriter logWriter) {
        if (this.logWriter != null) {
            this.logWriter.stop();
        }
        this.logWriter = logWriter;
        if (this.logWriter == null) {
            this.logSubManager = null;
        } else {
            this.logWriter.setHeader(this.headerBytes);
            this.logSubManager = this.getSubManager(logWriter);
        }
    }

    private LogRepositorySubManagerImpl getSubManager(LogRepositoryWriter logWriter) {
        LogRepositoryManager logMgr = logWriter.getLogRepositoryManager();
        return logMgr instanceof LogRepositorySubManagerImpl ? (LogRepositorySubManagerImpl)logMgr : null;
    }

    public synchronized LogRepositoryWriter getTraceWriter() {
        return this.traceWriter;
    }

    public synchronized void setTraceWriter(LogRepositoryWriter traceWriter) {
        if (this.traceWriter != null) {
            this.traceWriter.stop();
        }
        this.traceWriter = traceWriter;
        if (this.traceWriter == null) {
            this.traceSubManager = null;
        } else {
            this.traceWriter.setHeader(this.headerBytes);
            this.traceSubManager = this.getSubManager(traceWriter);
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        Integer stackLogLevel = -1;
        if (this.logSubManager != null || this.traceSubManager != null) {
            stackLogLevel = this.logStackCount.get();
        }
        this.logStackCount.set(stackLogLevel + 1);
        this.processEvent(record);
        if (stackLogLevel == 0) {
            boolean handleQueuedActions = true;
            while (handleQueuedActions) {
                handleQueuedActions = false;
                if (this.traceSubManager != null) {
                    boolean bl = handleQueuedActions = this.traceSubManager.sendNotifications() || handleQueuedActions;
                }
                if (this.logSubManager == null) continue;
                handleQueuedActions = this.logSubManager.sendNotifications() || handleQueuedActions;
            }
        }
        if (this.logSubManager != null || this.traceSubManager != null) {
            if (this.logSubManager != null) {
                this.logSubManager.purgeOldFilesAsync();
            }
            if (this.traceSubManager != null) {
                this.traceSubManager.purgeOldFilesAsync();
            }
            this.logStackCount.set(stackLogLevel);
        }
    }

    private static class SerializationBuffer
    implements SerializationObject {
        private static final int BYTE_ARRAY_INITIAL_SIZE = 1024;
        private final LogRecordSerializer formatter;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);

        SerializationBuffer(LogRecordSerializer formatter) {
            this.formatter = formatter;
        }

        @Override
        public byte[] serialize(LogRecord record) {
            this.buffer.reset();
            DataOutputStream stream = new DataOutputStream(this.buffer);
            try {
                this.formatter.serialize(new LogRecordWrapper(record), stream);
                stream.flush();
                stream.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("failed to write into memory buffer", ex);
            }
            return this.buffer.toByteArray();
        }

        @Override
        public byte[] serializeFileHeader(Properties header) {
            this.buffer.reset();
            DataOutputStream stream = new DataOutputStream(this.buffer);
            try {
                this.formatter.serializeFileHeader(header, stream);
                stream.flush();
                stream.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("failed to write into memory buffer", ex);
            }
            return this.buffer.toByteArray();
        }
    }
}

