/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.attach;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jfap.inbound.channel.CommsServerServiceFacade;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.ComponentData;
import com.ibm.ws.sib.comms.DirectConnection;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.trm.TrmClientBootstrapReply;
import com.ibm.ws.sib.mfp.trm.TrmClientBootstrapRequest;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessage;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.ArrayList;
import javax.security.auth.Subject;

public final class TrmSingleton
implements ComponentData {
    private static final TraceComponent tc = SibTr.register(TrmSingleton.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static TrmSingleton instance = null;

    private TrmSingleton() {
    }

    public static TrmSingleton getTrmSingleton() {
        if (instance == null) {
            return new TrmSingleton();
        }
        return instance;
    }

    public Object getComponentData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getComponentData");
            SibTr.exit((TraceComponent)tc, (String)"getComponentData", (Object)this);
        }
        return this;
    }

    private SICoreConnectionFactory getConnectionFactory() {
        return null;
    }

    public byte[] handShake(ClientConnection cc, byte[] data) {
        TrmClientBootstrapReply cbrp;
        TrmClientBootstrapRequest cbrq;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handShake", (Object)new Object[]{cc, data});
        }
        try {
            TrmMessageFactory mf = CommsServerServiceFacade.getTrmMessageFactory();
            TrmFirstContactMessage fcm = mf.createInboundTrmFirstContactMessage(data, 0, data.length);
            TrmFirstContactMessageType fcmt = fcm.getMessageType();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Received " + fcmt.toString() + " msg"));
            }
            cbrq = fcm.makeInboundTrmClientBootstrapRequest();
            cbrp = mf.createNewTrmClientBootstrapReply();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)".handShake", (String)"18", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handShake");
            }
            return null;
        }
        ArrayList<String> failureReason = new ArrayList<String>();
        try {
            JsAdminService admnService;
            cbrp.setReturnCode(-1);
            cbrp.setEndPointData(null);
            cbrp.setBusName(null);
            cbrp.setSubnetName(null);
            cbrp.setMessagingEngineName(null);
            String bus = cbrq.getBusName();
            String credentialType = cbrq.getCredentialType();
            String userid = cbrq.getUserid();
            String password = cbrq.getPassword();
            String targetName = cbrq.getTargetGroupName();
            String targetType = cbrq.getTargetGroupType();
            String targetSignificance = cbrq.getTargetSignificance();
            String targetTransportChain = cbrq.getTargetTransportChain();
            String connectionProximity = cbrq.getConnectionProximity();
            String connectionMode = cbrq.getConnectionMode();
            if (connectionMode == null) {
                connectionMode = "Normal";
            }
            if ((admnService = CommsServerServiceFacade.getJsAdminService()) == null) {
                cbrp.setReturnCode(-2);
                failureReason.add("Messaging engine not activated");
                cbrp.setFailureReason(failureReason);
            } else {
                JsMessagingEngine local_ME = admnService.getMessagingEngine("defaultBus", "defaultME");
                if (local_ME == null) {
                    cbrp.setReturnCode(-2);
                    failureReason.add("Messaging engine not initialized");
                    cbrp.setFailureReason(failureReason);
                } else {
                    try {
                        SICoreConnectionFactory scf = (SICoreConnectionFactory)local_ME.getMessageProcessor();
                        SICoreConnection sc = scf.createConnection(cc, credentialType, userid, password);
                        cbrp.setReturnCode(0);
                        cc.setSICoreConnection(sc);
                    }
                    catch (SINotAuthorizedException e) {
                        cbrp.setReturnCode(-6);
                        failureReason.add(e.getMessage());
                        cbrp.setFailureReason(failureReason);
                    }
                    catch (SIResourceException e) {
                        cbrp.setReturnCode(-2);
                        failureReason.add(e.getMessage());
                        cbrp.setFailureReason(failureReason);
                    }
                    catch (SIAuthenticationException e) {
                        cbrp.setReturnCode(-9);
                        failureReason.add(e.getMessage());
                        cbrp.setFailureReason(failureReason);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)".handShake", (String)"19", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            cbrp.setReturnCode(-1);
            failureReason.add(e.getMessage());
            cbrp.setFailureReason(failureReason);
        }
        byte[] reply = null;
        try {
            reply = cbrp.encode((Object)cc);
        }
        catch (MessageEncodeFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)".handShake", (String)"20", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handShake", (Object)reply);
        }
        return reply;
    }

    public byte[] handShake(MEConnection mc, byte[] data) {
        return null;
    }

    public boolean directConnect(DirectConnection dc, Subject subject) {
        return false;
    }
}

