/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.extensions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.intfc.SubjectManagerService;
import com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextHelper;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.SecurityContext;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityContextImpl
implements SecurityContext {
    static final long serialVersionUID = 515881541317372105L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public AuthenticationStatus authenticate(HttpServletRequest req, HttpServletResponse res, AuthenticationParameters params) {
        AuthenticationStatus authStatus = AuthenticationStatus.SEND_FAILURE;
        req.setAttribute("com.ibm.ws.security.javaeesec.auth.params", (Object)params);
        try {
            boolean result = req.authenticate(res);
            if (result) {
                authStatus = AuthenticationStatus.SUCCESS;
            }
        }
        catch (Exception result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextImpl", (String)"60", (Object)this, (Object[])new Object[]{req, res, params});
            e.printStackTrace();
        }
        return authStatus;
    }

    public Principal getCallerPrincipal() {
        Subject callerSubject = this.getCallerSubject();
        return SubjectManager.getCallerPrincipal((Subject)callerSubject);
    }

    public <T extends Principal> Set<T> getPrincipalsByType(Class<T> type) {
        Subject callerSubject = this.getCallerSubject();
        if (callerSubject != null) {
            Set<T> principals = callerSubject.getPrincipals(type);
            return principals;
        }
        return null;
    }

    public boolean hasAccessToWebResource(String resource, String ... methods) {
        String appName = this.getApplicationName();
        SecurityMetadata securityMetadata = WebConfigUtils.getSecurityMetadata();
        SecurityConstraintCollection collection = null;
        if (securityMetadata != null) {
            collection = securityMetadata.getSecurityConstraintCollection();
        }
        if (null != collection) {
            AuthorizationService authService = SecurityContextHelper.getAuthorizationService();
            Subject callerSubject = this.getCallerSubject();
            List matchResponses = collection.getMatchResponses(resource, methods);
            for (MatchResponse response : matchResponses) {
                if (response.equals(MatchResponse.NO_MATCH_RESPONSE)) {
                    return true;
                }
                if (response.isAccessPrecluded()) continue;
                List roles = response.getRoles();
                if (roles != null && !roles.isEmpty()) {
                    if (!authService.isAuthorized(appName, (Collection)roles, callerSubject)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCallerInRole(String role) {
        Subject callerSubject = this.getCallerSubject();
        AuthorizationService authService = SecurityContextHelper.getAuthorizationService();
        if (authService != null) {
            String appName = this.getApplicationName();
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(role);
            return authService.isAuthorized(appName, roles, callerSubject);
        }
        return false;
    }

    private Subject getCallerSubject() {
        SubjectManagerService subjectManagerService = SecurityContextHelper.getSubjectManagerService();
        if (subjectManagerService != null) {
            Subject callerSubject = null;
            callerSubject = subjectManagerService.getCallerSubject();
            return callerSubject;
        }
        return null;
    }

    private String getApplicationName() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        return cmd.getJ2EEName().getApplication();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextImpl", SecurityContextImpl.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    }
}

