/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ImmutableArrayList;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeInterning;

public final class TypeVariable
extends Type {
    private static final int HASH_MASK = Integer.MAX_VALUE;
    private static final int IMPLICIT_MASK = Integer.MIN_VALUE;
    private final String identifier;
    private final Type[] bounds;
    private int hash;

    public static TypeVariable create(String identifier) {
        return new TypeVariable(identifier, new Type[]{ClassType.OBJECT_TYPE});
    }

    public static Builder builder(String identifier) {
        return new Builder(identifier);
    }

    TypeVariable(String name) {
        this(name, EMPTY_ARRAY);
    }

    TypeVariable(String name, Type[] bounds) {
        this(name, bounds, null);
    }

    TypeVariable(String name, Type[] bounds, AnnotationInstance[] annotations) {
        this(name, bounds, annotations, false);
    }

    TypeVariable(String name, Type[] bounds, AnnotationInstance[] annotations, boolean implicitObjectBound) {
        super(DotName.OBJECT_NAME, annotations);
        this.identifier = name;
        this.bounds = bounds;
        this.hash = implicitObjectBound ? Integer.MIN_VALUE : 0;
    }

    @Override
    public DotName name() {
        if (this.bounds.length > 0) {
            return this.bounds[0].name();
        }
        return DotName.OBJECT_NAME;
    }

    public String identifier() {
        return this.identifier;
    }

    public List<Type> bounds() {
        return new ImmutableArrayList<Type>(this.bounds);
    }

    Type[] boundArray() {
        return this.bounds;
    }

    boolean hasImplicitObjectBound() {
        return (this.hash & Integer.MIN_VALUE) != 0;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.TYPE_VARIABLE;
    }

    @Override
    public TypeVariable asTypeVariable() {
        return this;
    }

    @Override
    Type copyType(AnnotationInstance[] newAnnotations) {
        return new TypeVariable(this.identifier, this.bounds, newAnnotations, this.hasImplicitObjectBound());
    }

    TypeVariable copyType(int boundIndex, Type bound) {
        if (boundIndex > this.bounds.length) {
            throw new IllegalArgumentException("Bound index outside of bounds");
        }
        Type[] bounds = (Type[])this.bounds.clone();
        bounds[boundIndex] = bound;
        return new TypeVariable(this.identifier, bounds, this.annotationArray(), this.hasImplicitObjectBound());
    }

    @Override
    String toString(boolean simple) {
        StringBuilder builder = new StringBuilder();
        this.appendAnnotations(builder);
        builder.append(this.identifier);
        if (!(simple || this.bounds.length <= 0 || this.bounds.length == 1 && ClassType.OBJECT_TYPE.equals(this.bounds[0]))) {
            builder.append(" extends ").append(this.bounds[0].toString(true));
            for (int i = 1; i < this.bounds.length; ++i) {
                builder.append(" & ").append(this.bounds[i].toString(true));
            }
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeVariable that = (TypeVariable)o;
        return this.identifier.equals(that.identifier) && Arrays.equals(this.bounds, that.bounds) && this.hasImplicitObjectBound() == that.hasImplicitObjectBound();
    }

    @Override
    public int hashCode() {
        int hash = this.hash & Integer.MAX_VALUE;
        if (hash != 0) {
            return hash;
        }
        hash = super.hashCode();
        hash = 31 * hash + this.identifier.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.bounds);
        this.hash |= (hash &= Integer.MAX_VALUE);
        return hash;
    }

    @Override
    boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.internEquals(o)) {
            return false;
        }
        TypeVariable that = (TypeVariable)o;
        return this.identifier.equals(that.identifier) && TypeInterning.arrayEquals(this.bounds, that.bounds) && this.hasImplicitObjectBound() == that.hasImplicitObjectBound();
    }

    @Override
    int internHashCode() {
        int hash = super.internHashCode();
        hash = 31 * hash + this.identifier.hashCode();
        hash = 31 * hash + TypeInterning.arrayHashCode(this.bounds);
        return hash;
    }

    public static final class Builder
    extends Type.Builder<Builder> {
        private final String identifier;
        private final List<Type> bounds;

        Builder(String identifier) {
            super(DotName.OBJECT_NAME);
            this.identifier = identifier;
            this.bounds = new ArrayList<Type>();
        }

        public Builder addBound(Type bound) {
            this.bounds.add(Objects.requireNonNull(bound));
            return this;
        }

        public Builder addBound(Class<?> clazz) {
            return this.addBound(ClassType.create(clazz));
        }

        public TypeVariable build() {
            Type[] typeArray;
            if (this.bounds.isEmpty()) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = ClassType.OBJECT_TYPE;
            } else {
                typeArray = this.bounds.toArray(Type.EMPTY_ARRAY);
            }
            return new TypeVariable(this.identifier, typeArray, this.annotationsArray());
        }
    }
}

