/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.util.ClauseNode;
import com.ibm.ws.webcontainer.util.URIMatcher;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URIMatcher
extends com.ibm.ws.webcontainer.util.URIMatcher {
    private static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.URIMatcher";
    protected static final boolean SERVLET_PATH_FOR_DEFAULT_MAPPING = Boolean.valueOf(WCCustomProperties.SERVLET_PATH_FOR_DEFAULT_MAPPING);

    public URIMatcher() {
    }

    public URIMatcher(boolean scalable) {
        super(scalable, true);
    }

    public Object match(IExtendedRequest req) {
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)req.getWebAppDispatcherContext();
        String uri = dispatchContext.getRelativeUri().trim();
        dispatchContext.setPossibleSlashStarMapping(true);
        int jsessionIndex = uri.indexOf(59);
        if (WCCustomProperties.USE_SEMICOLON_AS_DELIMITER_IN_URI) {
            String lowerCaseURI = uri.toLowerCase();
            if (jsessionIndex >= 0 && !lowerCaseURI.substring(jsessionIndex + 1).startsWith("jsessionid")) {
                int realJSIndex;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "match", "The semi-colon is being treated as a delimiter");
                }
                if ((realJSIndex = lowerCaseURI.indexOf(";jsessionid")) < 0) {
                    uri = uri.substring(0, jsessionIndex);
                    jsessionIndex = -1;
                } else {
                    uri = uri.substring(0, jsessionIndex) + uri.substring(realJSIndex);
                }
            }
        }
        String strippedUri = uri;
        if (jsessionIndex != -1) {
            strippedUri = strippedUri.substring(0, jsessionIndex);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "match", "uri->" + uri);
            logger.logp(Level.FINE, CLASS_NAME, "match", "jsessionIndex->" + jsessionIndex);
        }
        if (uri.equals("/") && this.root.getTarget() != null) {
            dispatchContext.setPossibleSlashStarMapping(false);
            dispatchContext.setPathElements("", "/");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "found an exact match on the context-root");
            }
            return this.root.getTarget();
        }
        URIMatcher.Result result = this.findNode(strippedUri);
        Object target = null;
        if (result != null && result.node != this.defaultNode) {
            String servletPath;
            ClauseNode node = result.node;
            target = result.target;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "found a target-->" + target);
            }
            boolean starTarget = node.getStarTarget() == target;
            String pathInfo = null;
            if (starTarget) {
                int split = node.getDepth();
                servletPath = uri;
                if (split < uri.length()) {
                    servletPath = uri.substring(0, split);
                    pathInfo = uri.substring(split);
                }
            } else {
                servletPath = strippedUri;
                String string = pathInfo = jsessionIndex == -1 ? null : uri.substring(jsessionIndex);
            }
            if (node != this.root) {
                dispatchContext.setPossibleSlashStarMapping(false);
            }
            dispatchContext.setPathElements(servletPath, pathInfo);
            return target;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "match", "looking for extension mapping");
        }
        if ((target = this.findByExtension(strippedUri)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "uri-->" + strippedUri + ", target-->" + target);
            }
            dispatchContext.setPossibleSlashStarMapping(false);
            dispatchContext.setPathElements(jsessionIndex == -1 ? uri : uri.substring(0, jsessionIndex), jsessionIndex == -1 ? null : uri.substring(jsessionIndex));
            return target;
        }
        if (this.defaultNode != null) {
            dispatchContext.setPossibleSlashStarMapping(true);
            Object starTarget = this.defaultNode.getStarTarget();
            if (SERVLET_PATH_FOR_DEFAULT_MAPPING && starTarget instanceof ServletWrapper && ((ServletWrapper)starTarget).isDefaultServlet()) {
                dispatchContext.setPathElements(uri, null);
            } else {
                dispatchContext.setPathElements("", uri);
            }
            return starTarget;
        }
        return null;
    }
}

