/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import com.ibm.jbatch.container.jsl.ModelResolver;
import com.ibm.jbatch.container.jsl.impl.JobModelHandler;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.xml.ParserFactory;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JobModelResolverImpl
implements ModelResolver<JSLJob> {
    private static final String sourceClass = JobModelResolverImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    static final long serialVersionUID = -7685380804949537102L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobModelResolverImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSLJob resolveModel(StreamSource source) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", "resolveModel", new Object[]{source});
        }
        JSLJob jSLJob = this.unmarshalJobXML(source);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jSLJob = jSLJob;
            logger.exiting("com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", "resolveModel", jSLJob);
        }
        return jSLJob;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private JSLJob unmarshalJobXML(StreamSource source) {
        JobModelHandler handler;
        JSLJob job;
        Object result;
        block13: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", "unmarshalJobXML", new Object[]{source});
            }
            result = null;
            job = null;
            InputStream is = null;
            handler = new JobModelHandler();
            SAXParserFactory factory = ParserFactory.newSAXParserFactory();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", (String)"72", (Object)this, (Object[])new Object[]{source});
                throw (UnsupportedOperationException)e;
            }
            try {
                is = source.getInputStream();
                final InputSource inputSource = is != null ? new InputSource(is) : new InputSource(source.getReader());
                logger.fine("JobModelResolver start unmarshal");
                final SAXParser parser = factory.newSAXParser();
                result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = 1133612939943182610L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() throws Exception {
                        parser.parse(inputSource, (DefaultHandler)handler);
                        return handler.ivHandler.getResult();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl$1", 1.class, (String)"wsbatch", null);
                    }
                });
                logger.fine("JobModelResolver JAXBContext obtained.");
                if (is == null) break block13;
            }
            catch (PrivilegedActionException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", (String)"97", (Object)this, (Object[])new Object[]{source});
                    throw new IllegalArgumentException("Exception unmarshalling jobXML", e.getCause());
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", (String)"99", (Object)this, (Object[])new Object[]{source});
                        throw new IllegalArgumentException("Exception unmarshalling jobXML", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        void e3;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", (String)"105", (Object)this, (Object[])new Object[]{source});
                        throw new IllegalArgumentException("Exception closing the Input Stream", (Throwable)e3);
                    }
                }
            }
            try {
                is.close();
            }
            catch (IOException inputSource) {
                void e;
                FFDCFilter.processException((Throwable)inputSource, (String)"com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", (String)"105", (Object)this, (Object[])new Object[]{source});
                throw new IllegalArgumentException("Exception closing the Input Stream", (Throwable)e);
            }
        }
        if (handler.validationHandler.eventOccurred()) {
            throw new IllegalArgumentException("JSL invalid per schema");
        }
        JSLJob jSLJob = job = (JSLJob)((JAXBElement)result).getValue();
        if (logger == null) return jSLJob;
        if (!logger.isLoggable(Level.FINER)) return jSLJob;
        jSLJob = jSLJob;
        logger.exiting("com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl", "unmarshalJobXML", jSLJob);
        return jSLJob;
    }
}

