/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.CompositeMember;
import org.eclipse.persistence.annotations.DeleteAll;
import org.eclipse.persistence.annotations.MapKeyConvert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OrderColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConvertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.MapKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.OrderByMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.mappings.converters.AttributeNameTokenizer;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class ElementCollectionAccessor
extends DirectCollectionAccessor
implements MappedKeyMapAccessor {
    private Boolean m_deleteAll;
    private ColumnMetadata m_column;
    private ColumnMetadata m_mapKeyColumn;
    private EnumeratedMetadata m_mapKeyEnumerated;
    private ForeignKeyMetadata m_mapKeyForeignKey;
    private List<ConvertMetadata> m_mapKeyConverts;
    private List<AssociationOverrideMetadata> m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AssociationOverrideMetadata> m_mapKeyAssociationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_mapKeyAttributeOverrides = new ArrayList<AttributeOverrideMetadata>();
    private List<JoinColumnMetadata> m_mapKeyJoinColumns = new ArrayList<JoinColumnMetadata>();
    private MapKeyMetadata m_mapKey;
    private MetadataClass m_targetClass;
    private MetadataClass m_mapKeyClass;
    private MetadataClass m_referenceClass;
    private OrderByMetadata m_orderBy;
    private OrderColumnMetadata m_orderColumn;
    private String m_mapKeyConvert;
    private String m_mapKeyClassName;
    private String m_targetClassName;
    private String m_compositeMember;
    private TemporalMetadata m_mapKeyTemporal;

    public ElementCollectionAccessor() {
        super("<element-collection>");
    }

    public ElementCollectionAccessor(MetadataAnnotation elementCollection, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(elementCollection, accessibleObject, classAccessor);
        this.m_targetClass = this.getMetadataClass(elementCollection.getAttributeString("targetClass"));
        if (this.isAnnotationPresent("jakarta.persistence.AttributeOverrides")) {
            for (Object attributeOverride : this.getAnnotation("jakarta.persistence.AttributeOverrides").getAttributeArray("value")) {
                this.addAttributeOverride(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride, this));
            }
        }
        if (this.isAnnotationPresent("jakarta.persistence.AttributeOverride")) {
            this.addAttributeOverride(new AttributeOverrideMetadata(this.getAnnotation("jakarta.persistence.AttributeOverride"), this));
        }
        if (this.isAnnotationPresent("jakarta.persistence.AssociationOverrides")) {
            for (Object associationOverride : this.getAnnotation("jakarta.persistence.AssociationOverrides").getAttributeArray("value")) {
                this.addAssociationOverride(new AssociationOverrideMetadata((MetadataAnnotation)associationOverride, this));
            }
        }
        if (this.isAnnotationPresent("jakarta.persistence.AssociationOverride")) {
            this.addAssociationOverride(new AssociationOverrideMetadata(this.getAnnotation("jakarta.persistence.AssociationOverride"), this));
        }
        if (this.isAnnotationPresent("jakarta.persistence.Column")) {
            this.m_column = new ColumnMetadata(this.getAnnotation("jakarta.persistence.Column"), this);
        }
        if (this.isAnnotationPresent("jakarta.persistence.CollectionTable")) {
            this.setCollectionTable(new CollectionTableMetadata(this.getAnnotation("jakarta.persistence.CollectionTable"), this));
        }
        if (this.isAnnotationPresent(CompositeMember.class)) {
            this.m_compositeMember = this.getAnnotation(CompositeMember.class).getAttributeString("value");
        }
        if (this.isAnnotationPresent("jakarta.persistence.OrderBy")) {
            this.m_orderBy = new OrderByMetadata(this.getAnnotation("jakarta.persistence.OrderBy"), this);
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapKey")) {
            this.m_mapKey = new MapKeyMetadata(this.getAnnotation("jakarta.persistence.MapKey"), this);
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapKeyClass")) {
            this.m_mapKeyClass = this.getMetadataClass(this.getAnnotation("jakarta.persistence.MapKeyClass").getAttributeString("value"));
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapKeyEnumerated")) {
            this.m_mapKeyEnumerated = new EnumeratedMetadata(this.getAnnotation("jakarta.persistence.MapKeyEnumerated"), this);
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapKeyTemporal")) {
            this.m_mapKeyTemporal = new TemporalMetadata(this.getAnnotation("jakarta.persistence.MapKeyTemporal"), this);
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapKeyJoinColumns")) {
            MetadataAnnotation mapKeyJoinColumns = this.getAnnotation("jakarta.persistence.MapKeyJoinColumns");
            for (Object mapKeyJoinColumn : mapKeyJoinColumns.getAttributeArray("value")) {
                this.m_mapKeyJoinColumns.add(new JoinColumnMetadata((MetadataAnnotation)mapKeyJoinColumn, this));
            }
            if (mapKeyJoinColumns.hasAttribute("foreignKey")) {
                this.setMapKeyForeignKey(new ForeignKeyMetadata(mapKeyJoinColumns.getAttributeAnnotation("foreignKey"), this));
            }
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapKeyJoinColumn")) {
            JoinColumnMetadata mapKeyJoinColumn = new JoinColumnMetadata(this.getAnnotation("jakarta.persistence.MapKeyJoinColumn"), this);
            this.m_mapKeyJoinColumns.add(mapKeyJoinColumn);
            this.setMapKeyForeignKey(mapKeyJoinColumn.getForeignKey());
        }
        if (this.isAnnotationPresent("jakarta.persistence.MapKeyColumn")) {
            this.m_mapKeyColumn = new ColumnMetadata(this.getAnnotation("jakarta.persistence.MapKeyColumn"), this);
        }
        if (this.isAnnotationPresent(MapKeyConvert.class)) {
            this.m_mapKeyConvert = this.getAnnotation(MapKeyConvert.class).getAttributeString("value");
        }
        if (this.isAnnotationPresent("jakarta.persistence.OrderColumn")) {
            this.m_orderColumn = new OrderColumnMetadata(this.getAnnotation("jakarta.persistence.OrderColumn"), this);
        }
        if (this.isAnnotationPresent(DeleteAll.class)) {
            this.m_deleteAll = Boolean.TRUE;
        }
    }

    protected void addAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (attributeOverride.getName().startsWith(KEY_DOT_NOTATION)) {
            attributeOverride.setName(attributeOverride.getName().substring(KEY_DOT_NOTATION.length()));
            this.m_mapKeyAttributeOverrides.add(attributeOverride);
        } else {
            if (attributeOverride.getName().startsWith(VALUE_DOT_NOTATION)) {
                attributeOverride.setName(attributeOverride.getName().substring(VALUE_DOT_NOTATION.length()));
            }
            this.m_attributeOverrides.add(attributeOverride);
        }
    }

    protected void addAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (associationOverride.getName().startsWith(KEY_DOT_NOTATION)) {
            associationOverride.setName(associationOverride.getName().substring(KEY_DOT_NOTATION.length()));
            this.m_mapKeyAssociationOverrides.add(associationOverride);
        } else {
            if (associationOverride.getName().startsWith(VALUE_DOT_NOTATION)) {
                associationOverride.setName(associationOverride.getName().substring(VALUE_DOT_NOTATION.length()));
            }
            this.m_associationOverrides.add(associationOverride);
        }
    }

    @Override
    public void addMapKeyConvert(ConvertMetadata convert) {
        if (this.m_mapKeyConverts == null) {
            this.m_mapKeyConverts = new ArrayList<ConvertMetadata>();
        }
        this.m_mapKeyConverts.add(convert);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ElementCollectionAccessor) {
            ElementCollectionAccessor elementCollectionAccessor = (ElementCollectionAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_deleteAll, elementCollectionAccessor.getDeleteAll())) {
                return false;
            }
            if (!this.valuesMatch(this.m_column, elementCollectionAccessor.getColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_compositeMember, elementCollectionAccessor.getCompositeMember())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyColumn, elementCollectionAccessor.getMapKeyColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyEnumerated, elementCollectionAccessor.getMapKeyEnumerated())) {
                return false;
            }
            if (!this.valuesMatch(this.m_associationOverrides, elementCollectionAccessor.getAssociationOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAssociationOverrides, elementCollectionAccessor.getMapKeyAssociationOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_attributeOverrides, elementCollectionAccessor.getAttributeOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAttributeOverrides, elementCollectionAccessor.getMapKeyAttributeOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyJoinColumns, elementCollectionAccessor.getMapKeyJoinColumns())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyForeignKey, elementCollectionAccessor.getMapKeyForeignKey())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKey, elementCollectionAccessor.getMapKey())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderBy, elementCollectionAccessor.getOrderBy())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderColumn, elementCollectionAccessor.getOrderColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyConverts, elementCollectionAccessor.getMapKeyConverts())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyClassName, elementCollectionAccessor.getMapKeyClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_targetClassName, elementCollectionAccessor.getTargetClassName())) {
                return false;
            }
            return this.valuesMatch(this.m_mapKeyTemporal, elementCollectionAccessor.getMapKeyTemporal());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_deleteAll != null ? this.m_deleteAll.hashCode() : 0);
        result = 31 * result + (this.m_column != null ? this.m_column.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyColumn != null ? this.m_mapKeyColumn.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyEnumerated != null ? this.m_mapKeyEnumerated.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyForeignKey != null ? this.m_mapKeyForeignKey.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyConverts != null ? this.m_mapKeyConverts.hashCode() : 0);
        result = 31 * result + (this.m_associationOverrides != null ? this.m_associationOverrides.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyAssociationOverrides != null ? this.m_mapKeyAssociationOverrides.hashCode() : 0);
        result = 31 * result + (this.m_attributeOverrides != null ? this.m_attributeOverrides.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyAttributeOverrides != null ? this.m_mapKeyAttributeOverrides.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyJoinColumns != null ? this.m_mapKeyJoinColumns.hashCode() : 0);
        result = 31 * result + (this.m_mapKey != null ? this.m_mapKey.hashCode() : 0);
        result = 31 * result + (this.m_orderBy != null ? this.m_orderBy.hashCode() : 0);
        result = 31 * result + (this.m_orderColumn != null ? this.m_orderColumn.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyClassName != null ? this.m_mapKeyClassName.hashCode() : 0);
        result = 31 * result + (this.m_targetClassName != null ? this.m_targetClassName.hashCode() : 0);
        result = 31 * result + (this.m_compositeMember != null ? this.m_compositeMember.hashCode() : 0);
        result = 31 * result + (this.m_mapKeyTemporal != null ? this.m_mapKeyTemporal.hashCode() : 0);
        return result;
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    public String getCompositeMember() {
        return this.m_compositeMember;
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_value_column")) {
            return this.m_column == null ? super.getColumn(loggingCtx) : this.m_column;
        }
        return this.m_mapKeyColumn == null ? super.getColumn(loggingCtx) : this.m_mapKeyColumn;
    }

    @Override
    protected DatabaseTable getDefaultTableForEntityMapKey() {
        return this.getCollectionTable().getDatabaseTable();
    }

    public Boolean getDeleteAll() {
        return this.m_deleteAll;
    }

    public EmbeddableAccessor getEmbeddableAccessor() {
        return this.getProject().getEmbeddableAccessor(this.getReferenceClass());
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        if (isForMapKey) {
            return this.getMapKeyEnumerated();
        }
        return super.getEnumerated(isForMapKey);
    }

    @Override
    protected String getKeyConverter() {
        return this.m_mapKeyConvert;
    }

    @Override
    public MapKeyMetadata getMapKey() {
        return this.m_mapKey;
    }

    @Override
    public MetadataClass getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    @Override
    public MetadataClass getMapKeyClassWithGenerics() {
        return this.getMapKeyClass();
    }

    @Override
    public List<AssociationOverrideMetadata> getMapKeyAssociationOverrides() {
        return this.m_mapKeyAssociationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.m_mapKeyAttributeOverrides;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    @Override
    public String getMapKeyConvert() {
        return this.m_mapKeyConvert;
    }

    @Override
    public List<ConvertMetadata> getMapKeyConverts() {
        return this.m_mapKeyConverts;
    }

    public EnumeratedMetadata getMapKeyEnumerated() {
        return this.m_mapKeyEnumerated;
    }

    @Override
    public ForeignKeyMetadata getMapKeyForeignKey() {
        return this.m_mapKeyForeignKey;
    }

    @Override
    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public TemporalMetadata getMapKeyTemporal() {
        return this.m_mapKeyTemporal;
    }

    public OrderByMetadata getOrderBy() {
        return this.m_orderBy;
    }

    public OrderColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetClass();
            if (this.m_referenceClass == null || this.m_referenceClass.isVoid()) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    if (this.getClassAccessor().isMappedSuperclass()) {
                        return this.getMetadataClass(Void.class);
                    }
                    throw ValidationException.unableToDetermineTargetClass(this.getAttributeName(), this.getJavaClass());
                }
                this.getLogger().logConfigMessage("metadata_default_element_collection_reference_class", this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        if (this.isDirectEmbeddableCollection()) {
            return this.getEmbeddableAccessor().getDescriptor();
        }
        return super.getReferenceDescriptor();
    }

    protected MetadataClass getTargetClass() {
        return this.m_targetClass;
    }

    protected String getTargetClassName() {
        return this.m_targetClassName;
    }

    @Override
    public TemporalMetadata getTemporal(boolean isForMapKey) {
        if (isForMapKey) {
            return this.getMapKeyTemporal();
        }
        return super.getTemporal(isForMapKey);
    }

    @Override
    public boolean hasEnumerated(boolean isForMapKey) {
        if (isForMapKey) {
            return this.m_mapKeyEnumerated != null;
        }
        return super.hasEnumerated(isForMapKey);
    }

    @Override
    public boolean hasLob(boolean isForMapKey) {
        if (isForMapKey) {
            return false;
        }
        return super.hasLob(isForMapKey);
    }

    @Override
    public boolean hasMapKey() {
        return this.m_mapKey != null;
    }

    @Override
    protected boolean hasMapKeyClass() {
        return this.m_mapKeyClass != null && !this.m_mapKeyClass.isClass(Void.TYPE);
    }

    @Override
    public boolean hasTemporal(boolean isForMapKey) {
        if (isForMapKey) {
            return this.m_mapKeyTemporal != null;
        }
        return super.hasTemporal(isForMapKey);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_associationOverrides, accessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAssociationOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAttributeOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyConverts, accessibleObject);
        this.initXMLObjects(this.m_mapKeyJoinColumns, accessibleObject);
        this.initXMLObject(this.m_column, accessibleObject);
        this.initXMLObject(this.m_mapKey, accessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, accessibleObject);
        this.initXMLObject(this.m_orderBy, accessibleObject);
        this.initXMLObject(this.m_orderColumn, accessibleObject);
        this.initXMLObject(this.m_mapKeyForeignKey, accessibleObject);
        this.initXMLObject(this.m_mapKeyEnumerated, accessibleObject);
        this.initXMLObject(this.m_mapKeyTemporal, accessibleObject);
        this.m_targetClass = this.initXMLClassName(this.m_targetClassName);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
        this.m_mapKeyConvert = this.initXMLTextObject(this.m_mapKeyConverts);
    }

    public boolean isDeleteAll() {
        return this.m_deleteAll != null && this.m_deleteAll != false;
    }

    @Override
    public boolean isDirectEmbeddableCollection() {
        return this.getEmbeddableAccessor() != null;
    }

    @Override
    public void process() {
        if (this.isDirectEmbeddableCollection()) {
            this.processDirectEmbeddableCollectionMapping(this.getReferenceDescriptor());
        } else if (this.isValidDirectCollectionType()) {
            this.processDirectCollectionMapping();
            if (this.m_compositeMember != null) {
                ((CollectionMapping)this.getMapping()).setSessionName(this.m_compositeMember);
            }
        } else if (this.isValidDirectMapType()) {
            this.processDirectMapMapping();
            if (this.m_compositeMember != null) {
                ((CollectionMapping)this.getMapping()).setSessionName(this.m_compositeMember);
            }
        } else {
            throw ValidationException.invalidTargetClass(this.getAttributeName(), this.getJavaClass());
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.process((CollectionMapping)this.getMapping(), this.getReferenceDescriptor(), this.getJavaClass());
        }
        if (this.m_orderColumn != null) {
            this.m_orderColumn.process((CollectionMapping)this.getMapping(), this.getDescriptor());
        }
    }

    @Override
    protected void processCollectionTable(CollectionMapping mapping) {
        super.processCollectionTable(mapping);
        for (JoinColumnMetadata joinColumn : this.getJoinColumnsAndValidate(this.getCollectionTable().getJoinColumns(), this.getOwningDescriptor())) {
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), this.getOwningDescriptor(), "metadata_default_pk_column", mapping.isAggregateCollectionMapping());
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            this.setFieldName(fkField, this.getOwningDescriptor().getAlias() + "_" + this.getOwningDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column");
            fkField.setTable(this.getReferenceDatabaseTable());
            if (mapping.isDirectCollectionMapping()) {
                ((DirectCollectionMapping)mapping).addReferenceKeyField(fkField, pkField);
                continue;
            }
            mapping.addTargetForeignKeyField(fkField, pkField);
        }
        if (this.m_deleteAll != null && mapping.isPrivateOwned()) {
            mapping.setMustDeleteReferenceObjectsOneByOne(this.m_deleteAll == false);
        }
    }

    protected void processDirectEmbeddableCollectionMapping(MetadataDescriptor referenceDescriptor) {
        DatabaseMapping mapping = this.getOwningDescriptor().getClassDescriptor().newAggregateCollectionMapping();
        this.process(mapping);
        referenceDescriptor.setIsEmbeddable();
        this.processContainerPolicyAndIndirection((ContainerMapping)((Object)mapping));
        if (mapping instanceof AggregateCollectionMapping) {
            AggregateCollectionMapping collectionMapping = (AggregateCollectionMapping)mapping;
            this.processMappingsFromEmbeddable(referenceDescriptor, null, collectionMapping, this.getAttributeOverrides(this.m_attributeOverrides), this.getAssociationOverrides(this.m_associationOverrides), "");
            this.processMappingValueConverters(this.getDescriptor());
        } else if (mapping.isAbstractCompositeCollectionMapping()) {
            ((AbstractCompositeCollectionMapping)mapping).setField(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column"));
        }
    }

    protected void processMappingValueConverters(MetadataDescriptor embeddableDescriptor) {
        for (ConvertMetadata convert : this.getConverts()) {
            String attributeName = AttributeNameTokenizer.getNameAfterVersion(convert.getAttributeName());
            MappingAccessor mappingAccessor = attributeName != null ? embeddableDescriptor.getMappingAccessor(attributeName) : null;
            if (mappingAccessor == null) continue;
            convert.process(this.getMapping(), this.getReferenceClass(), this.getClassAccessor(), attributeName);
        }
    }

    protected void processMappingsFromEmbeddable(MetadataDescriptor embeddableDescriptor, AggregateObjectMapping nestedAggregateObjectMapping, EmbeddableMapping embeddableMapping, Map<String, AttributeOverrideMetadata> attributeOverrides, Map<String, AssociationOverrideMetadata> associationOverrides, String dotNotationName) {
        for (MappingAccessor mappingAccessor : embeddableDescriptor.getMappingAccessors()) {
            String overrideName;
            if (mappingAccessor.isTransient()) continue;
            if (!mappingAccessor.isProcessed()) {
                mappingAccessor.process();
            }
            DatabaseMapping mapping = mappingAccessor.getMapping();
            String string = overrideName = dotNotationName.equals("") ? mapping.getAttributeName() : dotNotationName + "." + mapping.getAttributeName();
            if (mapping.isDirectToFieldMapping()) {
                DatabaseField overrideField;
                AbstractDirectMapping directMapping = (AbstractDirectMapping)mapping;
                if (attributeOverrides.containsKey(overrideName)) {
                    overrideField = attributeOverrides.get(overrideName).getOverrideField();
                } else {
                    overrideField = directMapping.getField().clone();
                    if (nestedAggregateObjectMapping != null && nestedAggregateObjectMapping.getAggregateToSourceFields().containsKey(overrideField.getName())) {
                        overrideField = nestedAggregateObjectMapping.getAggregateToSourceFields().get(overrideField.getName());
                    }
                }
                if (!overrideField.hasTableName()) {
                    overrideField.setTable(this.getReferenceDatabaseTable());
                }
                this.addFieldNameTranslation(embeddableMapping, overrideName, overrideField, mappingAccessor);
                continue;
            }
            if (mapping.isOneToOneMapping()) {
                OneToOneMapping oneToOneMapping = (OneToOneMapping)mapping;
                if (oneToOneMapping.isForeignKeyRelationship()) {
                    AssociationOverrideMetadata associationOverride = associationOverrides.get(overrideName);
                    if (associationOverride == null) {
                        for (DatabaseField fkField : oneToOneMapping.getForeignKeyFields()) {
                            DatabaseField collectionTableField = fkField.clone();
                            collectionTableField.setTable(this.getReferenceDatabaseTable());
                            embeddableMapping.addFieldTranslation(collectionTableField, fkField.getName());
                        }
                        continue;
                    }
                    ((ObjectAccessor)mappingAccessor).processAssociationOverride(associationOverride, embeddableMapping, this.getReferenceDatabaseTable(), this.getDescriptor());
                    continue;
                }
                throw ValidationException.invalidEmbeddableClassForElementCollection(embeddableDescriptor.getJavaClass(), this.getAttributeName(), this.getJavaClass(), mapping.getAttributeName());
            }
            if (mapping.isAggregateObjectMapping()) {
                MappingAccessor accessor = embeddableDescriptor.getMappingAccessor(mapping.getAttributeName());
                this.processMappingsFromEmbeddable(accessor.getReferenceDescriptor(), (AggregateObjectMapping)mapping, embeddableMapping, attributeOverrides, associationOverrides, overrideName);
                continue;
            }
            throw ValidationException.invalidEmbeddableClassForElementCollection(embeddableDescriptor.getJavaClass(), this.getAttributeName(), this.getJavaClass(), mapping.getAttributeName());
        }
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setCompositeMember(String compositeMember) {
        this.m_compositeMember = compositeMember;
    }

    public void setDeleteAll(Boolean deleteAll) {
        this.m_deleteAll = deleteAll;
    }

    public void setMapKey(MapKeyMetadata mapKey) {
        this.m_mapKey = mapKey;
    }

    public void setMapKeyAssociationOverrides(List<AssociationOverrideMetadata> mapKeyAssociationOverrides) {
        this.m_mapKeyAssociationOverrides = mapKeyAssociationOverrides;
    }

    public void setMapKeyAttributeOverrides(List<AttributeOverrideMetadata> mapKeyAttributeOverrides) {
        this.m_mapKeyAttributeOverrides = mapKeyAttributeOverrides;
    }

    @Override
    public void setMapKeyClass(MetadataClass mapKeyClass) {
        this.m_mapKeyClass = mapKeyClass;
    }

    public void setMapKeyClassName(String mapKeyClassName) {
        this.m_mapKeyClassName = mapKeyClassName;
    }

    public void setMapKeyColumn(ColumnMetadata mapKeyColumn) {
        this.m_mapKeyColumn = mapKeyColumn;
    }

    public void setMapKeyConverts(List<ConvertMetadata> mapKeyConverts) {
        this.m_mapKeyConverts = mapKeyConverts;
    }

    public void setMapKeyEnumerated(EnumeratedMetadata mapKeyEnumerated) {
        this.m_mapKeyEnumerated = mapKeyEnumerated;
    }

    public void setMapKeyForeignKey(ForeignKeyMetadata mapKeyForeignKey) {
        this.m_mapKeyForeignKey = mapKeyForeignKey;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> mapKeyJoinColumns) {
        this.m_mapKeyJoinColumns = mapKeyJoinColumns;
    }

    public void setMapKeyTemporal(TemporalMetadata mapKeyTemporal) {
        this.m_mapKeyTemporal = mapKeyTemporal;
    }

    @Override
    public void setTemporal(TemporalMetadata metadata, boolean isForMapKey) {
        if (isForMapKey) {
            this.setMapKeyTemporal(metadata);
        }
    }

    public void setOrderBy(OrderByMetadata orderBy) {
        this.m_orderBy = orderBy;
    }

    public void setOrderColumn(OrderColumnMetadata orderColumn) {
        this.m_orderColumn = orderColumn;
    }

    public void setTargetClassName(String targetClassName) {
        this.m_targetClassName = targetClassName;
    }
}

