/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.rofl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.util.Collectors;
import org.apache.yoko.util.HexConverter;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;

public interface Rofl
extends Serializable {
    public static final Rofl NONE = new None();

    public RemoteOrb type();

    public static final class None
    implements Rofl {
        @Override
        public RemoteOrb type() {
            return RemoteOrb.NO_DATA;
        }

        public String toString() {
            return "NONE";
        }
    }

    public static final class Bad
    implements Rofl {
        private static final long serialVersionUID = 1L;
        final SourceType sourceType;
        final int id;
        final byte[] data;
        final Throwable cause;

        Bad(ServiceContext sc, Throwable cause) {
            this.sourceType = SourceType.SERVICE_CONTEXT;
            this.id = sc.context_id;
            this.data = sc.context_data == null ? null : Arrays.copyOf(sc.context_data, sc.context_data.length);
            this.cause = cause;
        }

        Bad(TaggedComponent tc, Throwable cause) {
            this.sourceType = SourceType.TAGGED_COMPONENT;
            this.id = tc.tag;
            this.data = tc.component_data == null ? null : Arrays.copyOf(tc.component_data, tc.component_data.length);
            this.cause = cause;
        }

        @Override
        public RemoteOrb type() {
            return RemoteOrb.BAD;
        }

        public String toString() {
            return String.format("UNKNOWN ORB[%s(0x%08x) data=%s cause=%s]", new Object[]{this.sourceType, this.id, HexConverter.octetsToAscii(this.data), this.cause});
        }
    }

    public static final class IbmPartnerVersion
    implements Rofl {
        private static final long serialVersionUID = 1L;
        public final SourceType sourceType;
        public final short major;
        public final short minor;
        public final short extended;

        IbmPartnerVersion(ServiceContext sc) {
            this(SourceType.SERVICE_CONTEXT, sc.context_data);
        }

        IbmPartnerVersion(TaggedComponent tc) {
            this(SourceType.TAGGED_COMPONENT, tc.component_data);
        }

        private IbmPartnerVersion(SourceType sourceType, byte[] data) {
            this.sourceType = sourceType;
            if (data.length != 8) {
                this.extended = (short)-1;
                this.minor = (short)-1;
                this.major = (short)-1;
                return;
            }
            int i = 0;
            ++i;
            int n = ++i;
            int n2 = ++i;
            this.extended = (short)((data[n] & 0xFF) << 8 | data[n2] & 0xFF);
            int n3 = ++i;
            int n4 = ++i;
            this.major = (short)((data[n3] & 0xFF) << 8 | data[n4] & 0xFF);
            int n5 = ++i;
            int n6 = ++i;
            ++i;
            this.minor = (short)((data[n5] & 0xFF) << 8 | data[n6] & 0xFF);
        }

        @Override
        public RemoteOrb type() {
            return RemoteOrb.IBM;
        }

        public String toString() {
            return String.format("IBM JAVA ORB[major=%04X minor=%04x, extended=%04X]", this.major, this.minor, this.extended);
        }
    }

    public static enum SourceType {
        SERVICE_CONTEXT,
        TAGGED_COMPONENT;

    }

    public static enum RemoteOrb {
        IBM(1229081866, IbmPartnerVersion::new, 1229081874, IbmPartnerVersion::new),
        BAD,
        NO_DATA;

        private static final EnumSet<RemoteOrb> SPECIAL_REMOTE_ORBS;
        public static final EnumSet<RemoteOrb> KNOWN_REMOTE_ORBS;
        private static final Map<Integer, RemoteOrb> SC_ID_TO_RO_MAP;
        public final Integer tagComponentId;
        public final Integer serviceContextId;
        private final Function<TaggedComponent, Rofl> tcCtor;
        private final Function<ServiceContext, Rofl> scCtor;

        private RemoteOrb() {
            this(null, null, null, null);
        }

        private RemoteOrb(Integer tagComponentId, Function<TaggedComponent, Rofl> tcCtor, Integer serviceContextId, Function<ServiceContext, Rofl> scCtor) {
            this.tagComponentId = tagComponentId;
            this.serviceContextId = serviceContextId;
            this.tcCtor = tcCtor;
            this.scCtor = scCtor;
        }

        Rofl createRofl(TaggedComponent tc) {
            try {
                return this.tcCtor.apply(tc);
            }
            catch (Throwable t) {
                Logger.getLogger(Rofl.class.getName() + "." + this.name()).log(Level.WARNING, "Failed to create ROFL for remote ORB of type " + (Object)((Object)this), t);
                return new Bad(tc, t);
            }
        }

        Rofl createRofl(ServiceContext sc) {
            try {
                return this.scCtor.apply(sc);
            }
            catch (Throwable t) {
                Logger.getLogger(Rofl.class.getName() + "." + this.name()).log(Level.WARNING, "Failed to create ROFL for remote ORB of type " + (Object)((Object)this), t);
                return new Bad(sc, t);
            }
        }

        static Optional<RemoteOrb> of(ServiceContext sc) {
            return Optional.of(sc.context_id).map(SC_ID_TO_RO_MAP::get);
        }

        static {
            SPECIAL_REMOTE_ORBS = EnumSet.of(BAD, NO_DATA);
            KNOWN_REMOTE_ORBS = EnumSet.complementOf(SPECIAL_REMOTE_ORBS);
            SC_ID_TO_RO_MAP = KNOWN_REMOTE_ORBS.stream().collect(Collectors.toUnmodifiableMap(HashMap::new, ro -> ro.serviceContextId));
        }
    }
}

