/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ExtendedDocumentBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(ExtendedDocumentBuilder.class);
    private DocumentBuilderFactory parserFactory;
    private SchemaFactory schemaFactory;
    private Schema schema;

    private InputStream getSchemaLocation() {
        String toolspec = "/org/apache/cxf/tools/common/toolspec/tool-specification.xsd";
        return this.getClass().getResourceAsStream(toolspec);
    }

    public void setValidating(boolean validate) {
        if (validate) {
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                this.schema = this.schemaFactory.newSchema(new StreamSource(this.getSchemaLocation()));
            }
            catch (SAXException e) {
                LOG.log(Level.SEVERE, "SCHEMA_FACTORY_EXCEPTION_MSG");
            }
            try {
                this.parserFactory = DocumentBuilderFactory.newInstance();
                try {
                    this.parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                }
                catch (ParserConfigurationException e) {
                    // empty catch block
                }
                this.parserFactory.setNamespaceAware(true);
                this.parserFactory.setSchema(this.schema);
            }
            catch (UnsupportedOperationException e) {
                LOG.log(Level.WARNING, "DOC_PARSER_NOT_SUPPORTED", e);
            }
        }
    }

    public Document parse(InputStream in) throws SAXException, IOException, XMLStreamException {
        if (in == null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("ExtendedDocumentBuilder trying to parse a null inputstream");
        }
        if (this.parserFactory != null) {
            try {
                return this.parserFactory.newDocumentBuilder().parse(in);
            }
            catch (ParserConfigurationException e) {
                LOG.log(Level.SEVERE, "NEW_DOCUMENT_BUILDER_EXCEPTION_MSG");
            }
        }
        return StaxUtils.read(in);
    }
}

