/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.FilterErrorListener;
import com.ibm.websphere.servlet.event.FilterInvocationListener;
import com.ibm.websphere.servlet.event.FilterListener;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.websphere.servlet.response.ResponseUtils;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.webext.WebExt;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.PlatformHelper;
import com.ibm.ws.webcontainer.SessionRegistry;
import com.ibm.ws.webcontainer.VirtualHost;
import com.ibm.ws.webcontainer.WebContainerConfiguration;
import com.ibm.ws.webcontainer.async.AsyncContextFactory;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.exception.WebAppHostNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHost;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapper;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapperFactory;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.spi.servlet.http.IHttpServletResponseListener;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.ws.webcontainer.util.VirtualHostMapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.IPlatformHelper;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import com.ibm.wsspi.webcontainer.util.URIMatcherFactory;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

public abstract class WebContainer
extends BaseContainer {
    protected static final String ISO = "ISO-8859-1";
    protected String encoding = null;
    protected boolean decode = true;
    protected WebContainerConfiguration wcconfig;
    protected static List applicationListeners = new ArrayList();
    protected static List servletListeners = new ArrayList();
    protected static List servletErrorListeners = new ArrayList();
    protected static List servletInvocationListeners = new ArrayList();
    protected static List filterInvocationListeners = new ArrayList();
    protected static List filterErrorListeners = new ArrayList();
    protected static List filterListeners = new ArrayList();
    private static List servletRequestListeners = new ArrayList();
    private static List servletRequestAttributeListeners = new ArrayList();
    private static List servletContextListeners = new ArrayList();
    private static List servletContextAttributeListeners = new ArrayList();
    private static List sessionListeners = new ArrayList();
    private static List sessionIdListeners = new ArrayList();
    private static List sessionAttributeListeners = new ArrayList();
    public static final String DEFAULT_HOST = "default_host";
    protected static boolean _initialized;
    protected static Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.internal.WebContainer";
    private static TraceNLS nls;
    protected static final AtomicReference<WebContainer> self;
    protected static volatile CountDownLatch selfInit;
    private HashMap _cipherToBit = new HashMap();
    private static WSThreadLocal cacheKeyStringBuilder;
    private static boolean listenersInitialized;
    protected static Properties webConProperties;
    protected SessionRegistry sessionRegistry;
    protected boolean isStopped = false;
    protected ReentrantReadWriteLock readWriteLockForStopping = new ReentrantReadWriteLock();
    public static final String urlPrefix = ";jsessionid=";
    public static List<ExtensionFactory> extensionFactories;
    public static List<ExtensionFactory> postInitExtensionFactories;
    private static ArrayList httpResponseListeners;
    private static ServiceLoader<ServletContainerInitializer> servletContainerInitializers;
    protected AuditManager auditManager;
    private static int invocationCacheSize;
    protected static final ConcurrentMap _cacheMap;
    private static final AtomicInteger _cacheSize;
    protected boolean vHostCompatFlag = true;
    protected IPlatformHelper platformHelper;
    private static boolean isDefaultTempDir;
    private static String tempDir;
    private static boolean servletCachingInitNeeded;
    public static boolean appInstallBegun;
    protected static CacheServletWrapperFactory cacheServletWrapperFactory;
    public static boolean isServlet60orAbove;

    protected WebContainer(String name, Container parent) {
        super(name, parent);
        this.requestMapper = new VirtualHostMapper();
    }

    public void initialize(WebContainerConfiguration config) {
        this.wcconfig = config;
        this.auditManager = new AuditManager();
        this.getURIEncoding();
        _initialized = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initialize", "Web Container invocationCache --> [" + invocationCacheSize + "]");
        }
        webConProperties = new Properties();
        isServlet60orAbove = com.ibm.ws.webcontainer.osgi.WebContainer.isServletLevel60orAbove();
    }

    private static void registerGlobalWebAppListeners() {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "registerGlobalWebAppListeners");
        }
        String classes = WCCustomProperties.LISTENERS;
        String classname = null;
        if (classes != null) {
            StringTokenizer st = new StringTokenizer(classes, ",");
            while (st.hasMoreElements()) {
                try {
                    classname = st.nextToken().trim();
                    WebContainer.addGlobalListener(classname);
                }
                catch (Throwable th) {
                    FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.internal.WebContainer.registerGlobalWebAppListeners", "785", WebContainer.getWebContainer());
                }
            }
        }
        listenersInitialized = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "registerGlobalWebAppListeners");
        }
    }

    public static void addGlobalListener(String classname) {
        block21: {
            Object listener;
            if (logger.isLoggable(Level.FINE)) {
                logger.entering(CLASS_NAME, "addGlobalListener");
                logger.logp(Level.FINE, CLASS_NAME, "addGlobalListener", "classname->" + classname);
            }
            if ((listener = WebContainer.loadListener(classname)) != null) {
                if (listener instanceof ApplicationListener) {
                    applicationListeners.add(listener);
                }
                if (listener instanceof ServletListener) {
                    servletListeners.add(listener);
                }
                if (listener instanceof ServletErrorListener) {
                    servletErrorListeners.add(listener);
                }
                if (listener instanceof ServletInvocationListener) {
                    servletInvocationListeners.add(listener);
                }
                if (listener instanceof FilterInvocationListener) {
                    filterInvocationListeners.add(listener);
                }
                if (listener instanceof FilterListener) {
                    filterListeners.add(listener);
                }
                if (listener instanceof FilterErrorListener) {
                    filterErrorListeners.add(listener);
                }
                if (listener instanceof ServletContextAttributeListener) {
                    servletContextAttributeListeners.add(listener);
                }
                if (listener instanceof ServletContextListener) {
                    servletContextListeners.add(listener);
                }
                if (listener instanceof ServletRequestAttributeListener) {
                    servletRequestAttributeListeners.add(listener);
                }
                if (listener instanceof ServletRequestListener) {
                    servletRequestListeners.add(listener);
                }
                if (listener instanceof HttpSessionListener) {
                    sessionListeners.add(listener);
                }
                if (listener instanceof HttpSessionAttributeListener) {
                    sessionAttributeListeners.add(listener);
                }
                if (com.ibm.ws.webcontainer.osgi.WebContainer.getServletContainerSpecLevel() >= 31) {
                    try {
                        if (Class.forName("javax.servlet.http.HttpSessionIdListener").isInstance(listener)) {
                            sessionIdListeners.add(listener);
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "addGlobalListener", "Adding the following HttpSessionIdListener: " + listener.toString());
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block21;
                        logger.logp(Level.FINE, CLASS_NAME, "addGlobalListener", "javax.servlet.http.HttpSessionIdListener was expected to be found but was not.");
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addGlobalListener");
        }
    }

    private static Object loadListener(String lClassName) {
        Object listener = null;
        try {
            listener = Beans.instantiate(ThreadContextHelper.getContextClassLoader(), lClassName);
        }
        catch (IOException io) {
            FFDCWrapper.processException(io, "com.ibm.ws.webcontainer.internal.WebContainer.loadListener", "1523", WebContainer.getWebContainer());
        }
        catch (ClassNotFoundException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.internal.WebContainer.loadListener", "1527", WebContainer.getWebContainer());
        }
        catch (ClassCastException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.internal.WebContainer.loadListener", "1531", WebContainer.getWebContainer());
        }
        catch (NoClassDefFoundError e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.internal.WebContainer.loadListener", "1535", WebContainer.getWebContainer());
        }
        catch (ClassFormatError e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.internal.WebContainer.loadListener", "1539", WebContainer.getWebContainer());
        }
        return listener;
    }

    protected void loadCipherToBit() {
        boolean keySizeFromCipherMap = Boolean.parseBoolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.keysizefromciphermap", "true"));
        if (keySizeFromCipherMap) {
            this.getKeySizefromCipherMap("toLoad");
        } else {
            Properties cipherToBitProps = new Properties();
            try {
                String fileName = System.getProperty("server.root") + File.separator + "properties" + File.separator + "sslbitsizes.properties";
                cipherToBitProps.load(new FileInputStream(fileName));
            }
            catch (Exception ex) {
                logger.logp(Level.SEVERE, CLASS_NAME, "loadCipherToBit", "failed.to.load.sslbitsizes.properties ", ex);
                FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.internal.WebContainer.loadCipherToBit", "825", this);
            }
            this._cipherToBit.putAll(cipherToBitProps);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.requestMapper = null;
        if (!WebContainer.isDefaultTempDir()) {
            File f;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "destroy", "deleting tempDirectory");
            }
            if (tempDir != null && (f = new File(tempDir)).exists()) {
                try {
                    this.removeDir(f);
                }
                catch (SecurityException e) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "destroy", nls.getString("Did.not.have.access.to.delete.Directory"));
                }
            }
        }
        if (AsyncContextImpl.executorRetrieved.get()) {
            logger.logp(Level.INFO, CLASS_NAME, "destroy", "shutting down async servlet thread pool exucutor");
            AsyncContextImpl.ExecutorFieldHolder.field.shutdown();
            try {
                AsyncContextImpl.ExecutorFieldHolder.field.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.logp(Level.FINE, CLASS_NAME, "destroy", "There was some interruption : " + e.getMessage());
            }
        }
    }

    private boolean removeDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.removeDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void shutdown() {
        this.destroy();
    }

    public void addWebApplication(DeployedModule deployedModule) throws WebAppNotLoadedException {
        try {
            appInstallBegun = true;
            this.addWebApp(deployedModule);
        }
        catch (WebAppNotLoadedException e) {
            throw e;
        }
        catch (Throwable th) {
            FFDCWrapper.processException(th, CLASS_NAME, "695", this);
            throw new WebAppNotLoadedException(th.getMessage(), th);
        }
    }

    protected void addWebApp(DeployedModule dm) throws WebAppNotLoadedException {
        try {
            VirtualHost vHost;
            String virtualHost = dm.getVirtualHostName();
            if (virtualHost == null || virtualHost.equals("")) {
                virtualHost = DEFAULT_HOST;
            }
            if ((vHost = this.getVirtualHost(virtualHost)) == null) {
                logger.logp(Level.INFO, CLASS_NAME, "addWebApp", "host.has.not.been.defined", new String[]{virtualHost});
                throw new WebAppNotLoadedException("Virtual Host " + virtualHost + " not found");
            }
            com.ibm.wsspi.adaptable.module.Container mc = dm.getWebApp().getModuleContainer();
            WebExt ext = null;
            if (mc != null) {
                try {
                    ext = (WebExt)mc.adapt(WebExt.class);
                }
                catch (UnableToAdaptException e) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "commonInitializationFinally", "Unable to parse the WebExt file", e);
                    }
                    ext = null;
                }
            }
            if (ext != null) {
                dm.getWebAppConfig().setInitializeWebExtProps(ext);
            }
            vHost.addWebApplication(dm, extensionFactories);
        }
        catch (WebAppNotLoadedException wahnf) {
            FFDCFilter.processException((Throwable)wahnf, (String)"com.ibm.ws.webcontainer.Webcontainer", (String)"732", (Object)this);
            throw wahnf;
        }
        catch (Throwable th) {
            FFDCWrapper.processException(th, CLASS_NAME, "736", this);
            throw new WebAppNotLoadedException(th.getMessage(), th);
        }
    }

    public VirtualHost getVirtualHost(String targetHost) throws WebAppHostNotFoundException {
        Iterator i = this.requestMapper.targetMappings();
        while (i.hasNext()) {
            VirtualHost vHost;
            RequestProcessor rp = (RequestProcessor)i.next();
            if (!(rp instanceof VirtualHost) || !targetHost.equalsIgnoreCase((vHost = (VirtualHost)rp).getName())) continue;
            return vHost;
        }
        return null;
    }

    public void removeWebApplication(DeployedModule deployedModule) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeWebApplication", "Deployed Module Virtual Host Name:", deployedModule.getVirtualHostName());
        }
        try {
            VirtualHost vHost = this.getVirtualHost(deployedModule.getVirtualHostName());
            if (vHost == null) {
                throw new WebAppHostNotFoundException("VirtualHost not found");
            }
            vHost.removeWebApplication(deployedModule);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "removeWebApplication", "Exception", new Object[]{e});
            throw e;
        }
    }

    public static WebContainer getWebContainer() {
        WebContainer selfInstance = self.get();
        if (selfInstance != null) {
            return selfInstance;
        }
        CountDownLatch currentLatch = selfInit;
        try {
            currentLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        currentLatch.countDown();
        return self.get();
    }

    public void setSessionRegistry(SessionRegistry sessRegistry) {
        this.sessionRegistry = sessRegistry;
    }

    public void restartWebApplication(String moduleName) throws WebAppNotLoadedException {
    }

    public void reload(DeployedModule webModuleConfig) throws WebAppNotLoadedException {
        this.restartWebApplication(webModuleConfig);
    }

    public void restartWebApplication(DeployedModule webModuleConfig) throws WebAppNotLoadedException {
        try {
            this.removeWebApplication(webModuleConfig);
        }
        catch (Exception e) {
            String groupName = webModuleConfig.getName();
            String message = nls.getFormattedMessage("failed.to.remove.webmodule", new Object[]{groupName, e}, "Failed to remove web module");
            logger.logp(Level.SEVERE, CLASS_NAME, "restartWebApplication", message);
            return;
        }
        this.addWebApplication(webModuleConfig);
    }

    public abstract boolean areRequestsOutstanding();

    public WebContainerConfiguration getWebContainerConfig() {
        return this.wcconfig;
    }

    public IHttpSessionContext getSessionContext(DeployedModule moduleConfig, WebApp webApp, String host, ArrayList[] listeners) throws Throwable {
        try {
            return this.getSessionRegistry().getSessionContext(moduleConfig, webApp, host, listeners);
        }
        catch (Throwable e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getSessionContext", nls.getString("unable.to.get.sessionContext"), e);
            return null;
        }
    }

    protected SessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    public void handleRequest(IRequest req, IResponse res) throws IOException {
        this.handleRequest(req, res, null, null);
    }

    public static String getHostAliasKey(String host, int port) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHostAliasKey", "host-->" + host + ", port-->" + port);
        }
        StringBuilder vhostKey = new StringBuilder();
        String serverName = host;
        if (serverName != null && serverName.length() > 0) {
            if (serverName.charAt(0) == '[' && serverName.charAt(serverName.length() - 1) == ']') {
                serverName = serverName.substring(1, serverName.length() - 1);
            }
            vhostKey.append(serverName.toLowerCase());
        }
        vhostKey.append(':');
        vhostKey.append(port);
        return vhostKey.toString();
    }

    /*
     * Exception decompiling
     */
    public void handleRequest(IRequest req, IResponse res, VirtualHost vhost, RequestProcessor processor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Properties getWebContainerProperties() {
        return webConProperties;
    }

    protected abstract SRTConnectionContext getConnectionContext();

    protected abstract void releaseConnectionContext(SRTConnectionContext var1);

    public static void addToCache(HttpServletRequest req, RequestProcessor s, WebApp app) {
        if (_cacheSize.get() >= invocationCacheSize) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addToCache", "cache is full");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addToCache", "WebApp = " + app);
        }
        if (app.getDestroyed()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addToCache", "Not caching as the webapp is destroyed");
            }
            return;
        }
        StringBuilder cacheKey = (StringBuilder)cacheKeyStringBuilder.get();
        if (cacheKey == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addToCache", "cache key is null");
            }
            return;
        }
        String cacheKeyStr = cacheKey.toString();
        CacheServletWrapper wrapper = cacheServletWrapperFactory.createCacheServletWrapper((IServletWrapper)s, req, cacheKeyStr, app);
        if (_cacheMap.containsKey(cacheKeyStr) || _cacheMap.putIfAbsent(cacheKeyStr, wrapper) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addToCache", "Already cached cacheKey --> " + cacheKey);
            }
        } else {
            ((IServletWrapper)s).addServletReferenceListener(wrapper);
            _cacheSize.incrementAndGet();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addToCache", "Added to cache cacheKey --> " + cacheKey + " uri -->" + req.getRequestURI() + " servletWrapper -->" + ((IServletWrapper)s).getServletName());
            }
        }
    }

    public static CacheServletWrapper getFromCache(CharSequence key) {
        return (CacheServletWrapper)_cacheMap.get(key.toString());
    }

    public static CacheServletWrapper removeFromCache(CharSequence key) {
        CacheServletWrapper wrapper = (CacheServletWrapper)_cacheMap.remove(key.toString());
        if (wrapper != null) {
            _cacheSize.decrementAndGet();
        }
        return wrapper;
    }

    public Integer getKeySize(String cipherSuite) {
        String keySize = (String)this._cipherToBit.get(cipherSuite);
        if (keySize == null || keySize.equals("") || keySize.equals("-1")) {
            return null;
        }
        return new Integer(keySize);
    }

    public Integer getKeySizefromCipherMap(String cipherSuite) {
        return (Integer)ReadCipherBitSize.cipherData.get(cipherSuite);
    }

    public void addExtensionFactory(ExtensionFactory factory) {
        List l = factory.getPatternList();
        Iterator it = l.iterator();
        StringBuilder mapStr = new StringBuilder(32);
        while (it.hasNext()) {
            String mapping = (String)it.next();
            mapStr.append(mapping);
            mapStr.append(' ');
        }
        logger.logp(Level.INFO, CLASS_NAME, "addExtensionFactory", "ExtensionFactory.[{0}].registered.successfully", new Object[]{factory.getClass().toString()});
        logger.logp(Level.INFO, CLASS_NAME, "addExtensionFactory", "ExtensionFactory.[{0}].associated.with.patterns.[{1}]", new Object[]{factory.getClass().toString(), mapStr.toString()});
        if (!appInstallBegun) {
            extensionFactories.add(factory);
        } else {
            Iterator<VirtualHost> vhosts = this.getVirtualHosts();
            while (vhosts.hasNext()) {
                DynamicVirtualHost vhost = (DynamicVirtualHost)vhosts.next();
                Iterator<com.ibm.ws.webcontainer.osgi.webapp.WebApp> webApps = vhost.getWebApps();
                while (webApps.hasNext()) {
                    WebApp webApp = webApps.next();
                    webApp.addExtensionFactory(factory);
                }
            }
        }
    }

    public static void addHttpServletResponseListener(IHttpServletResponseListener listener) {
        if (listener != null) {
            httpResponseListeners.add(listener);
        }
    }

    public static void notifyHttpServletResponseListenersPreHeaderCommit(HttpServletRequest request, HttpServletResponse response) {
        int listenerSize = httpResponseListeners.size();
        if (listenerSize != 0) {
            for (int i = 0; i < listenerSize; ++i) {
                IHttpServletResponseListener rL = (IHttpServletResponseListener)httpResponseListeners.get(i);
                rL.preHeaderCommit(request, response);
            }
        }
    }

    public static List getApplicationListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return applicationListeners;
    }

    public static List getServletErrorListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletErrorListeners;
    }

    public static List getServletInvocationListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletInvocationListeners;
    }

    public static List getFilterInvocationListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterInvocationListeners;
    }

    public static List getFilterListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterListeners;
    }

    public static List getFilterErrorListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterErrorListeners;
    }

    public static List getServletContextAttributeListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextAttributeListeners;
    }

    public static List getServletContextListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextListeners;
    }

    public static List getServletRequestAttributeListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestAttributeListeners;
    }

    public static List getServletRequestListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestListeners;
    }

    public static List getSessionListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionListeners;
    }

    public static List getSessionAttributeListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionAttributeListeners;
    }

    public static List getSessionIdListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionIdListeners;
    }

    public static List getServletListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletListeners;
    }

    public List getExtensionFactories() {
        return extensionFactories;
    }

    protected static String truncateURI(String uri) {
        if (uri.length() > 128) {
            uri = uri.substring(0, 127);
        }
        return uri;
    }

    public String getURIEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        if (!this.getPlatformHelper().isDecodeURIPlatform()) {
            this.decode = false;
        }
        this.encoding = "UTF-8";
        if (!WCCustomProperties.DECODE_URL_AS_UTF8) {
            this.encoding = ISO;
            this.decode = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getURIEncoding", "encoding -->" + this.encoding + " decode -->" + this.decode);
        }
        return this.encoding;
    }

    public boolean isEnableSecurityAtWARBoundary() {
        return false;
    }

    public boolean isEnableSecurityAtEARBoundary() {
        return false;
    }

    private PathInfoHelper removeExtraPathInfo(String pathInfo) {
        if (pathInfo == null) {
            return null;
        }
        int semicolon = pathInfo.indexOf(59);
        if (semicolon != -1) {
            String tmpPathInfo = pathInfo.substring(0, semicolon);
            String extraPathInfo = pathInfo.substring(semicolon);
            return new PathInfoHelper(tmpPathInfo, extraPathInfo);
        }
        return new PathInfoHelper(pathInfo, null);
    }

    public static Iterator getCachedServletWrapperNames() {
        Set cacheSet = _cacheMap.keySet();
        ArrayList l = new ArrayList(cacheSet);
        return l.listIterator();
    }

    protected boolean isVHostCompatFlag() {
        return this.vHostCompatFlag;
    }

    protected void setVHostCompatFlag(boolean hostCompatFlag) {
        this.vHostCompatFlag = hostCompatFlag;
    }

    public Iterator<VirtualHost> getVirtualHosts() {
        return this.getTargetMappings();
    }

    public static void sendAppUnavailableException(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req instanceof SRTServletRequest && res instanceof SRTServletResponse) {
            IRequest ireq = ((SRTServletRequest)req).getIRequest();
            IResponse ires = ((SRTServletResponse)res).getIResponse();
            WebContainer.sendUnavailableException(ireq, ires);
        }
    }

    protected static void sendUnavailableException(IRequest req, IResponse res) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sendUnavailableException", "Inside sendUnavailableException");
        }
        res.addHeader("Content-Type", "text/html");
        res.setStatusCode(503);
        String formattedMessage = nls.getFormattedMessage("Servlet.has.become.temporarily.unavailable.for.service:.{0}", new Object[]{WebContainer.truncateURI(req.getRequestURI())}, "Servlet has become temporarily unavailable for service");
        String output = "<H1>" + formattedMessage + "</H1><BR>";
        byte[] outBytes = output.getBytes();
        res.getOutputStream().write(outBytes, 0, outBytes.length);
        logger.logp(Level.SEVERE, CLASS_NAME, "sendUnavailableException", formattedMessage);
    }

    public synchronized void setWebContainerStopping(boolean isStopped) {
        try {
            this.readWriteLockForStopping.writeLock().lock();
            this.isStopped = isStopped;
        }
        finally {
            this.readWriteLockForStopping.writeLock().unlock();
        }
    }

    public static boolean isDefaultTempDir() {
        return isDefaultTempDir;
    }

    public static void setIsDefaultTempDir(boolean isTempDir) {
        isDefaultTempDir = isTempDir;
    }

    public static String getTempDir() {
        return tempDir;
    }

    public static void setTempDir(String tempD) {
        tempDir = tempD;
    }

    public IPlatformHelper getPlatformHelper() {
        if (this.platformHelper == null) {
            this.platformHelper = new PlatformHelper();
        }
        return this.platformHelper;
    }

    protected static boolean isServletCachingInitNeeded() {
        return servletCachingInitNeeded;
    }

    public static void setServletCachingInitNeeded(boolean bool) {
        servletCachingInitNeeded = bool;
    }

    public boolean isCachingEnabled() {
        return false;
    }

    public ClassLoader getExtClassLoader() {
        return WebContainer.class.getClassLoader();
    }

    public static synchronized Iterator<ServletContainerInitializer> getServletContainerInitializers() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServletContainerInitializers", "servletContainerInitializers->" + servletContainerInitializers.iterator());
        }
        return servletContainerInitializers.iterator();
    }

    public abstract void decrementNumRequests();

    public abstract AsyncContextFactory getAsyncContextFactory();

    public abstract URIMatcherFactory getURIMatcherFactory();

    public static void sendBadRequestResponse(IRequest req, IResponse res) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "sendBadRequestResponse");
        }
        res.addHeader("Content-Type", "text/html");
        res.setStatusCode(400);
        String formattedMessage = nls.getFormattedMessage("bad.request.uri:.{0}", new Object[]{ResponseUtils.encodeDataString(WebContainer.truncateURI(req.getRequestURI()))}, "Bad request URI");
        String output = "<H1>" + formattedMessage + "</H1><BR>";
        byte[] outBytes = output.getBytes();
        res.getOutputStream().write(outBytes, 0, outBytes.length);
        logger.exiting(CLASS_NAME, "sendBadRequestResponse - 400 Bad Request [" + formattedMessage + "]");
    }

    static {
        logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer");
        nls = TraceNLS.getTraceNLS(WebContainer.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
        self = new AtomicReference();
        selfInit = new CountDownLatch(1);
        cacheKeyStringBuilder = new WSThreadLocal();
        listenersInitialized = false;
        webConProperties = new Properties();
        extensionFactories = new ArrayList<ExtensionFactory>();
        httpResponseListeners = new ArrayList();
        invocationCacheSize = 500;
        servletContainerInitializers = ServiceLoader.load(ServletContainerInitializer.class, WebContainer.class.getClassLoader());
        String invocationCacheSizeStr = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("invocationCacheSize");
            }
        });
        if (invocationCacheSizeStr != null) {
            try {
                invocationCacheSize = Integer.parseInt(invocationCacheSizeStr) * 10;
            }
            catch (NumberFormatException e) {
                invocationCacheSize = 500;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "<static init>", "context classloader->" + Thread.currentThread().getContextClassLoader() + ", webcontainer classloader->" + WebContainer.class.getClassLoader());
        }
        _cacheMap = new ConcurrentHashMap(invocationCacheSize);
        _cacheSize = new AtomicInteger();
        isDefaultTempDir = false;
        tempDir = null;
        servletCachingInitNeeded = true;
        appInstallBegun = false;
    }

    private class PathInfoHelper {
        private String basePath = null;
        private String extraPathInfo = null;

        private PathInfoHelper(String pathInfo, String extraPathInfo) {
            this.basePath = pathInfo;
            this.extraPathInfo = extraPathInfo;
        }

        private String getExtraPathInfo() {
            return this.extraPathInfo;
        }

        private String getBasePath() {
            return this.basePath;
        }

        static /* synthetic */ String access$000(PathInfoHelper x0) {
            return x0.getBasePath();
        }

        static /* synthetic */ String access$100(PathInfoHelper x0) {
            return x0.getExtraPathInfo();
        }
    }

    private static class ReadCipherBitSize {
        private static HashMap<String, Integer> cipherData = new HashMap();

        private ReadCipherBitSize() {
        }

        static {
            cipherData.put("SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 256);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 256);
            cipherData.put("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_RSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_RSA_WITH_AES_256_CBC_SHA384", 256);
            cipherData.put("SSL_RSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", 256);
            cipherData.put("SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_ECDH_RSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_ECDH_RSA_WITH_AES_256_CBC_SHA384", 256);
            cipherData.put("SSL_ECDH_RSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_ECDH_anon_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_DHE_DSS_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_DHE_DSS_WITH_AES_256_CBC_SHA256", 256);
            cipherData.put("SSL_DHE_DSS_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_DHE_RSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_DHE_RSA_WITH_AES_256_CBC_SHA256", 256);
            cipherData.put("SSL_DHE_RSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_DH_anon_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("SSL_DH_anon_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("SSL_DH_anon_WITH_AES_256_CBC_SHA256", 256);
            cipherData.put("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_ECDH_anon_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_DH_anon_WITH_DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_KRB5_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("SSL_KRB5_WITH_3DES_EDE_CBC_MD5", 168);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_RSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_RSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_RSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_ECDH_RSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_ECDH_RSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_ECDH_RSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_DHE_RSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_DHE_RSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_DHE_RSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_DHE_DSS_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_DHE_DSS_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_DHE_DSS_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_DH_anon_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_DH_anon_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("SSL_DH_anon_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("SSL_ECDH_anon_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("SSL_RSA_WITH_RC4_128_MD5", 128);
            cipherData.put("SSL_RSA_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_DHE_DSS_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_ECDHE_RSA_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_ECDH_ECDSA_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_ECDH_RSA_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_DH_anon_WITH_RC4_128_MD5", 128);
            cipherData.put("SSL_ECDH_anon_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_KRB5_WITH_RC4_128_SHA", 128);
            cipherData.put("SSL_KRB5_WITH_RC4_128_MD5", 128);
            cipherData.put("SSL_RSA_FIPS_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_RSA_FIPS_WITH_DES_EDE_CBC_SHA", 56);
            cipherData.put("SSL_DH_DSS_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_DH_RSA_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_DHE_DSS_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_DHE_RSA_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_DH_anon_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_RSA_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_RSA_FIPS_WITH_DES_EDE_CBC_SHA", 56);
            cipherData.put("SSL_DHE_RSA_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_DHE_DSS_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_KRB5_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_KRB5_WITH_DES_CBC_MD5", 56);
            cipherData.put("SSL_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 56);
            cipherData.put("SSL_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 56);
            cipherData.put("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 40);
            cipherData.put("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 40);
            cipherData.put("SSL_KRB5_EXPORT_WITH_RC4_40_SHA", 40);
            cipherData.put("SSL_KRB5_EXPORT_WITH_RC4_40_MD5", 40);
            cipherData.put("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 40);
            cipherData.put("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 40);
            cipherData.put("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 40);
            cipherData.put("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 40);
            cipherData.put("SSL_RSA_WITH_NULL_SHA", 0);
            cipherData.put("SSL_RSA_WITH_NULL_SHA", 0);
            cipherData.put("SSL_RSA_WITH_NULL_SHA256", 0);
            cipherData.put("SSL_ECDH_ECDSA_WITH_NULL_SHA", 0);
            cipherData.put("SSL_ECDH_RSA_WITH_NULL_SHA", 0);
            cipherData.put("SSL_ECDHE_ECDSA_WITH_NULL_SHA", 0);
            cipherData.put("SSL_ECDHE_RSA_WITH_NULL_SHA", 0);
            cipherData.put("SSL_ECDH_anon_WITH_NULL_SHA", 0);
            cipherData.put("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", 40);
            cipherData.put("SSL_FORTEZZA_KEA_WITH_NULL_SHA", 0);
            cipherData.put("RC4-MD5", 128);
            cipherData.put("EXP-RC4-MD5", 128);
            cipherData.put("RC2-MD5", 128);
            cipherData.put("EXP-RC2-MD5", 128);
            cipherData.put("IDEA-CBC-MD5", 128);
            cipherData.put("DES-CBC-MD5", 64);
            cipherData.put("DES-CBC3-MD5", 192);
            cipherData.put("NULL-MD5", 0);
            cipherData.put("NULL-SHA", 0);
            cipherData.put("EXP-RC4-MD5", 40);
            cipherData.put("RC4-MD5", 128);
            cipherData.put("RC4-SHA", 128);
            cipherData.put("EXP-RC2-CBC-MD5", 40);
            cipherData.put("IDEA-CBC-SHA", 128);
            cipherData.put("EXP-DES-CBC-SHA", 40);
            cipherData.put("DES-CBC-SHA", 56);
            cipherData.put("DES-CBC3-SHA", 168);
            cipherData.put("EXP-EDH-DSS-DES-CBC-SHA", 40);
            cipherData.put("EDH-DSS-CBC-SHA", 56);
            cipherData.put("EDH-DSS-DES-CBC3-SHA", 168);
            cipherData.put("EXP-EDH-RSA-DES-CBC-SHA", 40);
            cipherData.put("EDH-RSA-DES-CBC-SHA", 56);
            cipherData.put("EDH-RSA-DES-CBC3-SHA", 168);
            cipherData.put("EXP-ADH-RC4-MD5", 40);
            cipherData.put("ADH-RC4-MD5", 128);
            cipherData.put("EXP-ADH-DES-CBC-SHA", 40);
            cipherData.put("ADH-DES-CBC-SHA", 56);
            cipherData.put("ADH-DES-CBC3-SHA", 168);
            cipherData.put("AES128-SHA", 128);
            cipherData.put("AES256-SHA", 256);
            cipherData.put("DH-DSS-AES128-SHA", 128);
            cipherData.put("DH-DSS-AES256-SHA", 256);
            cipherData.put("DH-RSA-AES128-SHA", 128);
            cipherData.put("DH-RSA-AES256-SHA", 256);
            cipherData.put("DHE-DSS-AES128-SHA", 128);
            cipherData.put("DHE-DSS-AES256-SHA", 256);
            cipherData.put("DHE-RSA-AES128-SHA", 128);
            cipherData.put("DHE-RSA-AES256-SHA", 256);
            cipherData.put("ADH-AES128-SHA", 128);
            cipherData.put("ADH-AES256-SHA", 256);
            cipherData.put("EXP1024-DES-CBC-SHA", 56);
            cipherData.put("EXP1024-RC4-SHA", 56);
            cipherData.put("EXP1024-DHE-DSS-DES-CBC-SHA", 56);
            cipherData.put("EXP1024-DHE-DSS-RC4-SHA", 56);
            cipherData.put("DHE-DSS-RC4-SHA", 128);
            cipherData.put("TLS_RSA_WITH_NULL_NULL", 0);
            cipherData.put("TLS_RSA_WITH_NULL_MD5", 0);
            cipherData.put("TLS_RSA_WITH_NULL_SHA", 0);
            cipherData.put("TLS_RSA_EXPORT_WITH_RC4_40_MD5", 40);
            cipherData.put("TLS_RSA_WITH_RC4_128_MD5", 128);
            cipherData.put("TLS_RSA_WITH_RC4_128_SHA", 128);
            cipherData.put("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5,", 40);
            cipherData.put("TLS_RSA_WITH_DES_CBC_SHA", 56);
            cipherData.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA", 56);
            cipherData.put("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA", 56);
            cipherData.put("SSL_RSA_FIPS_WITH_DES_CBC_SHA", 56);
            cipherData.put("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("TLS_RSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("TLS_RSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("TLS_ECDHE_RSA_WITH_RC4_128_SHA", 128);
            cipherData.put("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", 128);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("TLS_RSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("TLS_RSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("TLS_RSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("TLS_RSA_WITH_AES_256_CBC_SHA256", 256);
            cipherData.put("TLS_RSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("TLS_RSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", 168);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 128);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 256);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 256);
            cipherData.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 128);
            cipherData.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 256);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 128);
            cipherData.put("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 256);
            cipherData.put("TLS_RSA_WITH_NULL_SHA256", 0);
            cipherData.put("TLS_RSA_WITH_NULL_SHA", 0);
            cipherData.put("TLS_ECDHE_RSA_WITH_NULL_SHA", 0);
            cipherData.put("TLS_ECDHE_ECDSA_WITH_NULL_SHA", 0);
        }
    }
}

